/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Param;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Wadgetitem
implements Serializable,
Cloneable,
IRNode {
    private String name_;
    private String filename_;
    private Integer order_;
    private Boolean standard_;
    private List param_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public Wadgetitem() {
    }

    public Wadgetitem(Wadgetitem source) {
        this.setup(source);
    }

    public Wadgetitem(RStack stack) {
        this.setup(stack);
    }

    public Wadgetitem(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Wadgetitem(Element element) {
        this.setup(element);
    }

    public Wadgetitem(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Wadgetitem(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Wadgetitem(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Wadgetitem(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Wadgetitem(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Wadgetitem(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Wadgetitem source) {
        this.setName(source.getName());
        this.setFilename(source.getFilename());
        this.setOrder(source.getOrder());
        this.setStandard(source.getStandard());
        this.param_.clear();
        int size = source.param_.size();
        for (int i = 0; i < size; ++i) {
            this.addParam((Param)source.getParam(i).clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.filename_ = URelaxer.getAttributePropertyAsString(element, "filename");
        this.order_ = URelaxer.getAttributePropertyAsIntObject(element, "order");
        this.standard_ = URelaxer.getAttributePropertyAsBooleanObject(element, "standard");
        this.param_.clear();
        while (Param.isMatch(stack)) {
            this.addParam(factory.createParam(stack));
        }
    }

    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createWadgetitem(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("wadgetitem");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.filename_ != null) {
            URelaxer.setAttributePropertyByString(element, "filename", this.filename_);
        }
        if (this.order_ != null) {
            URelaxer.setAttributePropertyByInt(element, "order", this.order_);
        }
        if (this.standard_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "standard", this.standard_);
        }
        int size = this.param_.size();
        for (int i = 0; i < size; ++i) {
            Param value = (Param)this.param_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getFilename() {
        return this.filename_;
    }

    public final void setFilename(String filename) {
        this.filename_ = filename;
    }

    public int getOrder() {
        if (this.order_ == null) {
            return -1;
        }
        return this.order_;
    }

    public int getOrder(int order) {
        if (this.order_ == null) {
            return order;
        }
        return this.order_;
    }

    public Integer getOrderAsInteger() {
        return this.order_;
    }

    public boolean checkOrder() {
        return this.order_ != null;
    }

    public void setOrder(int order) {
        this.order_ = new Integer(order);
    }

    public void setOrder(Integer order) {
        this.order_ = order;
    }

    public boolean getStandard() {
        if (this.standard_ == null) {
            return false;
        }
        return this.standard_;
    }

    public boolean getStandard(boolean standard) {
        if (this.standard_ == null) {
            return standard;
        }
        return this.standard_;
    }

    public Boolean getStandardAsBoolean() {
        return this.standard_;
    }

    public boolean checkStandard() {
        return this.standard_ != null;
    }

    public void setStandard(boolean standard) {
        this.standard_ = new Boolean(standard);
    }

    public void setStandard(Boolean standard) {
        this.standard_ = standard;
    }

    public final Param[] getParam() {
        Param[] array = new Param[this.param_.size()];
        return this.param_.toArray(array);
    }

    public final void setParam(Param[] param) {
        int i;
        this.param_.clear();
        if (param != null) {
            for (i = 0; i < param.length; ++i) {
                this.addParam(param[i]);
            }
        }
        for (i = 0; i < param.length; ++i) {
            param[i].rSetParentRNode(this);
        }
        for (i = 0; i < param.length; ++i) {
            param[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setParam(Param param) {
        this.param_.clear();
        this.addParam(param);
        if (param != null) {
            param.rSetParentRNode(this);
        }
        if (param != null) {
            param.rSetRContext(this.rGetRContext());
        }
    }

    public final void addParam(Param param) {
        this.param_.add(param);
        if (param != null) {
            param.rSetParentRNode(this);
        }
        if (param != null) {
            param.rSetRContext(this.rGetRContext());
        }
    }

    public final void addParam(Param[] param) {
        int i;
        for (i = 0; i < param.length; ++i) {
            this.addParam(param[i]);
        }
        for (i = 0; i < param.length; ++i) {
            param[i].rSetParentRNode(this);
        }
        for (i = 0; i < param.length; ++i) {
            param[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeParam() {
        return this.param_.size();
    }

    public final Param getParam(int index) {
        return (Param)this.param_.get(index);
    }

    public final void setParam(int index, Param param) {
        this.param_.set(index, param);
        if (param != null) {
            param.rSetParentRNode(this);
        }
    }

    public final void addParam(int index, Param param) {
        this.param_.add(index, param);
        if (param != null) {
            param.rSetParentRNode(this);
        }
    }

    public final void removeParam(int index) {
        this.param_.remove(index);
    }

    public final void removeParam(Param param) {
        this.param_.remove(param);
    }

    public final void clearParam() {
        this.param_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<wadgetitem");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.filename_ != null) {
            buffer.append(" filename=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getFilename())));
            buffer.append("\"");
        }
        if (this.order_ != null) {
            buffer.append(" order=\"");
            buffer.append(URelaxer.getString(this.getOrder()));
            buffer.append("\"");
        }
        if (this.standard_ != null) {
            buffer.append(" standard=\"");
            buffer.append(URelaxer.getString(this.getStandard()));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.param_.size();
        for (int i = 0; i < size; ++i) {
            Param value = (Param)this.param_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</wadgetitem>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<wadgetitem");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.filename_ != null) {
            buffer.write(" filename=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getFilename())));
            buffer.write("\"");
        }
        if (this.order_ != null) {
            buffer.write(" order=\"");
            buffer.write(URelaxer.getString(this.getOrder()));
            buffer.write("\"");
        }
        if (this.standard_ != null) {
            buffer.write(" standard=\"");
            buffer.write(URelaxer.getString(this.getStandard()));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.param_.size();
        for (int i = 0; i < size; ++i) {
            Param value = (Param)this.param_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</wadgetitem>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<wadgetitem");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.filename_ != null) {
            buffer.print(" filename=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getFilename())));
            buffer.print("\"");
        }
        if (this.order_ != null) {
            buffer.print(" order=\"");
            buffer.print(URelaxer.getString(this.getOrder()));
            buffer.print("\"");
        }
        if (this.standard_ != null) {
            buffer.print(" standard=\"");
            buffer.print(URelaxer.getString(this.getStandard()));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.param_.size();
        for (int i = 0; i < size; ++i) {
            Param value = (Param)this.param_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</wadgetitem>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getFilenameAsString() {
        return URelaxer.getString(this.getFilename());
    }

    public String getOrderAsString() {
        return URelaxer.getString(this.getOrder());
    }

    public String getStandardAsString() {
        return URelaxer.getString(this.getStandard());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setFilenameByString(String string) {
        this.setFilename(string);
    }

    public void setOrderByString(String string) {
        this.setOrder(Integer.parseInt(string));
    }

    public void setStandardByString(String string) {
        this.setStandard((boolean)new Boolean(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.param_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "wadgetitem")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (Param.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Wadgetitem.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Wadgetitem.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

