/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.openapi.Toolbox;

public class ComponentSchemaFactory {
    public static Map<String, SecurityScheme> createSecuritySchemes() {
        SecurityScheme cookie = new SecurityScheme();
        cookie.setType(SecurityScheme.Type.APIKEY);
        cookie.setName("JSESSIONID");
        cookie.setIn(SecurityScheme.In.COOKIE);
        SecurityScheme autoLogonAuth = new SecurityScheme();
        autoLogonAuth.setType(SecurityScheme.Type.APIKEY);
        autoLogonAuth.setName("X-Wagby-Authorization");
        autoLogonAuth.setIn(SecurityScheme.In.HEADER);
        LinkedHashMap<String, SecurityScheme> results = new LinkedHashMap<String, SecurityScheme>();
        results.put("cookieAuth", cookie);
        results.put("autoLogonAuth", autoLogonAuth);
        return results;
    }

    public static Map<String, Schema<?>> createErrorSchema() {
        ObjectSchema errorInfo = new ObjectSchema();
        errorInfo.setName("ErrorInfo");
        errorInfo.addProperties("content", (Schema)new StringSchema());
        errorInfo.addProperties("code", (Schema)new StringSchema());
        errorInfo.addProperties("name", (Schema)new StringSchema());
        errorInfo.addProperties("sanitize", (Schema)new BooleanSchema());
        ArraySchema errorAttr = new ArraySchema();
        errorAttr.setItems((Schema)Toolbox.createRef("ErrorInfo"));
        ObjectSchema errors = new ObjectSchema();
        errors.setName("Errors");
        errors.addProperties("jfcdebug", (Schema)errorAttr);
        errors.addProperties("jfcinfo", (Schema)errorAttr);
        errors.addProperties("jfcwarn", (Schema)errorAttr);
        errors.addProperties("jfcerror", (Schema)errorAttr);
        ObjectSchema errorsWM = new ObjectSchema();
        errorsWM.setName("ErrorsWithMessage");
        errorsWM.addProperties("message", Toolbox.addProps(new StringSchema(), "\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8", null, null));
        errorsWM.addProperties("pkey", Toolbox.addProps(new StringSchema(), "\u4e3b\u30ad\u30fc", "1000", null));
        errorsWM.addProperties("timestamp", Toolbox.addProps(new IntegerSchema(), "\u5354\u5b9a\u4e16\u754c\u6642(UTC) 1970\u5e741\u67081\u65e500:00:00\u304b\u3089\u306e\u7d4c\u904e\u6642\u9593\u3092\u30df\u30ea\u79d2\u5358\u4f4d\u3067\u8868\u3059\u6642\u523b", null, "int64"));
        errorsWM.addProperties("status", (Schema)new IntegerSchema());
        errorsWM.addProperties("path", (Schema)new StringSchema());
        errorsWM.addProperties("error", (Schema)new StringSchema());
        errorsWM.addProperties("errors", (Schema)Toolbox.createRef("Errors"));
        LinkedHashMap results = new LinkedHashMap();
        results.put(errorInfo.getName(), (Schema<?>)errorInfo);
        results.put(errors.getName(), (Schema<?>)errors);
        results.put(errorsWM.getName(), (Schema<?>)errorsWM);
        return results;
    }
}

