/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.appgen.generator.AppschemaBasedGenerator;
import jp.jasminesoft.jfc.gen.appschema.Openapi;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.openapi.OpenAPIBuilder;
import jp.jasminesoft.jfc.gen.openapi.OpenAPIWriter;
import jp.jasminesoft.jfc.gen.openapi.bridge.AppschemaTransformer;
import jp.jasminesoft.jfc.gen.openapi.bridge.BrdgModel;
import jp.jasminesoft.jfc.gen.openapi.spec.LogOnOffSpec;
import jp.jasminesoft.jfc.gen.openapi.spec.Metadata;
import jp.jasminesoft.jfc.gen.openapi.spec.ModelSpecImpl;

public class OpenAPIGenerator
extends AppschemaBasedGenerator {
    private OpenAPIWriter.OutputFormat outputFormat = OpenAPIWriter.OutputFormat.YAML;

    public OpenAPIGenerator(Project project) {
        super(project);
    }

    @Override
    protected String getContent() {
        OpenAPIBuilder builder = new OpenAPIBuilder();
        AppschemaTransformer apTrans = new AppschemaTransformer(this.project);
        Metadata metadata = apTrans.getMetadata();
        metadata.setContact("\u554f\u3044\u5408\u308f\u305b\u5148", "https://wagby.com/contact.html", null);
        metadata.setLicense("\u30e9\u30a4\u30bb\u30f3\u30b9", "https://wagby.com");
        metadata.setExternalDocs("WagbyR9\u30de\u30cb\u30e5\u30a2\u30eb", "https://wagby.com/manual9/");
        builder.setMetadata(metadata);
        builder.addModelSpec(new LogOnOffSpec("session", "\u30ed\u30b0\u30aa\u30f3/\u30ed\u30b0\u30aa\u30d5"));
        apTrans.getBridgeModels().forEach((mid, bridgeModel) -> {
            ModelSpecImpl spec = new ModelSpecImpl();
            spec.setBridgeModel((BrdgModel)bridgeModel);
            builder.addModelSpec(spec);
        });
        OpenAPI openAPI = builder.build();
        OpenAPIWriter writer = new OpenAPIWriter();
        try {
            return writer.transform(this.outputFormat, openAPI);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Optional<String> getServerURL(String key) {
        return Arrays.stream(this.project.getEnvironment().getContent()).filter(element -> element instanceof Openapi).map(element -> (Openapi)element).findFirst().map(openapi -> openapi.getParam()).map(Arrays::stream).orElse(Stream.empty()).filter(param -> key.equals(param.getKey())).map(param -> param.getValue()).findFirst();
    }

    @Override
    protected String getFilename() {
        return "openapi." + this.outputFormat.toString().toLowerCase();
    }

    public OpenAPIGenerator outputformat(OpenAPIWriter.OutputFormat outputformat_) {
        this.outputFormat = outputformat_;
        return this;
    }
}

