/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import jp.jasminesoft.jfc.gen.openapi.Str;

public final class Toolbox {
    private Toolbox() {
    }

    public static IntegerSchema createUTCDateSchema(String desc) {
        String tmpDesc = "\u5354\u5b9a\u4e16\u754c\u6642(UTC) 1970\u5e741\u67081\u65e500:00:00\u304b\u3089\u306e\u7d4c\u904e\u6642\u9593\u3092\u30df\u30ea\u79d2\u5358\u4f4d\u3067\u8868\u3059\u6642\u523b";
        if (Str.notEmpty(desc)) {
            tmpDesc = desc;
        }
        return (IntegerSchema)Toolbox.addProps(new IntegerSchema(), tmpDesc, null, "int64");
    }

    public static Parameter createParameter(ParamType paramType, String name, String desc, boolean required, Schema<?> paramSchema) {
        Parameter param = new Parameter();
        param.setIn(paramType.toString());
        param.setName(name);
        if (Str.notEmpty(desc)) {
            param.setDescription(desc);
        }
        if (required) {
            param.setRequired(Boolean.valueOf(required));
        }
        if (paramSchema != null) {
            param.setSchema(paramSchema);
        }
        return param;
    }

    public static StringSchema createRef(String refCompName) {
        StringSchema ref = new StringSchema();
        ref.set$ref("#/components/schemas/" + refCompName);
        return ref;
    }

    public static Schema<?> addProps(Schema<?> schema, String desc, String example, String format) {
        if (Str.notEmpty(desc)) {
            schema.setDescription(desc);
        }
        if (Str.notEmpty(example)) {
            schema.setExample((Object)example);
        }
        if (Str.notEmpty(format)) {
            schema.setFormat(format);
        }
        return schema;
    }

    public static Schema<?> create_jshfilenameSchema() {
        ObjectSchema rawFile = new ObjectSchema();
        rawFile.addProperties("path", Toolbox.addProps(new StringSchema(), "\u30d5\u30a1\u30a4\u30eb\u540d", null, null));
        ObjectSchema jshSchema = new ObjectSchema();
        jshSchema.addProperties("rawFile", (Schema)rawFile);
        jshSchema.addProperties("src", Toolbox.addProps(new StringSchema(), "jshfilename\u5185\u306esrc\u3092\u53c2\u7167\u3059\u308b\u6587\u5b57\u5217", null, null));
        jshSchema.addProperties("title", (Schema)new StringSchema());
        return jshSchema;
    }

    public static Schema<?> createJshfilenamesSchema() {
        ObjectSchema attrItem = new ObjectSchema();
        attrItem.addProperties("data", Toolbox.addProps(new StringSchema(), "\u30d5\u30a1\u30a4\u30eb\u5185\u5bb9\u3092\u4ee5\u4e0b\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3067\u6587\u5b57\u5217\u5316\u3057\u305f\u3082\u306e: data:(content-type);base64; (base64\u30a8\u30f3\u30b3\u30fc\u30c9\u3057\u305f\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf)", null, null));
        attrItem.addProperties("title", Toolbox.addProps(new StringSchema(), "\u30d5\u30a1\u30a4\u30eb\u540d", null, null));
        attrItem.addProperties("src", Toolbox.addProps(new StringSchema(), "(\u9805\u76ee\u540d)_jshfilename.src\u3067\u53c2\u7167\u3059\u308b\u6587\u5b57\u5217", null, null));
        ArraySchema arrsc = new ArraySchema();
        arrsc.setItems((Schema)attrItem);
        return arrsc;
    }

    public static enum ParamType {
        QUERY("query"),
        PATH("path");

        private String key;

        private ParamType(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

