/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi.bridge;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import jp.jasminesoft.jfc.gen.openapi.Toolbox;

class BrdgAttribute {
    private String id;
    private String name;
    private boolean required;
    private String dataType;
    private String example;
    private String format;
    private String refType;
    private String refModelId;
    private String refModelPkey;
    private String refModelPkeyType;

    BrdgAttribute(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String toString() {
        return String.format("[id:%s, name:%s, required:%b, dataType:%s, e.g:%s, format:%s]", this.id, this.name, this.required, this.dataType, this.example, this.format);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean tf) {
        this.required = tf;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setRefModelInfo(String refType, String refModelId, String pkey, String pkeyType) {
        this.refType = refType;
        this.refModelId = refModelId;
        this.refModelPkey = pkey;
        this.refModelPkeyType = pkeyType;
    }

    public Schema<?> toSchema() {
        if (this.getDataType().equalsIgnoreCase("long")) {
            return Toolbox.addProps(new IntegerSchema(), this.getName(), null, "int64");
        }
        if (this.getDataType().equalsIgnoreCase("datetime")) {
            return Toolbox.createUTCDateSchema(this.getName());
        }
        if (this.getDataType().equalsIgnoreCase("date")) {
            return Toolbox.addProps(new StringSchema(), this.getName(), null, "date");
        }
        if (this.getDataType().equalsIgnoreCase("double")) {
            return Toolbox.addProps(new NumberSchema(), this.getName(), null, "double");
        }
        if (this.getDataType().equalsIgnoreCase("float")) {
            return Toolbox.addProps(new NumberSchema(), this.getName(), null, "float");
        }
        StringSchema schema = null;
        if (this.getDataType().equalsIgnoreCase("string")) {
            schema = new StringSchema();
        } else if (this.getDataType().equalsIgnoreCase("int") || this.getDataType().equalsIgnoreCase("short") || this.getDataType().equalsIgnoreCase("byte")) {
            schema = new IntegerSchema();
        } else if (this.getDataType().equalsIgnoreCase("zipcode")) {
            schema = new StringSchema();
        } else if (this.getDataType().equalsIgnoreCase("time")) {
            schema = new StringSchema();
        } else if (this.getDataType().equalsIgnoreCase("storeref")) {
            IntegerSchema inSchema = null;
            if (this.refModelPkeyType.equals("int") || this.refModelPkeyType.equals("short") || this.refModelPkeyType.equals("byte")) {
                inSchema = new IntegerSchema();
            } else if (this.refModelPkeyType.equals("long")) {
                inSchema = Toolbox.addProps(new IntegerSchema(), this.refModelPkey, null, "int64");
            } else if (this.refModelPkeyType.equals("string")) {
                inSchema = new StringSchema();
            } else if (this.refModelPkeyType.equals("date")) {
                inSchema = Toolbox.addProps(new StringSchema(), this.getName(), null, "date");
            } else if (this.refModelPkeyType.equals("datetime")) {
                inSchema = Toolbox.createUTCDateSchema(this.getName());
            } else {
                throw new IllegalArgumentException("ref pkey attr type '" + this.refModelPkeyType + "' on '" + this.refModelId + " (" + this.refModelPkey + ")' is not valid type or NOT-IMPLEMENTED-YET type.");
            }
            if (this.refType.equals("check")) {
                schema = new ArraySchema();
                ((ArraySchema)schema).setItems((Schema)inSchema);
            } else {
                schema = inSchema;
            }
        } else {
            throw new IllegalArgumentException("attr type '" + this.getDataType() + "' on '" + this.id + "' is not valid type or NOT-IMPLEMENTED-YET type.");
        }
        return Toolbox.addProps(schema, this.getName(), null, this.getFormat());
    }
}

