/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi.spec;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.openapi.ApiResponseFactory;
import jp.jasminesoft.jfc.gen.openapi.Toolbox;
import jp.jasminesoft.jfc.gen.openapi.spec.ModelSpecImpl;

public class LogOnOffSpec
extends ModelSpecImpl {
    public LogOnOffSpec(String modelId, String modelName) {
        super.setId(modelId);
        super.setName(modelName);
    }

    @Override
    public Map<String, PathItem> getPathItems() {
        String path = "/rest/session";
        PathItem pathItem = new PathItem();
        pathItem.setPost(this.createPOST());
        pathItem.setDelete(this.createDELETE());
        pathItem.setGet(this.createGET());
        return Collections.singletonMap(path, pathItem);
    }

    @Override
    public Map<String, Schema<?>> getComponentSchema() {
        return LogOnOffSpec.createCommonSchema();
    }

    private Operation createPOST() {
        Operation POST = new Operation();
        POST.setDescription("\u30ed\u30b0\u30aa\u30f3");
        POST.addTagsItem(this.getTag().getName());
        ApiResponse res200 = ApiResponseFactory.create("\u30ed\u30b0\u30aa\u30f3\u6210\u529f", "application/json", Toolbox.createRef("SessionInfo"));
        ApiResponseFactory.addHeader(res200, "Set-Cookie", "JSESSIONID=xxxxyyyyzzzz; Path=/wagby; Secure; HttpOnly");
        ApiResponse res401 = ApiResponseFactory.create("Unauthorized \u30ed\u30b0\u30aa\u30f3\u5931\u6557", null, null);
        ApiResponses resps = new ApiResponses();
        resps.addApiResponse("200", res200);
        resps.addApiResponse("401", res401);
        POST.setResponses(resps);
        return POST;
    }

    private Operation createDELETE() {
        Operation DELETE = new Operation();
        DELETE.setDescription("\u30ed\u30b0\u30aa\u30d5");
        DELETE.addTagsItem(this.getTag().getName());
        SecurityRequirement secReq = new SecurityRequirement();
        secReq.addList("cookieAuth", new ArrayList());
        DELETE.setSecurity(Arrays.asList(secReq));
        StringSchema attr = new StringSchema();
        attr.setExample((Object)"logoff.input");
        ObjectSchema contentSchema = new ObjectSchema();
        contentSchema.addProperties("status", (Schema)attr);
        ApiResponse res200 = ApiResponseFactory.create("\u30ed\u30b0\u30aa\u30d5\u6210\u529f", "application/json", contentSchema);
        ApiResponses resps = new ApiResponses();
        resps.addApiResponse("200", res200);
        DELETE.setResponses(resps);
        return DELETE;
    }

    private Operation createGET() {
        Operation GET = new Operation();
        GET.setDescription("\u30ed\u30b0\u30aa\u30f3\u30e6\u30fc\u30b6\u306e\u60c5\u5831\u3092\u53d6\u5f97");
        GET.addTagsItem(this.getTag().getName());
        SecurityRequirement secReq = new SecurityRequirement();
        secReq.addList("cookieAuth", new ArrayList());
        GET.setSecurity(Arrays.asList(secReq));
        ApiResponse res200 = ApiResponseFactory.create("\u8a8d\u8a3c\u6642 - \u30ec\u30b9\u30dd\u30f3\u30b9\u306f\u300c\u30ed\u30b0\u30aa\u30f3\u30fb\u30ed\u30b0\u30aa\u30d5\u6210\u529f\u6642\u300d\u3068\u540c\u3058\u5185\u5bb9", "application/json", Toolbox.createRef("SessionInfo"));
        ApiResponse res401 = ApiResponseFactory.create("\u672a\u8a8d\u8a3c\u6642 -\u30ec\u30b9\u30dd\u30f3\u30b9\u306e\u5185\u5bb9\u306f\u7a7a", "application/json", new ObjectSchema());
        ApiResponses resps = new ApiResponses();
        resps.addApiResponse("200", res200);
        resps.addApiResponse("401", res401);
        GET.setResponses(resps);
        return GET;
    }

    private static Map<String, Schema<?>> createCommonSchema() {
        ObjectSchema juser = new ObjectSchema();
        juser.setName("JUser");
        juser.addProperties("userid", (Schema)new StringSchema());
        juser.addProperties("mailaddress", (Schema)new StringSchema());
        ArraySchema arr = new ArraySchema();
        arr.setItems((Schema)new StringSchema());
        juser.addProperties("jgroupid", (Schema)arr);
        juser.addProperties("jprincipalId", (Schema)arr);
        juser.addProperties("rule", (Schema)arr);
        juser.addProperties("name", (Schema)new StringSchema());
        juser.addProperties("valid", (Schema)new StringSchema());
        juser.addProperties("level", (Schema)new IntegerSchema());
        juser.addProperties("passwordChangeDate", (Schema)Toolbox.createUTCDateSchema(null));
        juser.addProperties("passwordChangeFlag", Toolbox.addProps(new StringSchema(), null, "on", null));
        juser.addProperties("passwordErrCount", (Schema)new IntegerSchema());
        juser.addProperties("lastLogonDate", (Schema)Toolbox.createUTCDateSchema(null));
        juser.addProperties("avaterImage", (Schema)new StringSchema());
        juser.addProperties("avaterImage_jshfilename", (Schema)new StringSchema());
        juser.addProperties("imprint", (Schema)new StringSchema());
        juser.addProperties("imprint_jshfilename", (Schema)new StringSchema());
        ObjectSchema sessionInfo = new ObjectSchema();
        sessionInfo.setName("SessionInfo");
        sessionInfo.addProperties("groupId", (Schema)arr);
        ObjectSchema pref = new ObjectSchema();
        pref.addProperties("item", (Schema)arr);
        pref.addProperties("id", (Schema)new StringSchema());
        sessionInfo.addProperties("preference", (Schema)pref);
        sessionInfo.addProperties("juser", (Schema)Toolbox.createRef("JUser"));
        sessionInfo.addProperties("passwdChangeFlag", Toolbox.addProps(new StringSchema(), null, "on", null));
        sessionInfo.addProperties("status", Toolbox.addProps(new StringSchema(), null, "logon.afterLogon", null));
        sessionInfo.addProperties("username", (Schema)new StringSchema());
        sessionInfo.addProperties("passwdChangeDate", (Schema)Toolbox.createUTCDateSchema(null));
        LinkedHashMap results = new LinkedHashMap();
        results.put(juser.getName(), (Schema<?>)juser);
        results.put(sessionInfo.getName(), (Schema<?>)sessionInfo);
        return results;
    }
}

