/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.sourcefilemanager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.gen.BuildXmlGenerator;
import jp.jasminesoft.jfc.gen.sourcefilemanager.GeneratedData;
import jp.jasminesoft.jfc.gen.sourcefilemanager.GeneratedDataBuilder;
import jp.jasminesoft.jfc.gen.sourcefilemanager.IGeneratorController;
import jp.jasminesoft.util.FileCopy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneratorControllerFile
implements IGeneratorController,
Serializable {
    protected static Logger logger = LogManager.getLogger((String)GeneratorControllerFile.class.getName());
    private static GeneratorControllerFile _controller = null;
    private String _controllerFile = "srcgen.csv";
    private String _basedir = null;
    private String _enc = null;
    private Map<File, GeneratedData> _data = null;

    private GeneratorControllerFile(String basedir, String enc) {
        this._basedir = basedir;
        this._enc = enc;
        try {
            this._data = GeneratedDataBuilder.build(this._basedir, this.getControllerFileName());
        }
        catch (Exception e) {
            logger.error("failed build", (Throwable)e);
        }
    }

    public static IGeneratorController getInstance(String basedir, String enc) {
        if (_controller == null) {
            _controller = new GeneratorControllerFile(basedir, enc);
        }
        return _controller;
    }

    public static IGeneratorController getInstance() {
        if (_controller == null) {
            _controller = new GeneratorControllerFile(null, null);
        }
        return _controller;
    }

    public void setControllerFileName(String controllerFile) {
        this._controllerFile = controllerFile;
    }

    public String getControllerFileName() {
        return this._controllerFile;
    }

    @Override
    public boolean isCreate(String fullfilename, long time, int hashcode) {
        GeneratedData gdata = this._data.get(new File(fullfilename));
        if (gdata == null) {
            return true;
        }
        if (gdata.isChecked()) {
            return false;
        }
        gdata.setIsChecked(true);
        return hashcode != gdata.getHashCode();
    }

    @Override
    public boolean hasContain(String fullfilename) {
        GeneratedData obj = this._data.get(new File(fullfilename));
        return obj == null;
    }

    @Override
    public boolean isChecked(String fullfilename) {
        GeneratedData obj = this._data.get(new File(fullfilename));
        if (obj == null) {
            return false;
        }
        return obj.isChecked();
    }

    @Override
    public boolean isKeep(String fullfilename) {
        GeneratedData obj = this._data.get(new File(fullfilename));
        if (obj == null) {
            return false;
        }
        return obj.getState() == GeneratedData.State.NONE;
    }

    @Override
    public void insert(String fullfilename, long time, int hashcode) {
        this._data.put(new File(fullfilename), new GeneratedData(GeneratedData.State.INSERT, true, fullfilename, time, hashcode));
    }

    @Override
    public void update(String fullfilename, long time, int hashcode) {
        this._data.remove(new File(fullfilename));
        this._data.put(new File(fullfilename), new GeneratedData(GeneratedData.State.UPDATE, true, fullfilename, time, hashcode));
    }

    @Override
    public void insertOrUpdate(String fullfilename, long time, int hashcode) {
        if (this.hasContain(fullfilename)) {
            this.insert(fullfilename, time, hashcode);
        } else {
            this.update(fullfilename, time, hashcode);
        }
    }

    @Override
    public synchronized void commit(Set<String> targetModelIdSet) {
        if (this._basedir == null || this.getControllerFileName() == null) {
            return;
        }
        File filepath = new File(this._basedir, this.getControllerFileName());
        String encoding = this._enc;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), encoding)));
        }
        catch (Exception e) {
            logger.error("Failed to open controller file", (Throwable)e);
            return;
        }
        Collection<GeneratedData> collecct = this._data.values();
        for (GeneratedData data : collecct) {
            File[] files;
            String wagbyapp;
            File wapp;
            String targetModelId = data.getModelId();
            if (data.isChecked()) {
                writer.println(data.toString());
                writer.flush();
                if (!data.isRelaxFile() || !data.isStateUpdate()) continue;
                this.deleteRelaxGenFiles(data);
                continue;
            }
            boolean isJprincipal = false;
            String JprincipalHeader = File.separator + "init" + File.separator + "jprincipal" + File.separator;
            String fullfilename = data.getFullFileName();
            if (fullfilename != null && fullfilename.startsWith(JprincipalHeader) && fullfilename.endsWith(".xml")) {
                isJprincipal = true;
            }
            if (targetModelIdSet != null && !targetModelIdSet.contains(targetModelId) && !isJprincipal) {
                data.setState(GeneratedData.State.NONE);
                writer.println(data.toString());
                writer.flush();
                continue;
            }
            data.setState(GeneratedData.State.DELETE);
            writer.println(data.toString());
            writer.flush();
            this.deleteSourceFile(data);
            if (data.isJavaFile()) continue;
            if (data.isRelaxFile()) {
                this.deleteRelaxGenFiles(data);
                continue;
            }
            if (!isJprincipal) continue;
            String DEVHOME = this._basedir + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator;
            String exportfile = DEVHOME + "export" + File.separator + "data_init" + data.getFullFileName();
            File f = new File(exportfile);
            if (f.exists()) {
                f.delete();
            }
            if (!(wapp = new File(wagbyapp = DEVHOME + "wagbyapp" + File.separator + "webapps" + File.separator)).exists() || !wapp.isDirectory() || (files = wapp.listFiles()) == null || files.length <= 0) continue;
            for (File file : files) {
                String targetname;
                File target;
                if (!file.isDirectory() || !(target = new File(targetname = file.getAbsolutePath() + File.separator + "WEB-INF" + File.separator + "export" + data.getFullFileName())).exists()) continue;
                target.delete();
            }
        }
        writer.close();
        writer = null;
    }

    private String getModelname(GeneratedData data) {
        File file = new File(data.getFullFileName());
        String filename = file.getName();
        File parentfile = file.getParentFile();
        String parentfilename = parentfile.getName();
        return parentfilename;
    }

    private File getPackagenameFile(GeneratedData data) {
        File file = new File(data.getFullFileName());
        String filename = file.getName();
        File parentfile = file.getParentFile();
        File parent2file = parentfile.getParentFile();
        File parent3file = parent2file.getParentFile();
        return parent3file;
    }

    private void deleteSourceFile(GeneratedData data) {
        File parentFile;
        String delFileName = this._basedir + data.getFullFileName();
        File delFile = new File(delFileName);
        if (delFile.exists()) {
            delFile.delete();
        }
        if (data.isRelaxFile() && (parentFile = delFile.getParentFile()).exists()) {
            parentFile.delete();
        }
    }

    private void deleteRelaxGenFiles(GeneratedData data) {
        File relaxgendir = this.getRelaxgenDir();
        File delFile = new File(relaxgendir, data.getPackageName());
        if (delFile.exists()) {
            try {
                FileCopy.delete((File)delFile, (boolean)true);
            }
            catch (IOException ioe) {
                logger.error("failed delete relaxer generated file", (Throwable)ioe);
            }
        }
    }

    @Override
    public void adjustFilePathCase(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            File parent;
            if (!file.getAbsolutePath().equalsIgnoreCase(file.getCanonicalPath())) {
                return;
            }
            if (file.getCanonicalPath().endsWith(file.getPath())) {
                return;
            }
            if (!file.getCanonicalPath().endsWith(file.getName())) {
                file.renameTo(new File(file.getParent(), file.getName()));
                BuildXmlGenerator.setAdjustFilePathCaseFlagOn();
            }
            if (!(parent = file.getParentFile()).equals(new File(this._basedir))) {
                this.adjustFilePathCase(parent);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private File getRelaxgenDir() {
        File basedir = new File(this._basedir);
        return new File(basedir.getParent(), "relaxgen");
    }

    @Override
    public String[] getModifiedCompilationFiles() {
        return this.getCompilationFiles(GeneratedData.State.INSERT, GeneratedData.State.UPDATE);
    }

    @Override
    public String[] getCompilationFiles() {
        return this.getCompilationFiles(GeneratedData.State.INSERT, GeneratedData.State.UPDATE, GeneratedData.State.NONE);
    }

    @Override
    public String[] getDeletedCompilationFiles() {
        return this.getCompilationFiles(GeneratedData.State.DELETE);
    }

    protected String[] getCompilationFiles(GeneratedData.State ... stateArray) {
        List<GeneratedData.State> states = Arrays.asList(stateArray);
        ArrayList<String> compilationFiles = new ArrayList<String>();
        for (GeneratedData generatedData : this._data.values()) {
            if (!generatedData.isJavaFile() || !states.contains((Object)generatedData.getState())) continue;
            compilationFiles.add(generatedData.getFullFileName());
        }
        return compilationFiles.toArray(new String[compilationFiles.size()]);
    }

    @Override
    public String[] getModifiedHibernateMappingFiles() {
        return this.getHibernateMappingFiles(GeneratedData.State.INSERT, GeneratedData.State.UPDATE);
    }

    @Override
    public String[] getHibernateMappingFiles() {
        return this.getHibernateMappingFiles(GeneratedData.State.INSERT, GeneratedData.State.UPDATE, GeneratedData.State.NONE);
    }

    @Override
    public Set<GeneratedData> getDeletedHibernateMappingFiles() {
        return this.getHibernateMappingFilesGeneratedData(GeneratedData.State.DELETE);
    }

    protected Set<GeneratedData> getHibernateMappingFilesGeneratedData(GeneratedData.State ... stateArray) {
        List<GeneratedData.State> states = Arrays.asList(stateArray);
        return this._data.values().stream().filter(generatedData -> generatedData.isHibernateMappingFile()).filter(generatedData -> states.contains((Object)generatedData.getState())).collect(Collectors.toSet());
    }

    protected String[] getHibernateMappingFiles(GeneratedData.State ... stateArray) {
        return (String[])this.getHibernateMappingFilesGeneratedData(stateArray).stream().map(generatedData -> generatedData.getFullFileName()).toArray(String[]::new);
    }

    public static void reset() {
        _controller = null;
    }

    @Override
    public void clear() {
        this._data.clear();
    }
}

