/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.th;

import java.util.HashSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JspGenerator_printAll;
import jp.jasminesoft.jfc.gen.JspSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_copy;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_download;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_free;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_insert;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_jobentry;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_master;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_show;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_showList;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_update;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator_uploadUpdate;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThGeneratorFactory
implements IGeneratorFactory {
    protected static Logger logger = LogManager.getLogger((String)ThGeneratorFactory.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");

    public static JspSourceGenerator[] create(Project project, Presentation presentation) {
        if (presentation == null) {
            return new JspSourceGenerator[0];
        }
        Action action = null;
        IRNode node = presentation.getIdrefAsIRNode();
        if (node != null && node instanceof Action) {
            action = (Action)node;
        }
        String type = null;
        if (action == null) {
            if (presentation.getIdref() != null) {
                logger.error(rman.getValue("jsp.comment.actiontype.null", presentation.getIdref()));
            }
            type = "show";
        } else {
            type = action.getType();
        }
        type = type == null || type.length() == 0 ? "show" : type;
        HashSet<JspSourceGenerator> set = new HashSet<JspSourceGenerator>();
        if ("show".equals(type) || "showArray".equals(type) || "confirm".equals(type)) {
            set.add(new ThGenerator_show(project, action, presentation));
        } else if ("showList".equals(type) || "jobentryList".equals(type)) {
            Link[] links;
            set.add(new ThGenerator_showList(project, action, presentation));
            for (Link link : links = AppSchemaUtil.findLink(presentation)) {
                if (!"PrintAll".equals(link.getAction())) continue;
                Model model = AppSchemaUtil.getStoreModel(AppSchemaUtil.getModel(project, action.getIdref()));
                set.add(new JspGenerator_printAll(project, action, presentation, model.getId() + "_printAll", link));
            }
        } else if ("insert".equals(type)) {
            set.add(new ThGenerator_insert(project, action, presentation));
        } else if ("copy".equals(type)) {
            set.add(new ThGenerator_copy(project, action, presentation));
        } else if ("update".equals(type)) {
            set.add(new ThGenerator_update(project, action, presentation));
        } else if ("free".equals(type)) {
            set.add(new ThGenerator_free(project, action, presentation));
        } else if ("jobentry".equals(type)) {
            set.add(new ThGenerator_jobentry(project, action, presentation));
        } else if ("showList-master".equals(type)) {
            Model mmodel = (Model)action.getIdrefAsIRNode();
            if (mmodel != null && !"static".equals(mmodel.getStorage())) {
                set.add(new ThGenerator_master(project, action, presentation));
            }
        } else if ("download".equals(type)) {
            set.add(new ThGenerator_download(project, action, presentation));
        } else if ("uploadUpdate".equals(type)) {
            set.add(new ThGenerator_uploadUpdate(project, action, presentation));
        }
        if (set.size() > 0) {
            return set.toArray(new JspSourceGenerator[0]);
        }
        return new JspSourceGenerator[0];
    }
}

