/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.test.support.testmodel.GenerateTestCode;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.StrUtil;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.TestEnvironment;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SuiteClassInfo {
    private static Logger LOGGER = LogManager.getLogger(SuiteClassInfo.class);
    private String packagePath_;
    private List<String> testClasses_ = new ArrayList<String>();
    private static final String KEY_BASE_URL = "baseUrl";
    private static final String KEY_HEADLESS = "headless";
    private static final String KEY_FAST_SET_VALUE = "fastSetValue";
    private static final String KEY_WEBDRIVER_CHROME = "webdriver.chrome";
    private static final String KEY_OUTPUT_STATUS = "outputStatus";
    private static final String KEY_TIMEOUT = "timeout";
    private static final int DEFAULT_TIMEOUT = 4000;
    private String baseUrl_ = "http://localhost:8921/wagby";
    private String webDriverChromePath_ = "customize/chromedriver.exe";
    private boolean headless_ = false;
    private boolean fastSetValue_ = false;
    private boolean outputStatus_ = false;
    private int timeout_ = 4000;

    public SuiteClassInfo(String path_scenario_macro_dir) {
        Path envPath = Paths.get(path_scenario_macro_dir, "env.def");
        if (Files.exists(envPath, new LinkOption[0])) {
            try {
                List lines;
                try (Stream<String> filelines = Files.lines(envPath, GenerateTestCode.TSM_FILE_CHARSET);){
                    lines = filelines.map(line -> StrUtil.deleteCommentouts(line)).filter(line -> line != null && line.trim().length() > 0).collect(Collectors.toList());
                }
                for (String line2 : lines) {
                    if (!GenerateTestCode.PTN_TEST_ENV_TAG.matcher(line2).matches()) continue;
                    this.addLine(line2);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read and parse env.def file.");
            }
        }
    }

    public void addLine(String line) {
        String key = TestEnvironment.getKeyFromInput(line);
        if (key == null || key.trim().length() < 1) {
            LOGGER.warn("Line [" + line + "] is not valid for header information. key is empty.");
            return;
        }
        String value = TestEnvironment.getValueFromInput(line);
        if (value == null || value.trim().length() < 1) {
            LOGGER.warn("Value for env key [" + key + "] is empty.");
            return;
        }
        if (KEY_BASE_URL.equals(key)) {
            this.baseUrl_ = value;
        } else if (KEY_HEADLESS.equals(key)) {
            this.headless_ = value.equalsIgnoreCase("true");
        } else if (KEY_FAST_SET_VALUE.equals(key)) {
            this.fastSetValue_ = value.equalsIgnoreCase("true");
        } else if (KEY_WEBDRIVER_CHROME.equals(key)) {
            this.webDriverChromePath_ = value;
        } else if (KEY_OUTPUT_STATUS.equals(key)) {
            this.outputStatus_ = value.equalsIgnoreCase("true");
        } else if (KEY_TIMEOUT.equals(key)) {
            this.timeout_ = NumberUtils.toInt((String)value);
        }
    }

    public String getPackage() {
        return this.packagePath_;
    }

    public void setPackage(String packagePath) {
        this.packagePath_ = packagePath;
    }

    public List<String> getTestClasses() {
        Collections.sort(this.testClasses_, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        return this.testClasses_;
    }

    public void addTestClass(String classPath) {
        this.testClasses_.add(classPath);
    }

    public String getBaseUrl() {
        return this.baseUrl_;
    }

    public String getWebDriverChromePath() {
        return this.webDriverChromePath_;
    }

    public boolean isHeadless() {
        return this.headless_;
    }

    public boolean isFastSetValue() {
        return this.fastSetValue_;
    }

    public boolean isOutputStatus() {
        return this.outputStatus_;
    }

    public String getDate() {
        return new SimpleDateFormat("'at' HH:mm:ss 'on' MMM dd,yyyy").format(new Date());
    }

    public int getTimeout() {
        return this.timeout_ <= 0 ? 4000 : this.timeout_;
    }

    public String toString() {
        StringJoiner buf = new StringJoiner("\n");
        buf.add("baseUrl=" + this.getBaseUrl());
        buf.add("headless=" + this.isHeadless());
        buf.add("fastSetValue=" + this.isFastSetValue());
        buf.add("webdriver.chrome=" + this.getWebDriverChromePath());
        buf.add("outputStatus=" + this.isOutputStatus());
        buf.add("timeout=" + this.getTimeout());
        return buf.toString();
    }
}

