/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.test.support.testmodel.GenerateTestCode;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.StrUtil;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.TestMethod;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.TestScenarioMacro;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.TestStatement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestScenarioMacroParser {
    private static Logger LOGGER = LogManager.getLogger(TestScenarioMacroParser.class);
    private Map<String, Map<String, TModel>> testModelMap_;
    private boolean isOutputStatus_ = false;

    public TestScenarioMacroParser(Map<String, Map<String, TModel>> testModelMap) {
        this.testModelMap_ = Collections.unmodifiableMap(testModelMap);
    }

    public void setOutputStatus(boolean isOutputStatus) {
        this.isOutputStatus_ = isOutputStatus;
    }

    public TestScenarioMacro parse(Path tsmFile) throws IOException {
        LOGGER.debug("Start parsing TSM file at: " + tsmFile.toString());
        TestScenarioMacro tsmObj = new TestScenarioMacro();
        tsmObj.setStoreModels(this.testModelMap_);
        try {
            List lines;
            try (Stream<String> filelines = Files.lines(tsmFile, GenerateTestCode.TSM_FILE_CHARSET);){
                lines = filelines.map(line -> StrUtil.deleteCommentouts(line)).filter(line -> line != null && line.trim().length() > 0).collect(Collectors.toList());
            }
            int methodNumber = 1;
            TestMethod cur_method = null;
            boolean directMode = false;
            TModel targetPageObj = null;
            HashMap localVariableMap = null;
            for (String line2 : lines) {
                if (line2.startsWith("=") && !line2.startsWith("==")) {
                    String scenarioName = line2.substring(line2.indexOf("=") + 1).trim();
                    LOGGER.debug("Test scenario: " + scenarioName);
                    tsmObj.setScenarioName(scenarioName);
                    continue;
                }
                if (GenerateTestCode.PTN_TEST_ENV_TAG.matcher(line2).matches()) {
                    tsmObj.getEnvironment().addLine(line2);
                    continue;
                }
                if (line2.startsWith("==")) {
                    String methodName = line2.substring(line2.indexOf("==") + 2).trim();
                    cur_method = new TestMethod(methodNumber++, methodName, this.isOutputStatus_);
                    tsmObj.addTestMethod(cur_method);
                    targetPageObj = null;
                    localVariableMap = new HashMap();
                    LOGGER.debug("(new section: " + methodName + ")");
                    continue;
                }
                if (line2.equals("<%") && !directMode) {
                    directMode = true;
                    continue;
                }
                if (line2.equals("%>") && directMode) {
                    directMode = false;
                    continue;
                }
                if (directMode) {
                    cur_method.addJavaCode(line2);
                    continue;
                }
                try {
                    TestStatement stmt = new TestStatement(this.testModelMap_, line2, targetPageObj, localVariableMap, this.isOutputStatus_);
                    cur_method.addStatement(stmt);
                    TModel targetPageObj_ = stmt.getTargetPageObject();
                    if (targetPageObj != null || targetPageObj_ == null) continue;
                    targetPageObj = targetPageObj_;
                }
                catch (Exception ee) {
                    System.out.println("?? " + line2);
                    ee.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read and parse the TSM file.");
            throw e;
        }
        return tsmObj;
    }
}

