/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import java.util.Arrays;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;

public class ImpExpAction
extends Action {
    @Override
    public ArrayList<String> toCode(String actionName, String[] variables) throws InvalidTestConfigException {
        ArrayList<String> list = new ArrayList<String>();
        if (variables == null || variables.length < 1) {
            throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 1 variables.");
        }
        String code = "";
        variables = this.parseVariable(variables);
        if (actionName.equals(this.command.get("EXPORT"))) {
            if (variables[0].charAt(0) == '#') {
                String op = this.getProperValueWithoutQuot(variables[0]);
                if ("#ALL".equals(op)) {
                    list.add("{");
                    list.add("    ImportExport page = Operations.importExport();");
                    list.add("    page.selectAllModels();");
                    list.add("    page.exportData();");
                    list.add("}");
                } else if ("#RESET".equals(op)) {
                    list.add("Operations.importExport().deselectAllModels();");
                } else {
                    if (variables.length < 2) {
                        throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 2 variables.");
                    }
                    String value = this.getProperValue(variables[1]);
                    if ("#DOWNLOAD".equals(op)) {
                        list.add(String.format("Operations.importExport().download(%s);", value));
                    } else if ("#DELETE".equals(op)) {
                        list.add(String.format("Operations.importExport().delete(%s);", value));
                    }
                }
            } else {
                variables = (String[])Arrays.stream(variables).map(s -> this.getProperValue((String)s)).toArray(String[]::new);
                list.add("{");
                list.add("    ImportExport page = Operations.importExport();");
                list.add("    page.targetModels.val(" + String.join((CharSequence)",", variables) + ");");
                list.add("    page.exportData();");
                list.add("}");
            }
        } else {
            String value = this.getProperValue(variables[0]);
            list.add(String.format("Operations.importExport().importData(%s);", value));
        }
        return list;
    }
}

