/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.test.support.testmodel.model.StoreTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class InputAction
extends Action {
    protected Map<String, Map<String, TModel>> testModelMap_;
    private StoreTModel storeModel_;

    public InputAction(Map<String, Map<String, TModel>> testModelMap) {
        this.testModelMap_ = testModelMap;
    }

    @Override
    public ArrayList<String> toCode(String actionName, String[] variables) throws InvalidTestConfigException {
        if (variables == null || variables.length < 2) {
            throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 2 variables.");
        }
        String model_attr = variables[0];
        Action.TargetModel target = new Action.TargetModel(model_attr, this.testModelMap_);
        this.storeModel_ = target.storeModel;
        if (this.storeModel_ == null) {
            throw new InvalidTestConfigException("No target model " + target.modelJp);
        }
        if (StringUtils.isEmpty((CharSequence)target.attributeName)) {
            throw new InvalidTestConfigException("No attribute " + target.attrJp);
        }
        ArrayList<String> list = new ArrayList<String>();
        variables = this.parseVariable(variables);
        Object method = "val";
        if (target.attributeJavaType.equals("ComboBox") && variables.length == 3 && "#SELECT".equals(variables[2])) {
            method = "dropdown().select";
            variables = (String[])ArrayUtils.remove((Object[])variables, (int)2);
        } else if ("DateListBox".equals(target.attributeJavaType) && variables.length == 3 && "#YEAR".equals(variables[2])) {
            method = "yearListBox().val";
            variables = (String[])ArrayUtils.remove((Object[])variables, (int)2);
        } else if ("DateListBox".equals(target.attributeJavaType) && variables.length == 3 && "#MONTH".equals(variables[2])) {
            method = "monthListBox().val";
            variables = (String[])ArrayUtils.remove((Object[])variables, (int)2);
        } else if ("DateListBox".equals(target.attributeJavaType) && variables.length == 3 && "#DAY".equals(variables[2])) {
            method = "dayListBox().val";
            variables = (String[])ArrayUtils.remove((Object[])variables, (int)2);
        } else if (target.isMultiple && target.index > 0) {
            method = "get(" + target.index + ").val";
            if (variables.length == 3 && ("#YEAR".equals(variables[2]) || "#MONTH".equals(variables[2]) || "#DAY".equals(variables[2]))) {
                variables = (String[])ArrayUtils.remove((Object[])variables, (int)2);
            }
        }
        String syncFunc = "";
        if (target.attributeJavaType.equals("Postcode")) {
            syncFunc = ".sync()";
        }
        String code = "";
        if (target.isContainer && target.index > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%s.%s.get(%s).%s.%s(", target.instanceName, target.containerName, String.valueOf(target.index), target.attributeName, method));
            for (int i = 1; i < variables.length; ++i) {
                sb.append(this.getProperValue(variables[i]));
                if (i >= variables.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            if (StringUtils.isNotBlank((CharSequence)syncFunc)) {
                sb.append(syncFunc);
            }
            sb.append(";");
            code = sb.toString();
        } else if (!target.isMultiple || target.isMultiple && target.index > 0) {
            String value = this.getProperValue(variables);
            code = String.format("%s.%s.%s(%s)%s;", target.instanceName, target.attributeName, method, value, syncFunc);
        } else if (target.isMultiple && target.index < 0) {
            if (variables.length == 2 && "#CLEAR".equals(variables[1])) {
                code = String.format("%s.%s.clear();", target.instanceName, target.attributeName);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("%s.%s.", target.instanceName, target.attributeName));
                for (int i = 1; i < variables.length; ++i) {
                    if (i == 1) {
                        sb.append("get(").append(i).append(")");
                    }
                    sb.append(".val(" + this.getProperValue(variables[i]) + ")");
                    if (i >= variables.length - 1) continue;
                    sb.append(".add()");
                }
                sb.append(";");
                code = sb.toString();
            }
        }
        list.add(code);
        return list;
    }

    public StoreTModel getTargetModel() {
        return this.storeModel_;
    }
}

