/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import java.util.StringJoiner;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.StrUtil;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;

public class MessageAction
extends Action {
    @Override
    public ArrayList<String> toCode(String actionName, String[] variables) throws InvalidTestConfigException {
        if (variables == null || variables.length < 1) {
            throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 1 variable (string).");
        }
        String messageMethod = "errors";
        if (actionName.startsWith(this.command.get("WARNMSG"))) {
            messageMethod = "warns";
        } else if (actionName.startsWith(this.command.get("INFOMSG"))) {
            messageMethod = "infos";
        }
        String line = "";
        if (actionName.equals(this.command.get("ERRORMSGSIZE")) || actionName.equals(this.command.get("WARNMSGSIZE")) || actionName.equals(this.command.get("INFOMSGSIZE"))) {
            String size = StrUtil.removeDoubleQuotes(variables)[0];
            line = String.format("%s().shouldBe(size(%s));", messageMethod, size);
        } else {
            StringJoiner variablePart = new StringJoiner(", ");
            for (String vari : variables) {
                variablePart.add(String.format("\"%s\"", vari));
            }
            String matchMethod = this.matchPattern(actionName).equals("exact") ? "exactTexts" : "texts";
            line = String.format("%s().shouldHave(%s(%s));", messageMethod, matchMethod, variablePart.toString());
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(line);
        return list;
    }
}

