/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PaginationAction
extends Action {
    protected Map<String, Map<String, TModel>> testModelMap_;
    private TModel targetModel_;

    public PaginationAction(Map<String, Map<String, TModel>> testModelMap) {
        this.testModelMap_ = testModelMap;
    }

    public void setTargetModel(TModel targetModel) {
        this.targetModel_ = targetModel;
    }

    @Override
    public ArrayList<String> toCode(String actionName, String[] variables) throws InvalidTestConfigException {
        if (variables == null || variables.length < 1) {
            throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 1 variable.");
        }
        ArrayList<String> list = new ArrayList<String>();
        Object line = "";
        String param = variables[0].trim();
        if (param.equals(this.command.get("PAGINATION_FIRST"))) {
            line = "firstPageLink()";
        } else if (param.equals(this.command.get("PAGINATION_LAST"))) {
            line = "lastPageLink()";
        } else if (param.equals(this.command.get("PAGINATION_PREV"))) {
            line = "previousPageLink()";
        } else if (param.equals(this.command.get("PAGINATION_NEXT"))) {
            line = "nextPageLink()";
        } else if (param.endsWith(this.command.get("PAGINATION_PAGE"))) {
            String part = param.substring(0, param.length() - this.command.get("PAGINATION_PAGE").length());
            int page = NumberUtils.toInt((String)part);
            if (page <= 0) {
                throw new InvalidTestConfigException("illegal page," + part);
            }
            line = "pageLink(" + page + ")";
        }
        if (StringUtils.isNotBlank((CharSequence)line)) {
            line = "pagination()." + (String)line + "." + this.getMethod() + ";";
            list.add((String)line);
        }
        return list;
    }

    protected String getMethod() {
        return "click()";
    }
}

