/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.test.support.testmodel.model.Attribute;
import jp.jasminesoft.jfc.test.support.testmodel.model.ListTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;
import org.apache.commons.lang3.math.NumberUtils;

public class VerifyListAction
extends Action {
    private Map<String, Map<String, TModel>> testModelMap_;
    private ListTModel listModel_;

    public VerifyListAction(Map<String, Map<String, TModel>> testModelMap) {
        this.testModelMap_ = testModelMap;
    }

    @Override
    public ArrayList<String> toCode(String actionName, String[] variables) throws InvalidTestConfigException {
        ArrayList<String> list = new ArrayList<String>();
        if (variables == null || variables.length < 2) {
            throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 2 variables.");
        }
        String modelJp = null;
        String attrJp = null;
        String[] tokens = null;
        if (actionName.equals(this.command.get("VERIFYLISTSIZE"))) {
            modelJp = variables[0];
        } else {
            String model_attr = variables[0];
            tokens = model_attr.split("\\.");
            if (tokens == null || tokens.length < 2) {
                throw new InvalidTestConfigException("Invalid model format, '" + model_attr + "' has no separator.");
            }
            if (tokens.length == 4) {
                modelJp = tokens[2];
                attrJp = tokens[3];
            } else {
                modelJp = tokens[0];
                attrJp = tokens[1];
            }
        }
        String index = "1";
        int ptr = modelJp.indexOf("[");
        if (ptr > 0) {
            String suffix = modelJp.substring(ptr + 1);
            modelJp = modelJp.substring(0, ptr);
            ptr = suffix.indexOf("]");
            if (ptr > 0) {
                String cnt = suffix.substring(0, ptr);
                int dummy = NumberUtils.toInt((String)cnt);
                if (dummy <= 0) {
                    throw new InvalidTestConfigException("illegal index," + tokens[0]);
                }
                index = cnt.trim();
            }
        }
        String attributeName = "";
        Map<String, TModel> listModelMap = this.testModelMap_.get("list");
        ListTModel listModel = (ListTModel)listModelMap.get(modelJp);
        if (listModel == null) {
            throw new InvalidTestConfigException("NO MODEL " + modelJp);
        }
        this.listModel_ = listModel;
        String code = null;
        if (attrJp != null) {
            for (Attribute attr : listModel.getAttributes()) {
                if (!attrJp.equals(attr.getLabel())) continue;
                attributeName = attr.getName();
                break;
            }
            variables = this.parseVariable(variables);
            String value = this.getProperValue(variables[1]);
            code = String.format("list.get(%s).%s.shouldHave(%s);", index, attributeName, value);
        } else {
            String value = this.getProperValueWithoutQuot(variables[1]);
            code = String.format("list.records().shouldHave(size(%s));", value);
        }
        list.add(code);
        return list;
    }

    public ListTModel getTargetModel() {
        return this.listModel_;
    }
}

