/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;
import org.apache.commons.lang3.math.NumberUtils;

public class WorkFlowAction
extends Action {
    @Override
    public ArrayList<String> toCode(String actionName, String[] variables) throws InvalidTestConfigException {
        ArrayList<String> list = new ArrayList<String>();
        if (variables == null || variables.length < 1) {
            throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 1 variables.");
        }
        variables = this.parseVariable(variables);
        String op = this.getProperValueWithoutQuot(variables[0]);
        String useCheckNoErrorsCode = this.useCheckNoErrors(actionName) ? "" : "false";
        Object code = "";
        if (op.equals(this.command.get("WORKFLOW_SELECTFLOW"))) {
            if (variables.length < 2) {
                throw new InvalidTestConfigException("Variables for '" + actionName + " " + op + "' should have at least 2 variables.");
            }
            String value = this.getProperValue(variables[1]);
            code = String.format("workflow().participants_id.val(%s);", value);
        } else if (op.startsWith(this.command.get("WORKFLOW_SELECTFLOWVALUE"))) {
            if (variables.length < 2) {
                throw new InvalidTestConfigException("Variables for '" + actionName + " " + op + "' should have at least 2 variables.");
            }
            String methodName = this.matchPattern(variables[0]).equals("exact") ? "exactTexts" : "texts";
            StringBuilder sb = new StringBuilder();
            sb.append("workflow().participants_id.getOptions().shouldHave(").append(methodName).append("(");
            for (int i = 1; i < variables.length; ++i) {
                sb.append(this.getProperValue(variables[i]));
                if (i >= variables.length - 1) continue;
                sb.append(",");
            }
            sb.append("));");
            code = sb.toString();
        } else if (op.equals(this.command.get("WORKFLOW_COMMENT"))) {
            if (variables.length < 2) {
                throw new InvalidTestConfigException("Variables for '" + actionName + " " + op + "' should have at least 2 variables.");
            }
            String value = this.getProperValue(variables[1]);
            code = String.format("workflow().comment.val(%s);", value);
        } else if (op.startsWith(this.command.get("WORKFLOW_VALUE"))) {
            if (variables.length < 2) {
                throw new InvalidTestConfigException("Variables for '" + actionName + " " + op + "' should have at least 2 variables.");
            }
            String index = null;
            String attrJp = null;
            int ptr = op.indexOf("[");
            if (ptr > 0) {
                String suffix = op.substring(ptr + 1);
                op = op.substring(0, ptr);
                ptr = suffix.indexOf("]");
                if (ptr > 0) {
                    String cnt = suffix.substring(0, ptr);
                    int dummy = NumberUtils.toInt((String)cnt);
                    if (dummy <= 0) {
                        throw new InvalidTestConfigException("illegal index," + variables[1]);
                    }
                    index = cnt.trim();
                    attrJp = suffix.substring(ptr + 1 + 1);
                }
            }
            if (index == null) {
                throw new InvalidTestConfigException("Workflow action has illegal index, " + variables[0]);
            }
            if (attrJp == null) {
                throw new InvalidTestConfigException("Workflow action has illegal attribute, " + variables[0]);
            }
            String attrname = null;
            if (attrJp.equals(this.command.get("WORKFLOW_VALUE_USERNAME"))) {
                attrname = "username";
            } else if (attrJp.equals(this.command.get("WORKFLOW_VALUE_EVENT"))) {
                attrname = "event";
            } else if (attrJp.equals(this.command.get("WORKFLOW_VALUE_COMMENT"))) {
                attrname = "comment";
            }
            if (attrname == null) {
                throw new InvalidTestConfigException("Workflow action has illegal attribute, " + variables[0]);
            }
            String value = this.getProperValue(variables[1]);
            code = String.format("workflow().getWorkstate(%s).%s.shouldHave(%s);", String.valueOf(index), attrname, value);
        } else if (op.equals(this.command.get("WORKFLOW_APPLICATION"))) {
            code = "workflow().application(" + useCheckNoErrorsCode + ");";
        } else if (op.equals(this.command.get("WORKFLOW_ADMIT"))) {
            code = "workflow().admit(" + useCheckNoErrorsCode + ");";
        } else if (op.equals(this.command.get("WORKFLOW_FINISH"))) {
            code = "workflow().end(" + useCheckNoErrorsCode + ");";
        } else if (op.equals(this.command.get("WORKFLOW_BACK"))) {
            code = "workflow().back(" + useCheckNoErrorsCode + ");";
        } else if (op.equals(this.command.get("WORKFLOW_REJECT"))) {
            code = "workflow().reject(" + useCheckNoErrorsCode + ");";
        } else if (op.equals(this.command.get("WORKFLOW_CANCEL"))) {
            code = "workflow().cancel(" + useCheckNoErrorsCode + ");";
        } else if (op.equals(this.command.get("WORKFLOW_COUNT"))) {
            if (variables.length < 2) {
                throw new InvalidTestConfigException("Variables for '" + actionName + " " + op + "' should have at least 2 variables.");
            }
            String value = this.getProperValueWithoutQuot(variables[1]);
            code = String.format("workflow().getWorkstateRecords().shouldHave(size(%s)); ", value);
        }
        list.add((String)code);
        return list;
    }
}

