/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.repository;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.jasminesoft.jfc.core.util.ThreadLocalUtils;
import jp.jasminesoft.jfc.gen.appschema.Filteritem;
import jp.jasminesoft.jfc.gen.appschema.Filterlist;
import jp.jasminesoft.jfc.gen.appschema.Jfcdomain;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipal;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipalCategory;
import jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo;
import jp.jasminesoft.jfc.tools.xls2appschema.RepositoryType;
import jp.jasminesoft.util.ExtensionFilenameFilter;
import jp.jasminesoft.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component(value="RepositoryIO")
public class RepositoryIO {
    private static final Logger log = LogManager.getLogger(RepositoryIO.class);
    public static final String Encoding = "UTF-8";
    private String repositoryDirectory = "work" + File.separator + "repository" + File.separator;
    public static final String FILELIST = "filelist.txt";
    public static final String PROJECTMAP_TXT = "project.txt";
    public static final String PROJECTOUTERLINK_DIR = ".project_outerlink";
    public static final String PROJECTOUTERLINK_PRINCIPAL_DIR = ".project_outerlink_principal";
    public static final String MENU_DIR = ".menu";
    public static final String DOMAIN_DIR = ".domain";
    public static final String MENUORDER_DIR = ".menu" + File.separator + ".menuorder";
    public static final String CACHED_MODELID_TXT = "cacheid.txt";
    public static final String CACHED_MODELVERSION_TXT = "version.txt";
    public static final String CACHED_FILTERLIST_TXT = "filterlist.txt";
    public static final String AUTHORITY_DIR = ".authority";
    public static final String PRINCIPAL_DIR = ".principal";
    public static final String CATEGORY_DIR = ".category";
    public static final String AUTHORITY_PRINCIPAL_DIR = ".authority" + File.separator + ".principal";
    public static final String AUTHORITY_CATEGORY_DIR = ".authority" + File.separator + ".category";

    public static void setRepositoryDirectory(String dir) {
        RepositoryIO.getInstance().setRepositoryDirPath(dir);
    }

    public static String getRepositoryDirectory() {
        return RepositoryIO.getInstance().getRepositoryDirPath();
    }

    private void setRepositoryDirPath(String dir) {
        this.repositoryDirectory = dir;
    }

    private String getRepositoryDirPath() {
        return this.repositoryDirectory;
    }

    private RepositoryIO() {
    }

    public static RepositoryIO getInstance() {
        RepositoryIO repositoryIO = (RepositoryIO)ThreadLocalUtils.get(RepositoryIO.class);
        if (repositoryIO == null) {
            repositoryIO = new RepositoryIO();
            ThreadLocalUtils.set(RepositoryIO.class, (Object)repositoryIO);
        }
        return repositoryIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setNewline(Properties properties) {
        File file = new File(RepositoryIO.getRepositoryDirectory(), PROJECTMAP_TXT);
        if (!file.exists()) {
            return;
        }
        String mark = null;
        BufferedReader reader = null;
        try {
            String s;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Encoding));
            while ((s = reader.readLine()) != null) {
                if (!s.startsWith("__newline")) continue;
                int ptr = s.indexOf("=");
                if ("CRLF".equals(s = s.substring(ptr + 1))) {
                } else if ("CR".equals(s)) {
                    mark = String.valueOf('\r');
                } else if ("LF".equals(s)) {
                    mark = String.valueOf('\n');
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (mark != null) {
                properties.setNewLine(mark);
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void loadModelMap(Map<String, ModelInfo> modelMap) {
        File dir = new File(RepositoryIO.getRepositoryDirectory());
        RepositoryIO.loadModelMap(modelMap, dir);
    }

    public void loadModelMap(Map<String, ModelInfo> modelMap, Map<Integer, AuthorityPrincipal> authorityPrincipal) {
        File dir = new File(RepositoryIO.getRepositoryDirectory());
        RepositoryIO.loadModelMap(modelMap, dir, authorityPrincipal);
    }

    public static void loadModelMap(Map<String, ModelInfo> modelMap, File dir) {
        RepositoryIO.loadModelMap(modelMap, dir, null);
    }

    public static void loadModelMap(Map<String, ModelInfo> modelMap, File dir, Map<Integer, AuthorityPrincipal> authorityPrincipal) {
        String[] dfilenames;
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (String dfilename : dfilenames = dir.list()) {
            String[] filenames;
            File ddir;
            if (dfilename.startsWith(".") || dfilename.equals("jfcMenu") || !(ddir = new File(dir, dfilename)).exists() || !ddir.isDirectory()) continue;
            String[] suffixes = new String[]{".txt"};
            for (String filename : filenames = ddir.list((FilenameFilter)new ExtensionFilenameFilter(suffixes, false))) {
                File file = new File(ddir.getPath() + File.separator + filename);
                if (!file.exists() || !file.canRead()) continue;
                String modelId = filename.substring(0, filename.length() - ".txt".length());
                String modelId0 = null;
                modelId0 = modelId.startsWith("common-") ? modelId.substring("common-".length()) : modelId;
                ModelInfo minfo = new ModelInfo(modelId0);
                minfo.read(ddir.getAbsolutePath(), authorityPrincipal);
                if (!modelMap.containsKey(modelId)) {
                    modelMap.put(modelId, minfo);
                    log.debug("\u30ad\u30e3\u30c3\u30b7\u30e5\u3055\u308c\u305f\u30e2\u30c7\u30eb " + modelId + " \u306e\u5b9a\u7fa9\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f\u3002");
                    continue;
                }
                log.error("\u30e2\u30c7\u30eb " + modelId + " \u306e\u5b9a\u7fa9\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
            }
        }
    }

    public void saveModelMap(String targetDefFileName, Map<String, ModelInfo> modelMap, Set<String> modelIdSet) {
        this.saveModelMap(targetDefFileName, modelMap, modelIdSet, null);
    }

    public void saveModelMap(String targetDefFileName, Map<String, ModelInfo> modelMap, Set<String> modelIdSet, Set<RepositoryType> rtypeSet) {
        if (modelMap == null || modelMap.size() == 0) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)targetDefFileName)) {
            return;
        }
        for (String modelId : modelMap.keySet()) {
            if (!modelIdSet.contains(modelId)) continue;
            this.saveModelInfo(targetDefFileName, modelMap.get(modelId), rtypeSet);
        }
    }

    private void saveModelInfo(String targetDefFileName, ModelInfo minfo, Set<RepositoryType> rtypeSet) {
        File savedir = new File(RepositoryIO.getRepositoryDirectory(), targetDefFileName);
        if (!savedir.exists()) {
            savedir.mkdir();
        }
        String dirname = new File(RepositoryIO.getRepositoryDirectory(), targetDefFileName).toString() + File.separator;
        minfo.write(dirname, rtypeSet);
    }

    public void loadProjectOuterlink(Map<Integer, Map<String, String>> outerLinkMap, Map<Integer, Map<Integer, Map<String, String>>> principalInfoMap) {
        String[] fnames;
        File dir = new File(RepositoryIO.getRepositoryDirectory(), PROJECTOUTERLINK_DIR);
        if (!dir.exists()) {
            return;
        }
        String[] suffixes = new String[]{".txt"};
        for (String fname : fnames = dir.list((FilenameFilter)new ExtensionFilenameFilter(suffixes, false))) {
            Integer num = null;
            try {
                int ptr = fname.lastIndexOf(".txt");
                num = Integer.valueOf(fname.substring(0, ptr));
            }
            catch (NumberFormatException e) {
                continue;
            }
            Map<String, String> contentMap = outerLinkMap.get(num);
            if (contentMap == null) {
                contentMap = new HashMap<String, String>();
                outerLinkMap.put(num, contentMap);
            }
            Properties properties = RepositoryIO.loadProperties(dir.toString() + File.separator + fname);
            Enumeration e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = properties.getProperty(key);
                contentMap.put(key, value);
            }
        }
        dir = new File(RepositoryIO.getRepositoryDirectory(), PROJECTOUTERLINK_PRINCIPAL_DIR);
        if (!dir.exists()) {
            return;
        }
        for (String fname : fnames = dir.list()) {
            String[] ffnames;
            File ddir = new File(dir, fname);
            if (!ddir.isDirectory()) continue;
            Integer num1 = null;
            try {
                num1 = Integer.valueOf(fname);
            }
            catch (NumberFormatException e) {
                continue;
            }
            for (String ffname : ffnames = ddir.list((FilenameFilter)new ExtensionFilenameFilter(suffixes, false))) {
                Map<String, String> contentMap2;
                Integer num2 = null;
                try {
                    int ptr = ffname.lastIndexOf(".txt");
                    num2 = Integer.valueOf(ffname.substring(0, ptr));
                }
                catch (NumberFormatException e) {
                    continue;
                }
                Map<Integer, Map<String, String>> contentMap1 = principalInfoMap.get(num1);
                if (contentMap1 == null) {
                    contentMap1 = new HashMap<Integer, Map<String, String>>();
                    principalInfoMap.put(num1, contentMap1);
                }
                if ((contentMap2 = contentMap1.get(num2)) == null) {
                    contentMap2 = new HashMap<String, String>();
                    contentMap1.put(num2, contentMap2);
                }
                String filename = ddir.getAbsolutePath() + File.separator + ffname;
                Properties properties = RepositoryIO.loadProperties(filename);
                Enumeration e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = properties.getProperty(key);
                    contentMap2.put(key, value);
                }
            }
        }
    }

    public void saveProjectOuterlink(Map<Integer, Map<String, String>> outerLinkMap, Map<Integer, Map<Integer, Map<String, String>>> principalInfoMap) {
        Map<Object, Object> contentMap;
        Integer num;
        File dir = new File(RepositoryIO.getRepositoryDirectory(), PROJECTOUTERLINK_DIR);
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (Map.Entry<Integer, Map<String, String>> entry : outerLinkMap.entrySet()) {
            num = entry.getKey();
            contentMap = entry.getValue();
            Properties properties = new Properties();
            for (Map.Entry<String, String> entry2 : contentMap.entrySet()) {
                String key = entry2.getKey();
                String value = entry2.getValue();
                properties.setProperty(key, value);
            }
            String filename = dir.toString() + File.separator + num + ".txt";
            RepositoryIO.saveProperties(filename, properties);
        }
        dir = new File(RepositoryIO.getRepositoryDirectory(), PROJECTOUTERLINK_PRINCIPAL_DIR);
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (Map.Entry<Integer, Map<Object, Object>> entry : principalInfoMap.entrySet()) {
            num = entry.getKey();
            contentMap = entry.getValue();
            File ddir = new File(dir, num.toString());
            if (!ddir.exists()) {
                ddir.mkdir();
            }
            for (Map.Entry<Object, Object> entry3 : contentMap.entrySet()) {
                Integer num2 = (Integer)entry3.getKey();
                Map contentMap2 = (Map)entry3.getValue();
                Properties properties = new Properties();
                for (Map.Entry eee : contentMap2.entrySet()) {
                    String key = (String)eee.getKey();
                    String value = (String)eee.getValue();
                    properties.setProperty(key, value);
                }
                String filename = ddir.getAbsolutePath() + File.separator + num2 + ".txt";
                RepositoryIO.saveProperties(filename, properties);
            }
        }
    }

    public void loadProjectMap(Map<String, String> projectMap) {
        this.loadProjectMap0(projectMap, PROJECTMAP_TXT);
    }

    public void loadProjectMap(Map<String, String> projectMap, int domainId) {
        this.loadProjectMap0(projectMap, PROJECTMAP_TXT);
        this.loadProjectMap0(projectMap, "project_" + domainId + ".txt");
    }

    private void loadProjectMap0(Map<String, String> projectMap, String filename) {
        File file = new File(RepositoryIO.getRepositoryDirectory(), filename);
        if (!file.exists()) {
            return;
        }
        Properties properties = RepositoryIO.loadProperties(file.toString());
        Enumeration e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            projectMap.put(key, value);
        }
    }

    public void saveProjectMap(Map<String, String> projectMap) {
        this.saveProjectMap0(projectMap, false, PROJECTMAP_TXT);
    }

    public void saveProjectMap(Map<String, String> projectMap, boolean keepCompatibility) {
        this.saveProjectMap0(projectMap, keepCompatibility, PROJECTMAP_TXT);
    }

    public void saveProjectMap(Map<String, String> projectMap, int domainId) {
        HashMap<String, String> saveMap = new HashMap<String, String>(projectMap);
        HashMap<String, String> base = new HashMap<String, String>();
        this.loadProjectMap(base);
        for (Map.Entry entry : base.entrySet()) {
            String k = (String)entry.getKey();
            String v = (String)saveMap.get(k);
            if (v == null || !v.equals(base.get(k))) continue;
            saveMap.remove(k);
        }
        String filename = "project_" + domainId + ".txt";
        this.saveProjectMap0(saveMap, false, filename);
    }

    public void saveProjectMap0(Map<String, String> projectMap, boolean keepCompatibility, String filename) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> e : projectMap.entrySet()) {
            String key = e.getKey();
            if (!keepCompatibility && (key.startsWith("menutab[") || key.startsWith("project/environment/menu/@") || key.startsWith("project/environment/menu/"))) continue;
            properties.setProperty(e.getKey(), e.getValue());
        }
        File file = new File(RepositoryIO.getRepositoryDirectory(), filename);
        RepositoryIO.saveProperties(file.toString(), properties);
    }

    public void loadAuthorityPrincipalMap(Map<Integer, AuthorityPrincipal> authorityPrincipalInfoMap) {
        File principalDir = new File(RepositoryIO.getRepositoryDirectory(), AUTHORITY_PRINCIPAL_DIR);
        if (!principalDir.exists()) {
            this.loadDefaultAuthorityPrincipal(authorityPrincipalInfoMap);
            return;
        }
        String id = null;
        for (File principalFile : principalDir.listFiles()) {
            String filename = principalFile.getName();
            if (!StringUtils.endsWith((CharSequence)filename, (CharSequence)".txt")) continue;
            AuthorityPrincipal principal = new AuthorityPrincipal();
            Properties properties = RepositoryIO.loadProperties(principalFile.getAbsolutePath());
            Enumeration e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = properties.getProperty(key);
                if ("authority/principal/@id".equals(key)) {
                    id = value;
                    principal.setId(Integer.parseInt(id));
                    continue;
                }
                if ("authority/principal/@no".equals(key)) {
                    principal.setNo(Integer.parseInt(value));
                    continue;
                }
                if ("authority/principal/@principalId".equals(key)) {
                    principal.setPrincipalId(value);
                    continue;
                }
                if ("authority/principal/@content".equals(key)) {
                    principal.setContent(value);
                    continue;
                }
                if ("authority/principal/@category".equals(key)) {
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    principal.setCategory(Integer.parseInt(value));
                    continue;
                }
                if ("authority/principal/@order".equals(key)) {
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    principal.setOrder(Integer.parseInt(value));
                    continue;
                }
                if ("authority/principal/@isShowInSelect".equals(key)) {
                    principal.setShowInSelect(Boolean.parseBoolean(value));
                    continue;
                }
                if (!"authority/principal/@isEditable".equals(key)) continue;
                principal.setEditable(Boolean.parseBoolean(value));
            }
            authorityPrincipalInfoMap.put(Integer.valueOf(id), principal);
        }
    }

    private void loadDefaultAuthorityPrincipal(Map<Integer, AuthorityPrincipal> authorityPrincipalInfoMap) {
        log.info("[\u6ce8\u610f] \u30d3\u30eb\u30c9\u30c6\u30b9\u30c8\u306e\u305f\u3081\u3001\u30c0\u30df\u30fc\u306e authorityPrincipal \u30de\u30c3\u30d7\u3092\u7528\u610f\u3057\u307e\u3059\u3002");
        authorityPrincipalInfoMap.put(1, this.createDummyAuthorityPrincipal(1, "public", 10, 2, "\u5171\u901a\u51e6\u7406"));
        authorityPrincipalInfoMap.put(2, this.createDummyAuthorityPrincipal(2, "default", 11, 2, "\u30d1\u30b9\u30ef\u30fc\u30c9\u5909\u66f4"));
        authorityPrincipalInfoMap.put(3, this.createDummyAuthorityPrincipal(3, "all", 2, 1, "\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005"));
        authorityPrincipalInfoMap.put(4, this.createDummyAuthorityPrincipal(4, "jshparam_master", 7, 1, "\u30de\u30b9\u30bf\u66f4\u65b0\u8005"));
        authorityPrincipalInfoMap.put(5, this.createDummyAuthorityPrincipal(5, "jshparam_jholiday", 9, 1, "\u4f11\u65e5\u8a2d\u5b9a\u66f4\u65b0\u8005"));
        authorityPrincipalInfoMap.put(6, this.createDummyAuthorityPrincipal(6, "jshparam_juser", 5, 1, "\u30a2\u30ab\u30a6\u30f3\u30c8\u95b2\u89a7\u8005"));
        authorityPrincipalInfoMap.put(7, this.createDummyAuthorityPrincipal(7, "jshparam_groupmanager", 3, 1, "\u30b0\u30eb\u30fc\u30d7\u7ba1\u7406\u8005"));
        authorityPrincipalInfoMap.put(8, this.createDummyAuthorityPrincipal(8, "bjmanager", 18, 4, "\u30d0\u30c3\u30c1\u30b8\u30e7\u30d6\u7ba1\u7406"));
        authorityPrincipalInfoMap.put(9, this.createDummyAuthorityPrincipal(9, "bjoperator", 19, 4, "\u30d0\u30c3\u30c1\u30b8\u30e7\u30d6\u95b2\u89a7"));
        authorityPrincipalInfoMap.put(10, this.createDummyAuthorityPrincipal(10, "common", 1, 1, "\u4e00\u822c\u30e6\u30fc\u30b6"));
        authorityPrincipalInfoMap.put(11, this.createDummyAuthorityPrincipal(11, "conditionsettingman", 12, 2, "\u5171\u901a\u691c\u7d22\u8a2d\u5b9a\u7ba1\u7406"));
        authorityPrincipalInfoMap.put(12, this.createDummyAuthorityPrincipal(12, "cspreferenceitemman", 13, 2, "\u30d7\u30ec\u30d5\u30a1\u30ec\u30f3\u30b9\u5171\u901a\u8a2d\u5b9a\u7ba1\u7406"));
        authorityPrincipalInfoMap.put(13, this.createDummyAuthorityPrincipal(13, "jfcjobmaster", 16, 4, "\u30b8\u30e7\u30d6\u7ba1\u7406\u8005"));
        authorityPrincipalInfoMap.put(14, this.createDummyAuthorityPrincipal(14, "jfcschedulemaster", 17, 4, "\u30b8\u30e7\u30d6\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u7ba1\u7406\u8005"));
        authorityPrincipalInfoMap.put(15, this.createDummyAuthorityPrincipal(15, "jfcworkflowmaster", 22, 5, "\u30ef\u30fc\u30af\u30d5\u30ed\u30fc\u7ba1\u7406\u8005"));
        authorityPrincipalInfoMap.put(16, this.createDummyAuthorityPrincipal(16, "jshparam_groupmanager_without_proxy", 4, 1, "\u30b0\u30eb\u30fc\u30d7\u7ba1\u7406\u8005(\u4ee3\u7406\u767b\u9332\u4e0d\u53ef)"));
        authorityPrincipalInfoMap.put(17, this.createDummyAuthorityPrincipal(17, "jshparam_workstate_show", 21, 5, "\u30d5\u30ed\u30fc\u72b6\u614b\u95b2\u89a7"));
        authorityPrincipalInfoMap.put(18, this.createDummyAuthorityPrincipal(18, "mailtemplatemaster", 14, 3, "\u30e1\u30fc\u30eb\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u7ba1\u7406\u8005"));
        authorityPrincipalInfoMap.put(19, this.createDummyAuthorityPrincipal(19, "newsadmin", 8, 1, "\u304a\u77e5\u3089\u305b\u7ba1\u7406\u8005"));
        authorityPrincipalInfoMap.put(20, this.createDummyAuthorityPrincipal(20, "proxy_setting", 23, 5, "\u30ef\u30fc\u30af\u30d5\u30ed\u30fc\u4ee3\u7406\u8a2d\u5b9a\u8005"));
        authorityPrincipalInfoMap.put(21, this.createDummyAuthorityPrincipal(21, "reporttemplatemaster", 15, 3, "\u5e33\u7968\u5b9a\u7fa9\u7ba1\u7406\u8005"));
        authorityPrincipalInfoMap.put(22, this.createDummyAuthorityPrincipal(22, "releaseLogonUser", 6, 1, "\u63a5\u7d9a\u89e3\u9664"));
        authorityPrincipalInfoMap.put(23, this.createDummyAuthorityPrincipal(23, "jobAccount", 20, 4, "\u30b8\u30e7\u30d6\u5c02\u7528\u30a2\u30ab\u30a6\u30f3\u30c8"));
        authorityPrincipalInfoMap.put(24, this.createDummyAuthorityPrincipal(24, "user", 24, 1, "\u30e6\u30fc\u30b6\u7ba1\u7406"));
        authorityPrincipalInfoMap.put(25, this.createDummyAuthorityPrincipal(25, "group", 25, 1, "\u30b0\u30eb\u30fc\u30d7\u7ba1\u7406"));
        authorityPrincipalInfoMap.put(26, this.createDummyAuthorityPrincipal(26, "syslog", 26, 6, "\u30b7\u30b9\u30c6\u30e0\u30ed\u30b0\u95b2\u89a7"));
        authorityPrincipalInfoMap.put(27, this.createDummyAuthorityPrincipal(27, "analystics", 27, 6, "\u7d71\u8a08\u60c5\u5831\u95b2\u89a7"));
        authorityPrincipalInfoMap.put(28, this.createDummyAuthorityPrincipal(28, "sysinfo", 28, 6, "\u30b7\u30b9\u30c6\u30e0\u60c5\u5831\u95b2\u89a7"));
        authorityPrincipalInfoMap.put(29, this.createDummyAuthorityPrincipal(29, "impexp", 29, 6, "\u30a4\u30f3\u30dd\u30fc\u30c8\u30a8\u30af\u30b9\u30dd\u30fc\u30c8"));
        authorityPrincipalInfoMap.put(30, this.createDummyAuthorityPrincipal(30, "maintenance", 30, 6, "\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9\u30e2\u30fc\u30c9\u5207\u66ff"));
        authorityPrincipalInfoMap.put(31, this.createDummyAuthorityPrincipal(31, "webapi", 31, 6, "WebAPI\u8a2d\u5b9a"));
    }

    private AuthorityPrincipal createDummyAuthorityPrincipal(int id, String principalId, int no, int category, String content) {
        AuthorityPrincipal principal = new AuthorityPrincipal();
        principal.setId(id);
        principal.setPrincipalId(principalId);
        principal.setNo(no);
        principal.setCategory(category);
        principal.setContent(content);
        return principal;
    }

    public void loadAuthorityPrincipalCategoryMap(Map<Integer, AuthorityPrincipalCategory> map) {
        File categoryDir = new File(RepositoryIO.getRepositoryDirectory(), AUTHORITY_CATEGORY_DIR);
        if (!categoryDir.exists()) {
            return;
        }
        String id = null;
        for (File categoryFile : categoryDir.listFiles()) {
            String filename = categoryFile.getName();
            if (!StringUtils.endsWith((CharSequence)filename, (CharSequence)".txt")) continue;
            AuthorityPrincipalCategory principalCategory = new AuthorityPrincipalCategory();
            Properties properties = RepositoryIO.loadProperties(categoryFile.getAbsolutePath());
            Enumeration e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = properties.getProperty(key);
                if ("authority/category/@id".equals(key)) {
                    id = value;
                    principalCategory.setId(Integer.parseInt(id));
                    continue;
                }
                if ("authority/category/@no".equals(key)) {
                    principalCategory.setNo(Integer.parseInt(value));
                    continue;
                }
                if ("authority/category/@categoryId".equals(key)) {
                    principalCategory.setCategoryId(value);
                    continue;
                }
                if ("authority/category/@content".equals(key)) {
                    principalCategory.setContent(value);
                    continue;
                }
                if (!"authority/category/@order".equals(key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
                principalCategory.setOrder(Integer.parseInt(value));
            }
            map.put(Integer.valueOf(id), principalCategory);
        }
    }

    public void loadModelVersionMap(Map<String, String> modelVersionMap) {
        File file = new File(RepositoryIO.getRepositoryDirectory(), CACHED_MODELVERSION_TXT);
        if (!file.exists()) {
            return;
        }
        Properties properties = RepositoryIO.loadProperties(file.toString());
        Enumeration e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            modelVersionMap.put(key, value);
        }
    }

    public void saveModelVersionMap(Map<String, String> modelVersionMap) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> e : modelVersionMap.entrySet()) {
            properties.setProperty(e.getKey(), e.getValue());
        }
        File file = new File(RepositoryIO.getRepositoryDirectory(), CACHED_MODELVERSION_TXT);
        RepositoryIO.saveProperties(file.toString(), properties);
    }

    public void loadProjectFilter(Map<String, Filterlist> filterlistMap) {
        File file = new File(RepositoryIO.getRepositoryDirectory(), CACHED_FILTERLIST_TXT);
        if (!file.exists()) {
            return;
        }
        TreeMap<String, Integer> _cmap = new TreeMap<String, Integer>();
        Properties properties = RepositoryIO.loadProperties(file.toString());
        Enumeration e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            int ptr1 = key.indexOf(".");
            if (ptr1 < 0) {
                log.error("ptr1 not found " + key);
                continue;
            }
            String id = key.substring(0, ptr1);
            String rest = key.substring(ptr1 + 1);
            int ptr2 = rest.indexOf(".");
            if (ptr2 < 0) {
                log.error("ptr2 not found " + rest);
                continue;
            }
            String now_str = rest.substring(0, ptr2);
            Integer now_value = Integer.valueOf(now_str);
            Integer p_value = (Integer)_cmap.get(id);
            if (p_value == null) {
                _cmap.put(id, now_value);
                continue;
            }
            if (now_value <= p_value) continue;
            _cmap.put(id, now_value);
        }
        LinkedHashMap<String, Filteritem[]> _fmap = new LinkedHashMap<String, Filteritem[]>();
        for (String id : _cmap.keySet()) {
            int size = (Integer)_cmap.get(id);
            _fmap.put(id, new Filteritem[size + 1]);
        }
        e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            int ptr1 = key.indexOf(".");
            if (ptr1 < 0) {
                log.error("ptr1 not found " + key);
                continue;
            }
            String id = key.substring(0, ptr1);
            String rest = key.substring(ptr1 + 1);
            int ptr2 = rest.indexOf(".");
            if (ptr2 < 0) {
                log.error("ptr2 not found " + rest);
                continue;
            }
            String i = rest.substring(0, ptr2);
            String type = rest.substring(ptr2 + 1);
            Filteritem filteritem = new Filteritem();
            filteritem.setType(type);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                filteritem.setContent(value);
            }
            Filteritem[] items = (Filteritem[])_fmap.get(id);
            items[Integer.valueOf((String)i).intValue()] = filteritem;
        }
        if (_fmap.size() > 0) {
            for (String id : _fmap.keySet()) {
                Filteritem[] items = (Filteritem[])_fmap.get(id);
                Filterlist filterlist = new Filterlist();
                filterlist.setId(id);
                filterlist.setFilteritem(items);
                filterlistMap.put(id, filterlist);
            }
        }
    }

    public void saveProjectFilter(Map<String, Filterlist> filterlistMap) {
        Properties properties = new Properties();
        for (Map.Entry<String, Filterlist> e : filterlistMap.entrySet()) {
            String id = e.getKey();
            Filterlist filterlist = e.getValue();
            Filteritem[] filteritems = filterlist.getFilteritem();
            for (int i = 0; i < filteritems.length; ++i) {
                Filteritem filteritem = filteritems[i];
                String type = filteritem.getType();
                String content = filteritem.getContent();
                if (StringUtils.isBlank((CharSequence)content)) {
                    content = "";
                }
                String key = id + "." + i + "." + type;
                properties.setProperty(key, content);
            }
        }
        File file = new File(RepositoryIO.getRepositoryDirectory(), CACHED_FILTERLIST_TXT);
        RepositoryIO.saveProperties(file.toString(), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String filename) {
        Properties properties = new Properties();
        Reader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(filename), Encoding);
            properties.load(in);
        }
        catch (IOException e) {
            log.error("\u30ea\u30dd\u30b8\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb '" + filename + "' \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e0) {
                    e0.printStackTrace();
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(String filename, Properties properties) {
        Writer out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), Encoding);
            RepositoryIO.setNewline(properties);
            properties.store(out, null);
        }
        catch (IOException e) {
            log.error("\u30ea\u30dd\u30b8\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb '" + filename + "' \u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e0) {
                    e0.printStackTrace();
                }
            }
        }
    }

    public static Map<String, String> loadXml(String filename) {
        final HashMap<String, String> map = new HashMap<String, String>();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new File(filename), new DefaultHandler(){
                private StringBuilder buf;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    this.buf = new StringBuilder();
                }

                @Override
                public void endElement(String uri, String localName, String qName) {
                    if (this.buf == null) {
                        return;
                    }
                    map.put(qName, this.buf.toString());
                    this.buf = null;
                }

                @Override
                public void characters(char[] ch, int start, int length) {
                    if (this.buf == null) {
                        return;
                    }
                    this.buf.append(new String(ch, start, length));
                }
            });
            return map;
        }
        catch (ParserConfigurationException e) {
            log.error("\u30ea\u30dd\u30b8\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb '" + filename + "' \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error("\u30ea\u30dd\u30b8\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb '" + filename + "' \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u30ea\u30dd\u30b8\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb '" + filename + "' \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static void saveXml(String filename, String modelId, Map<String, ?> value) {
        Transformer trans;
        DocumentBuilder db;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("\u30ea\u30dd\u30b8\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb '" + filename + "' \u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), (Throwable)e);
            return;
        }
        Document doc = db.newDocument();
        Element root = doc.createElement(modelId);
        doc.appendChild(root);
        ArrayList<String> keylist = new ArrayList<String>(value.keySet());
        Collections.sort(keylist);
        for (String key : keylist) {
            Element elem = doc.createElement(key);
            root.appendChild(elem);
            if (value.get(key) == null) continue;
            Text text = doc.createTextNode(value.get(key).toString());
            elem.appendChild(text);
        }
        try {
            trans = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            log.error("\u30ea\u30dd\u30b8\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb '" + filename + "' \u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), (Throwable)e);
            return;
        }
        catch (TransformerFactoryConfigurationError e) {
            log.error("\u30ea\u30dd\u30b8\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb '" + filename + "' \u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), (Throwable)e);
            return;
        }
        try {
            trans.transform(new DOMSource(doc), new StreamResult(new File(filename)));
        }
        catch (TransformerException e) {
            log.error("\u30ea\u30dd\u30b8\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb '" + filename + "' \u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), (Throwable)e);
        }
    }

    public boolean loadMenu(Map<String, String> menuMap) {
        String value;
        String key;
        String id;
        File jfcMenu = new File(RepositoryIO.getRepositoryDirectory(), MENU_DIR);
        if (!jfcMenu.exists()) {
            return false;
        }
        File jfcMenuOrder = new File(RepositoryIO.getRepositoryDirectory(), MENUORDER_DIR);
        Properties properties = RepositoryIO.loadProperties(jfcMenu.getAbsolutePath() + File.separator + "__project.txt");
        Enumeration e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key2 = (String)e.nextElement();
            String value2 = properties.getProperty(key2);
            menuMap.put(key2, value2);
        }
        Collection files = FileUtils.listFiles((File)jfcMenu, (String[])new String[]{"txt"}, (boolean)false);
        for (File file : files) {
            id = file.getName();
            if (id.equals("__project.txt")) continue;
            id = id.substring(0, id.length() - ".txt".length());
            properties = RepositoryIO.loadProperties(file.getAbsolutePath());
            e = properties.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = properties.getProperty(key);
                menuMap.put(id + "/" + key, value);
            }
        }
        properties = RepositoryIO.loadProperties(jfcMenuOrder.getAbsolutePath() + File.separator + "__project.txt");
        e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key3 = (String)e.nextElement();
            String value3 = properties.getProperty(key3);
            menuMap.put(key3, value3);
        }
        files = FileUtils.listFiles((File)jfcMenuOrder, (String[])new String[]{"txt"}, (boolean)false);
        for (File file : files) {
            id = file.getName();
            if (id.equals("__project.txt")) continue;
            id = id.substring(0, id.length() - ".txt".length());
            properties = RepositoryIO.loadProperties(file.getAbsolutePath());
            e = properties.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = properties.getProperty(key);
                menuMap.put(id + "/" + key, value);
            }
        }
        return true;
    }

    public static boolean loadMenuByModelId(String modelId, Map<String, String> modelInfoMap) {
        String value;
        String key;
        Enumeration e;
        Properties properties;
        String id;
        File jfcMenu = new File(RepositoryIO.getRepositoryDirectory(), MENU_DIR);
        if (!jfcMenu.exists()) {
            return false;
        }
        File jfcMenuOrder = new File(RepositoryIO.getRepositoryDirectory(), MENUORDER_DIR);
        Collection files = FileUtils.listFiles((File)jfcMenu, (String[])new String[]{"txt"}, (boolean)false);
        for (File file : files) {
            id = file.getName();
            if (!modelId.equals(id = id.substring(0, id.length() - ".txt".length()))) continue;
            properties = RepositoryIO.loadProperties(file.getAbsolutePath());
            e = properties.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = properties.getProperty(key);
                modelInfoMap.put(key, value);
            }
        }
        files = FileUtils.listFiles((File)jfcMenuOrder, (String[])new String[]{"txt"}, (boolean)false);
        for (File file : files) {
            id = file.getName();
            if (!modelId.equals(id = id.substring(0, id.length() - ".txt".length()))) continue;
            properties = RepositoryIO.loadProperties(file.getAbsolutePath());
            e = properties.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = properties.getProperty(key);
                modelInfoMap.put(key, value);
            }
        }
        return true;
    }

    public String[] isValid() {
        return new String[0];
    }

    public void loadDomain(Map<Integer, Jfcdomain> map) {
        File domainDir = new File(RepositoryIO.getRepositoryDirectory(), DOMAIN_DIR);
        if (!domainDir.exists()) {
            return;
        }
        String id = null;
        for (File domainFile : domainDir.listFiles()) {
            String filename = domainFile.getName();
            if (!StringUtils.endsWith((CharSequence)filename, (CharSequence)".txt")) continue;
            Jfcdomain jfcdomain = new Jfcdomain();
            Properties properties = RepositoryIO.loadProperties(domainFile.getAbsolutePath());
            for (String name : properties.stringPropertyNames()) {
                String value = properties.getProperty(name);
                if ("domain/@id".equals(name)) {
                    id = value;
                    jfcdomain.setId(Integer.parseInt(id));
                    continue;
                }
                if ("domain/@domainId".equals(name)) {
                    jfcdomain.setDomainId(value);
                    continue;
                }
                if (!"domain/@content".equals(name)) continue;
                jfcdomain.setDomainName(value);
            }
            map.put(Integer.valueOf(id), jfcdomain);
        }
    }
}

