/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.repository;

import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.jasminesoft.jfc.tools.repository.RepositoryIO;
import jp.jasminesoft.jfc.tools.repository.RepositoryManager;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.util.Properties;
import jp.jasminesoft.util.ResourceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RepositoryManagerUtil {
    private static final Logger log = LogManager.getLogger(RepositoryManagerUtil.class);
    public static Map<String, String> dbSettings;
    public static Set<String> dbTypes;

    public static String getPackageName(RepositoryManager repman) {
        return repman.getProjectMap().get("project/@package");
    }

    public static String getProjectEnvironmentJavacSource(RepositoryManager repman) {
        return repman.getProjectMap().get("project/environment/@javacSource");
    }

    public static String getProjectEnvironmentJavacTarget(RepositoryManager repman) {
        return repman.getProjectMap().get("project/environment/@javacTarget");
    }

    public static String getProjectId(RepositoryManager repman) {
        return repman.getProjectMap().get("project/@id");
    }

    public static boolean isHsqldb(RepositoryManager repman) {
        String database = repman.getProjectMap().get("project/environment/database/@database");
        if (database.equals("HSQLDB(\u7d44\u307f\u8fbc\u307fDB)")) {
            database = "hsqldb";
        }
        return database != null && database.equals("hsqldb");
    }

    public static synchronized void init() {
        dbSettings = new TreeMap<String, String>();
        ResourceManager database1 = ResourceManager.getInstance((String)"database");
        Enumeration em = database1.getKeys();
        while (em.hasMoreElements()) {
            String key = (String)em.nextElement();
            String value = database1.getValue(key);
            dbSettings.put(key, value);
        }
        String basedir = RepositoryIO.getRepositoryDirectory();
        String mydatabase = basedir + "database.txt";
        if (new File(mydatabase).exists()) {
            try {
                Properties properties = RepositoryIO.loadProperties(mydatabase);
                Enumeration e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = properties.getProperty(key);
                    dbSettings.put(key, value);
                }
            }
            catch (Exception e) {
                log.error("Failed to read " + mydatabase);
            }
        }
        dbTypes = new TreeSet<String>();
        for (String key : dbSettings.keySet()) {
            if (!key.endsWith(".database_type")) continue;
            String value = dbSettings.get(key);
            dbTypes.add(value);
        }
        log.info("Available database is " + dbTypes);
    }

    public static String getHibernateDialect(RepositoryManager repman) {
        String database_type = repman.getProjectMap().get("project/environment/database/@database");
        if (StringUtils.isBlank((CharSequence)database_type)) {
            database_type = "hsqldb";
        }
        database_type = RepositoryManagerUtil.checkOldExpression(database_type, log);
        String hibernateDialect = dbSettings != null ? dbSettings.get(database_type + ".hibernateDialect") : "org.hibernate.dialect.HSQLDialect";
        return hibernateDialect;
    }

    public static String getHibernateDefaultSchema(RepositoryManager repman) {
        String schema = repman.getProjectMap().get("project/environment/database/@schema");
        if (StringUtils.isBlank((CharSequence)schema)) {
            schema = "";
        }
        return schema;
    }

    public static String checkOldExpression(String database_type, Logger log) {
        if (database_type.equals("HSQLDB(\u7d44\u307f\u8fbc\u307fDB)")) {
            log.warn("Old type:" + database_type + " is specified. it treats as hsqldb.");
            database_type = "hsqldb";
        } else if (database_type.equals("postgresql") || database_type.equals("Postgresql")) {
            log.warn("Old type:" + database_type + " is specified. it treats as postgresql82.");
            database_type = "postgresql82";
        } else if (database_type.startsWith("Oracle")) {
            log.warn("Old type:" + database_type + " is specified. it treats as oracle9i");
            database_type = "oracle9i";
        } else if (database_type.startsWith("MySQL")) {
            log.warn("Old type:" + database_type + " is specified. it treats as mysql");
            database_type = "mysql";
        } else if (database_type.startsWith("SQLServer")) {
            log.warn("Old type:" + database_type + " is specified. it treats as sqlserver2005");
            database_type = "sqlserver2005";
        } else if ("DB2".equals(database_type)) {
            log.warn("Old type:" + database_type + " is specified. it treats as db2");
            database_type = "db2";
        } else if ("DB2 AS/400".equals(database_type)) {
            log.warn("Old type:" + database_type + " is specified. it treats as db2400");
            database_type = "db2400";
        } else if ("DBMaster".equals(database_type)) {
            log.warn("Old type:" + database_type + " is specified. it treats as dbmaster");
            database_type = "dbmaster";
        } else if ("DBMaker".equals(database_type)) {
            log.warn("Old type:" + database_type + " is specified. it treats as dbmaker");
            database_type = "dbmaker";
        }
        return database_type;
    }

    public static boolean isAuthenticationTypeIsRemoteUser(RepositoryManager repman) {
        return Utils.isAuthenticationTypeIsRemoteUser(new ElementContainerAdapter(repman));
    }

    public static String getAuthLDAPUrl(RepositoryManager repman) {
        return repman.getProjectMap().get("project/environment/@auth_LDAP_url");
    }

    public static String getAuthLDAPFilter(RepositoryManager repman) {
        return repman.getProjectMap().get("project/environment/@auth_LDAP_filter");
    }

    static {
        RepositoryManagerUtil.init();
    }

    protected static class ElementContainerAdapter
    implements ElementContainer {
        protected RepositoryManager repman;

        public ElementContainerAdapter(RepositoryManager repman) {
            this.repman = repman;
        }

        @Override
        public void init() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void createRowMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setElement(String elem, int colcnt, int rowcnt) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String createRelationMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void postProcess(Set<String> modelIdSet, String filename) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getProjectRepositoryAsMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWagbyDefFileVersion(String modelname) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getAllStoreModelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getAllMasterModelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean existsModel(String id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProjectValue(String key) {
            return this.repman.getProjectMap().get(key);
        }

        @Override
        public boolean existsKeyInProject(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean existsKeyInModel(String modelId, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getModelValue(String modelId, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getKeysByModel(String modelId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getKeysByModelAndKeyPrefix(String modelId, String keyprefix) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getLayoutLabels(String modelId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getKeysByLayoutLabel(String modelId, String label) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLayoutValue(String modelId, String label, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getModelitemNames(String modelId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getModelitemNamesByKey(String modelId, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getModelitemNamesByKeyPrefix(String modelId, String keyprefix) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getKeysByModelitemName(String modelId, String itemname) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getKeysByModelitemNameAndKeyPrefix(String modelId, String itemname, String keyprefix) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean existsKeyInModelitem(String modelId, String itemname, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getModelitemValue(String modelId, String itemname, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean checkError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getPrincipals(String modelId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getKeysByPrincipal(String modelId, String principal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrincipalValue(String modelId, String principal, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getPermissions(String modelId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getPermissionsByPrincipal(String modelId, String principalId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getKeysByPermission(String modelId, String permission) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPermissionValue(String modelId, String permission, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeModelId(String modelId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public File getInitialDataSaveDir(String modelId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUserRule(TreeMap<String, TreeMap<String, Set<String>>> udMap, Map<String, Map<String, String>> udRuleMap) {
            throw new UnsupportedOperationException();
        }
    }
}

