/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.repository;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.jasminesoft.jfc.tools.repository.ModelType;
import jp.jasminesoft.jfc.tools.repository.RepositoryDef;
import jp.jasminesoft.jfc.tools.repository.RepositoryItem;
import jp.jasminesoft.jfc.tools.repository.RepositoryKey;
import jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo;
import jp.jasminesoft.jfc.tools.xls2appschema.ModelitemInfo;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class RepositoryUtil {
    public static String[] classify4Modelitem;
    private static String[] systemModelIds;

    public static String[] getModelitemNames(Map<ModelitemInfo, String> modelitemInfoMap) {
        if (modelitemInfoMap == null || modelitemInfoMap.size() == 0) {
            return new String[0];
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (ModelitemInfo mitemInfo : modelitemInfoMap.keySet()) {
            if (!mitemInfo.getKey().equals("model/modelitem/@name")) continue;
            nameList.add(modelitemInfoMap.get(mitemInfo));
        }
        TreeMap<Integer, String> smap = new TreeMap<Integer, String>();
        for (String name : nameList) {
            int lineNo = StringUtil.intValue((String)modelitemInfoMap.get(new ModelitemInfo("model/modelitem/@__linenumber", name)));
            smap.put(lineNo, name);
        }
        return smap.values().toArray(new String[smap.size()]);
    }

    public static String getLabel(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "";
        }
        int ptr = s.lastIndexOf(">");
        if (ptr < 0) {
            return s;
        }
        return s.substring(ptr + 1);
    }

    public static ModelType getModelType(ModelInfo modelInfo) {
        SortedMap<String, String> modelInfoMap = modelInfo.getModelInfoMap();
        String type = (String)modelInfoMap.get("model/@type");
        ModelType mtype = null;
        mtype = "master".equals(type) ? ModelType.Master : ModelType.Store;
        return mtype;
    }

    public static boolean isSystemModel(String id) {
        if (id.startsWith("jfc")) {
            return true;
        }
        for (String s : systemModelIds) {
            if (!id.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static String getRepositoryKeyByResource(String name, RepositoryItem[] ritems) {
        for (RepositoryItem ritem : ritems) {
            if (!ritem.getName().equals(name)) continue;
            RepositoryKey[] rkeys = ritem.getRepositoryKey();
            return rkeys[0].getKey();
        }
        return null;
    }

    public static String getTitleResourceKeyByResource(String name, RepositoryItem[] ritems) {
        for (RepositoryItem ritem : ritems) {
            if (!ritem.getName().equals(name)) continue;
            return ritem.getTitleResourceKey();
        }
        return null;
    }

    public static String[] getActions(ModelInfo modelInfo) {
        LinkedHashSet<Object> actionSet = new LinkedHashSet<Object>();
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("action/@showPage")))) {
            actionSet.add("show");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("action/@showListPage")))) {
            actionSet.add("showList");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("action/@insertPage")))) {
            actionSet.add("insert");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("action/@updatePage")))) {
            actionSet.add("update");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("model/@calendarOutput")))) {
            actionSet.add("showListCalendar");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("model/@mapviewOutput")))) {
            actionSet.add("showListMap");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("action/@reportListPage")))) {
            actionSet.add("showListReport");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("action/@updateListPage")))) {
            actionSet.add("updateList");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("model/@csvOutput")))) {
            actionSet.add("download");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get("model/@uploadupdateOutput")))) {
            actionSet.add("uploadUpdate");
        }
        for (int i = 1; i <= 10; ++i) {
            Object key = "model/@totalviewOutput";
            if (i >= 2) {
                key = (String)key + i;
            }
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)modelInfo.getModelInfoMap().get(key)))) continue;
            actionSet.add("total" + i);
        }
        return actionSet.toArray(new String[actionSet.size()]);
    }

    static {
        TreeSet<String> tset = new TreeSet<String>();
        for (RepositoryItem ritem : RepositoryDef.ritems) {
            String classifyResourceKey = ritem.getClassifyResourceKey();
            if (!classifyResourceKey.startsWith("r.classify.modelitem.")) continue;
            int ptr = classifyResourceKey.lastIndexOf(".");
            tset.add(classifyResourceKey.substring(ptr + 1));
        }
        classify4Modelitem = tset.toArray(new String[tset.size()]);
        systemModelIds = new String[]{"jprincipal", "seq", "compulsoryChange_m", "holidaytype_m", "hour_m", "minute_m", "movestep_m", "jpermission_m", "jgroup", "jholiday", "juser", "jnews"};
    }
}

