/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.csv2xml.XLSParser;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.repository.R8RepositoryConverter;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.AppschemaChecker;
import jp.jasminesoft.jfc.tools.xls2appschema.CacheFileManager;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.ErrorChecker;
import jp.jasminesoft.jfc.tools.xls2appschema.GenerationModels;
import jp.jasminesoft.jfc.tools.xls2appschema.MessageListener;
import jp.jasminesoft.jfc.tools.xls2appschema.MessageResourceManager;
import jp.jasminesoft.jfc.tools.xls2appschema.ProjectOuterlinkContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.RearrangeMenuId;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefSheetHandler;
import jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6ProjectFilterContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6ProjectOuterlinkContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.XMLFormatter;
import jp.jasminesoft.jfc.tools.xls2appschema.XMLFormatterFactory;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.DisplaytextFactory;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.PUtils;
import jp.jasminesoft.util.ExtensionFilenameFilter;
import jp.jasminesoft.util.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.xml.sax.SAXException;

public class AppSchemaGenerator {
    private Logger log = LogManager.getLogger(AppSchemaGenerator.class);
    private ResourceManager rman = ResourceManager.getInstance((String)"x2aj");
    public static final String outputfilename = "appschema.xml";
    public static final String encoding = "UTF-8";
    @Autowired
    private ApplicationContext context_;
    private XLSParser xlsParser_;
    private XLSParser xlsParser4Mail_;
    private XLSParser xlsParser4ProjectOuterlink_;
    private XLSParser xlsParser4ProjectFilter_;
    @Autowired(required=true)
    private MessageListener messageListener_;
    @Autowired
    private ErrorChecker[] errorCheckers_;
    @Autowired
    private AppschemaChecker[] appschemaCheckers_;
    @Autowired(required=true)
    private CacheFileManager cacheFileManager_;
    @Autowired
    private GenerationModels generationModels_;
    @Autowired(required=true)
    protected ProjectOuterlinkContainer pcon_;
    private List<AppSchemaBuilder> appschemaBuilderList_;
    private Set<String> processedFileSet = new HashSet<String>();
    private static final String CR = System.getProperty("line.separator");

    public void setAppSchemaBuilder(List<AppSchemaBuilder> list) {
        this.appschemaBuilderList_ = list;
    }

    public void setXLSParser(XLSParser xlsParser) {
        this.xlsParser_ = xlsParser;
    }

    public void setXLSParser4Mail(XLSParser xlsParser) {
        this.xlsParser4Mail_ = xlsParser;
    }

    public void setXLSParser4ProjectOuterlink(XLSParser xlsParser) {
        this.xlsParser4ProjectOuterlink_ = xlsParser;
    }

    public void setXLSParser4ProjectFilter(XLSParser xlsParser) {
        this.xlsParser4ProjectFilter_ = xlsParser;
    }

    private void readProjectDefinition(String dirname, XLSParser parser) {
        File dir = new File(dirname);
        if (!dir.exists() && !dir.isDirectory()) {
            this.log.error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.notfound_or_notfolder", new Object[]{dir.getAbsolutePath()}));
            return;
        }
        boolean needsReadFlag = false;
        String[] suffixes = new String[]{".xls"};
        String[] filenames = dir.list((FilenameFilter)new ExtensionFilenameFilter(suffixes, false));
        ArrayList<File> list = new ArrayList<File>();
        for (String filename : filenames) {
            if (!"project.xls".equals(filename) && !"project_env.xls".equals(filename)) continue;
            File target = new File(dir.getAbsolutePath() + File.separator + filename);
            list.add(target);
            if (!"project.xls".equals(filename) && !this.cacheFileManager_.invalidate(target)) continue;
            this.cacheFileManager_.clear4ProjectFile(filename);
            needsReadFlag = true;
        }
        if (needsReadFlag) {
            for (File target : list) {
                try {
                    this.log.info(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.loading", new Object[]{target.getCanonicalPath()}));
                    this.cacheFileManager_.regist(target);
                    parser.parse(target);
                }
                catch (IOException e) {
                    this.log.error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.raise_error", new Object[]{e.getMessage()}));
                }
            }
        }
        MessageResourceManager.load((ElementContainer)this.context_.getBean("elementContainer"));
    }

    private void readProjectOuterlinkDefinition(String dirname, XLSParser parser) {
        String filename = "project_outerlink.xls";
        File file = new File(dirname + File.separator + filename);
        if (!file.exists()) {
            this.log.error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.notfound", new Object[]{file.getAbsolutePath()}));
            return;
        }
        boolean isInvalidateCacheFlag = false;
        if (this.cacheFileManager_.invalidate(file)) {
            this.cacheFileManager_.clear4ProjectFile(filename);
            isInvalidateCacheFlag = true;
        }
        try {
            this.log.info(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.loading", new Object[]{file.getCanonicalPath()}));
            if (isInvalidateCacheFlag) {
                this.cacheFileManager_.regist(file);
            }
            parser.parse(file);
        }
        catch (IOException e) {
            this.log.error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.raise_error", new Object[]{e.getMessage()}));
        }
    }

    public void readProjectFilterDefinition(String dirname, XLSParser parser) {
        String filename = "project_filter.xls";
        File file = new File(dirname + File.separator + filename);
        if (!file.exists()) {
            return;
        }
        try {
            parser.parse(file);
        }
        catch (IOException e) {
            this.log.error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.raise_error", new Object[]{e.getMessage()}));
        }
    }

    private void readModelDefinition(String dirname, XLSParser parser, boolean isClearRest) {
        File dir = new File(dirname);
        if (!dir.exists() && !dir.isDirectory()) {
            this.log.error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.notfound_or_notfolder", new Object[]{dir.getAbsolutePath()}));
            return;
        }
        String[] suffixes = new String[]{".xls"};
        String[] filenames = dir.list((FilenameFilter)new ExtensionFilenameFilter(suffixes, false));
        ArrayList<File> list = new ArrayList<File>();
        ArrayList<String> duplicate_common_list = new ArrayList<String>();
        HashSet<String> allFilenames = new HashSet<String>();
        for (String filename : filenames) {
            if (this.processedFileSet.contains(filename)) {
                if (filename.startsWith("common-")) {
                    duplicate_common_list.add(filename);
                    continue;
                }
                this.log.error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.duplicate", new Object[]{filename}));
                continue;
            }
            File target = null;
            target = new File(dir.getAbsolutePath() + File.separator + filename);
            if (this.cacheFileManager_.invalidate(target)) {
                this.cacheFileManager_.clear(filename);
                list.add(target);
                this.processedFileSet.add(filename);
            }
            allFilenames.add(CacheFileManager.createRelativePathName(target.getPath()));
        }
        if (isClearRest) {
            this.cacheFileManager_.clearRest(allFilenames);
        }
        if (duplicate_common_list.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String filename : duplicate_common_list) {
                sb.append(filename);
                sb.append(", ");
            }
            this.log.error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaGenerator.readModelDefinition", new Object[]{sb.substring(0, sb.length() - 2)}));
        }
        if (list.size() == 0) {
            Object path = dir.getAbsolutePath();
            path = ((String)path).endsWith("xls-common") ? (String)path + File.separator + ".." + File.separator + ".." + File.separator + "xls-model" + File.separator + "base.xls" : (String)path + File.separator + "base.xls";
            list.add(new File((String)path));
        }
        for (File target : list) {
            try {
                this.log.info(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.loading", new Object[]{target.getCanonicalPath()}));
                this.cacheFileManager_.regist(target);
                parser.parse(target);
            }
            catch (IOException e) {
                this.log.error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.raise_error", new Object[]{e.getMessage()}));
            }
        }
    }

    public void process(String targetDirectory, String format) {
        this.process(targetDirectory, format, false);
    }

    public void process(String targetDirectory, String format, boolean forceConvert6to8) {
        this.cacheFileManager_.init();
        if (!this.cacheFileManager_.isSkipReadingExcelFiles()) {
            this.readProjectDefinition(targetDirectory + File.separator + "xls-project", this.xlsParser_);
            this.readProjectOuterlinkDefinition(targetDirectory + File.separator + "xls-project", this.xlsParser4ProjectOuterlink_);
            this.readProjectFilterDefinition(targetDirectory + File.separator + "xls-project", this.xlsParser4ProjectFilter_);
            this.readModelDefinition(targetDirectory + File.separator + "env" + File.separator + "xls-common", this.xlsParser_, false);
            this.readModelDefinition(targetDirectory + File.separator + "xls-model", this.xlsParser_, true);
        } else {
            this.cacheFileManager_.getElementContainer().init();
            this.pcon_.init();
        }
        if (forceConvert6to8) {
            this.log.info("Convert R6 to R8 repository format...");
            this.forceConvert6to8process();
            this.cacheFileManager_.setUseCache(true);
            WagbyR6DefElementContainer.reset();
            this.cacheFileManager_.getElementContainer().init();
            this.pcon_.init();
        }
        this.outputError();
        if (this.hasError()) {
            this.cacheFileManager_.removeAllCacheFiles();
            return;
        }
        if (!forceConvert6to8) {
            this.cacheFileManager_.saveFileMap();
        }
        for (ErrorChecker checker : this.errorCheckers_) {
            checker.check();
        }
        this.outputWarn();
        this.outputError();
        Project project = new Project();
        for (AppSchemaBuilder part : this.appschemaBuilderList_) {
            part.process(project);
        }
        for (AppschemaChecker checker : this.appschemaCheckers_) {
            checker.check(project);
        }
        if (!this.hasError()) {
            this.generationModels_.process(project);
        }
        new RearrangeMenuId(project).process();
        try {
            XMLFormatter formatter = XMLFormatterFactory.create(format, outputfilename, encoding);
            formatter.format(project);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        this.outputWarn();
        this.outputError();
        this.outputInfo();
    }

    private void forceConvert6to8process() {
        new R8RepositoryConverter().forceConvert("work" + File.separator + "repository");
    }

    private boolean hasError() {
        return this.messageListener_.sizeError() > 0;
    }

    private void outputError() {
        if (this.messageListener_.sizeError() > 0) {
            String[] errmsgs;
            for (String msg : errmsgs = this.messageListener_.getErrorMessagesAsString()) {
                this.log.error(msg);
            }
        }
    }

    private void outputWarn() {
        if (this.messageListener_.sizeWarn() > 0) {
            String[] warnmsgs;
            for (String msg : warnmsgs = this.messageListener_.getWarnMessagesAsString()) {
                this.log.warn(msg);
            }
        }
    }

    private void outputInfo() {
        if (this.messageListener_.sizeInfo() > 0) {
            String[] infomsgs;
            for (String msg : infomsgs = this.messageListener_.getInfoMessagesAsString()) {
                this.log.info(msg);
            }
        }
    }

    public void finish() {
        this.log.info(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaGenerator.finish"));
    }

    public static void reset() {
        AppSchemaUtil.reset();
        DisplaytextFactory.reset();
        RearrangeMenuId.reset();
        Utils.reset();
        WagbyR6DefElementContainer.reset();
        WagbyR6DefSheetHandler.reset();
        WagbyR6ProjectFilterContainer.reset();
        WagbyR6ProjectOuterlinkContainer.reset();
        PUtils.reset();
    }

    public static boolean readXmlFragment(String modelId, String element, Project project, Logger log) {
        Model ipc = null;
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        boolean addFromFile = false;
        int count = -1;
        Path path = Paths.get(".", "appschema", element + "-" + modelId + ".xls.xml");
        if (Files.exists(path, new LinkOption[0])) {
            log.debug("Reading " + path.toFile().getName() + "...");
            try {
                StringBuilder sb = new StringBuilder();
                List<String> lines = Files.readAllLines(path);
                boolean beginModel = false;
                for (String line : lines) {
                    String nline = line.trim();
                    ++count;
                    if (nline.startsWith("<?xml")) continue;
                    if (!beginModel && nline.startsWith("<" + element + " ")) {
                        beginModel = true;
                        sb.append(line).append(CR);
                        if (!nline.endsWith("/>")) continue;
                        if ("model".equals(element)) {
                            ipc = factory.createModel((Reader)new StringReader(sb.toString()), project.rGetRContext());
                        } else if ("action".equals(element)) {
                            ipc = factory.createAction((Reader)new StringReader(sb.toString()), project.rGetRContext());
                        } else if ("presentation".equals(element)) {
                            ipc = factory.createPresentation((Reader)new StringReader(sb.toString()), project.rGetRContext());
                        } else {
                            log.error("illegal parameter, modelId=" + modelId + ",element=" + element);
                        }
                        if (ipc != null) {
                            project.addContent((IProjectChoice)ipc);
                            addFromFile = true;
                        }
                        sb = new StringBuilder();
                        beginModel = false;
                        continue;
                    }
                    if (beginModel && !nline.startsWith("</" + element + ">")) {
                        sb.append(line).append(CR);
                        continue;
                    }
                    if (!beginModel || !nline.startsWith("</" + element + ">")) continue;
                    sb.append(line).append(CR);
                    if ("model".equals(element)) {
                        ipc = factory.createModel((Reader)new StringReader(sb.toString()), project.rGetRContext());
                    } else if ("action".equals(element)) {
                        ipc = factory.createAction((Reader)new StringReader(sb.toString()), project.rGetRContext());
                    } else if ("presentation".equals(element)) {
                        ipc = factory.createPresentation((Reader)new StringReader(sb.toString()), project.rGetRContext());
                    } else {
                        log.error("illegal parameter, modelId=" + modelId + ",element=" + element);
                    }
                    if (ipc != null) {
                        project.addContent((IProjectChoice)ipc);
                        addFromFile = true;
                    }
                    sb = new StringBuilder();
                    beginModel = false;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                log.error(e.getMessage(), (Throwable)e);
                addFromFile = false;
            }
        }
        if (count == 0) {
            log.debug("Empty content: " + path.toFile().getName());
            addFromFile = true;
        }
        return addFromFile;
    }
}

