/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaGenerator;
import jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main {
    private static Options options = new Options();

    public static void main(String[] args) {
        String target = null;
        String format = "normalize";
        boolean forceConvert6to8 = false;
        PosixParser parse = new PosixParser();
        try {
            CommandLine line = parse.parse(options, args);
            for (Option option : line) {
                String oname = option.getOpt();
                if ("target".equals(oname)) {
                    target = option.getValue();
                    continue;
                }
                if ("format".equals(oname)) {
                    format = line.getOptionValue("format");
                    continue;
                }
                if ("forceConvert6to8".equals(oname)) {
                    forceConvert6to8 = true;
                    continue;
                }
                if (!"help".equals(oname)) continue;
                Main.showHelpMessage();
                System.exit(1);
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        AppSchemaUtil.setCacheProcess((boolean)false);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
        AppSchemaGenerator gen = (AppSchemaGenerator)context.getBean("appschemaGenerator");
        if (target == null) {
            Main.showHelpMessage();
        }
        if (forceConvert6to8) {
            ModelInfo.setEcoSave(false);
        }
        gen.process(target, format, forceConvert6to8);
        gen.finish();
    }

    private static void showHelpMessage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Usage jp.jasminesoft.jfc.tools.xls2appschema.Main", options);
    }

    static {
        OptionBuilder.withArgName((String)"directoryname");
        OptionBuilder.withDescription((String)"Set target directory.");
        OptionBuilder.hasArg();
        Option target = OptionBuilder.create((String)"target");
        OptionBuilder.withArgName((String)"format");
        OptionBuilder.withDescription((String)"Choose 'simple' or 'normalize'. the default output type is 'simple'.");
        OptionBuilder.hasArg();
        Option format = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"forceConvert6to8");
        OptionBuilder.withDescription((String)"Set 'true' when daily build test.");
        OptionBuilder.hasArg((boolean)false);
        Option forceConvert6to8 = OptionBuilder.create((String)"forceConvert6to8");
        Option help = new Option("help", "print this message");
        options.addOption(target);
        options.addOption(format);
        options.addOption(forceConvert6to8);
        options.addOption(help);
    }
}

