/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.csv2xml.CSVContentHandler;
import jp.jasminesoft.csv2xml.ReplaceCharacter;
import jp.jasminesoft.csv2xml.XLSParser;
import jp.jasminesoft.util.ExtensionFilenameFilter;
import org.apache.commons.lang3.StringUtils;

public class ModelnameChecker {
    public static final String DIRNAME = ".." + File.separator + "xls-model";

    public static void main(String[] args) {
        String[] filenames;
        ModelnameChecker checker = new ModelnameChecker();
        File dir = new File(DIRNAME);
        if (!dir.exists() && !dir.isDirectory()) {
            System.err.println(dir.getAbsolutePath() + " \u304c\u898b\u3064\u304b\u3089\u306a\u3044\u304b\u3001\u307e\u305f\u306f\u30d5\u30a9\u30eb\u30c0\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        String[] suffixes = new String[]{".xls"};
        for (String filename : filenames = dir.list((FilenameFilter)new ExtensionFilenameFilter(suffixes, false))) {
            if ("base.xls".equals(filename)) continue;
            try {
                File target = new File(dir.getAbsolutePath() + File.separator + filename);
                System.out.println("\u30d5\u30a1\u30a4\u30eb " + target.getCanonicalPath() + " \u3092\u8aad\u307f\u8fbc\u307f\u4e2d...");
                checker.process(target);
            }
            catch (IOException e) {
                System.err.println("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + e.getMessage());
            }
        }
    }

    public void process(File target) {
        XLSParser parser = new XLSParser();
        parser.setCSVContentHandler(new CSVContentHandler(){
            private ReplaceCharacter repl = new ReplaceCharacter();
            private String version;
            private KeyWord keyword;
            private Map<String, ModelnameInfo> mmap = new HashMap<String, ModelnameInfo>();
            private ModelnameInfo tmpData_;

            public void beginCSV(String filename) throws IOException {
            }

            public void endCSV(String filename) throws IOException {
                System.out.println("Wagby \u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u306e\u30d0\u30fc\u30b8\u30e7\u30f3:" + this.version);
                for (ModelnameInfo p : this.mmap.values()) {
                    if (!p.isValid()) continue;
                    System.out.println(p);
                }
                System.out.println();
            }

            public void beginSheet(int sheetnum, String name) throws IOException {
            }

            public void endSheet(int sheetnum, String name) throws IOException {
            }

            public void beginRow(int rowcnt) throws IOException {
            }

            public void endRow(int rowcnt) throws IOException {
            }

            public void beginColumn(int colcnt) throws IOException {
            }

            public void endColumn(int colcnt) throws IOException {
            }

            public void characters(char[] ch, int start, int length) throws IOException {
                StringBuilder sb = new StringBuilder();
                for (char c : ch) {
                    sb.append(c);
                }
                String s = this.repl.convertString(sb.toString());
                String content = s.trim();
                if (StringUtils.isBlank((CharSequence)content)) {
                    return;
                }
                if (this.keyword != null) {
                    if (this.keyword == KeyWord.Model) {
                        if (StringUtils.isNumeric((CharSequence)content)) {
                            return;
                        }
                        this.tmpData_ = new ModelnameInfo();
                        this.tmpData_.modelname = content;
                    } else if (this.keyword == KeyWord.Description) {
                        if (this.tmpData_ != null) {
                            if (!"model/@id".equals(content)) {
                                this.tmpData_.desc = content;
                            }
                            System.out.println(this.tmpData_);
                            this.mmap.put(this.tmpData_.modelname, this.tmpData_);
                        }
                    } else if (this.keyword == KeyWord.Repository) {
                        this.version = content;
                        this.keyword = null;
                    }
                    System.out.println(this.keyword + "=" + content);
                    this.keyword = null;
                    return;
                }
                this.keyword = "repository".equals(content) && this.version == null ? KeyWord.Repository : ("model/@id".equals(content) ? KeyWord.Model : ("model/@description".equals(content) ? KeyWord.Description : null));
            }

            class ModelnameInfo {
                String modelname;
                String desc;

                ModelnameInfo() {
                }

                public boolean isValid() {
                    return !"main".equals(this.modelname) || !"master".equals(this.desc);
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.modelname);
                    if (StringUtils.isNotBlank((CharSequence)this.desc)) {
                        sb.append(" (");
                        sb.append(this.desc);
                        sb.append(")");
                    }
                    return sb.toString();
                }
            }
        });
        try {
            parser.parse(target);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static enum KeyWord {
        Repository,
        Model,
        Description;

    }
}

