/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Acl;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Filterlist;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Jarfilelist;
import jp.jasminesoft.jfc.gen.appschema.Javascriptlist;
import jp.jasminesoft.jfc.gen.appschema.Jfcdomains;
import jp.jasminesoft.jfc.gen.appschema.Jfcmodels;
import jp.jasminesoft.jfc.gen.appschema.Job;
import jp.jasminesoft.jfc.gen.appschema.Keyevent;
import jp.jasminesoft.jfc.gen.appschema.Manifestlist;
import jp.jasminesoft.jfc.gen.appschema.Menubar;
import jp.jasminesoft.jfc.gen.appschema.Menulinkaction;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Permission;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Principal;
import jp.jasminesoft.jfc.gen.appschema.Printlayout;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Propertiesfile;
import jp.jasminesoft.jfc.tools.xls2appschema.PermissionComparator;
import jp.jasminesoft.jfc.tools.xls2appschema.SimpleXMLFormatter;
import jp.jasminesoft.jfc.tools.xls2appschema.XMLFormatter;
import jp.jasminesoft.util.XMLManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NormalizeXMLFormatter
implements XMLFormatter {
    protected static Logger log = LogManager.getLogger(NormalizeXMLFormatter.class);
    private static final String CR = System.getProperty("line.separator");
    private String outputdirectory_;
    private String outputfilename_;
    private String encoding_;
    private Map<String, Integer> elementSizeMap;
    private static Options options = new Options();

    public NormalizeXMLFormatter(String outputfilename, String encoding) {
        this.outputfilename_ = outputfilename;
        this.encoding_ = encoding;
        this.elementSizeMap = new HashMap<String, Integer>();
    }

    public void setOutputDirectory(String outputdirectory) {
        this.outputdirectory_ = outputdirectory;
    }

    private void init() {
        this.createDirectory("appschema");
        if (StringUtils.isNotBlank((CharSequence)this.outputdirectory_)) {
            this.createDirectory(this.outputdirectory_);
            this.createDirectory(this.outputdirectory_ + File.separator + "appschema");
        }
    }

    private void createDirectory(String dirname) {
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    @Override
    public void format(Project project) {
        this.init();
        ArrayList<ElementProcessor> eplist = new ArrayList<ElementProcessor>();
        eplist.add(new FilterlistProcessor());
        eplist.add(new CommonElementProcessor());
        eplist.add(new JcategoryProcessor());
        eplist.add(new JpermissionProcessor());
        eplist.add(new JprincipalProcessor());
        eplist.add(new MenulinkactionProcessor());
        eplist.add(new PropertiesfileProcessor());
        eplist.add(new PrintlayoutProcessor());
        eplist.add(new JobProcessor());
        eplist.add(new KeyeventProcessor());
        ArrayList<String> modelList = new ArrayList<String>();
        ArrayList<String> masterList = new ArrayList<String>();
        this.output_projectPackage(project);
        this.output_environment(project);
        this.output_manifestlist(project);
        this.output_javascriptlist(project);
        this.output_acl(project);
        this.output_menubar(project);
        this.output_jfcdomains(project);
        this.output_jfcdomodels(project);
        this.output_root(project, eplist, modelList, masterList);
        this.output_modelActionPresentation(project, modelList, new NormalModelOutputProcessor());
        this.output_modelActionPresentation(project, masterList, new MasterModelOutputProcessor());
        for (ElementProcessor ep : eplist) {
            ep.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output_root(Project project, List<ElementProcessor> eplist, List<String> modelList, List<String> masterList) {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipcs = project.getContent();
        for (IProjectChoice ipc : ipcs) {
            Model model;
            String modelId;
            for (ElementProcessor ep : eplist) {
                ep.process(ipc);
            }
            if (!(ipc instanceof Model) || this.isReservedId(modelId = (model = (Model)ipc).getId())) continue;
            if (AppSchemaUtil.isStoreModel((Model)model)) {
                modelList.add(modelId);
                sb.append(this.createEntityElement("model", modelId));
                sb.append(this.createEntityElement("action", modelId));
                sb.append(this.createEntityElement("presentation", modelId));
                sb.append(CR);
                continue;
            }
            if (!"master".equals(model.getType())) continue;
            masterList.add(modelId);
            sb.append(this.createEntityElement("master", modelId));
        }
        sb.append("]>");
        sb.append(CR);
        sb.append(CR);
        this.insertPreparedContent(sb, this.getContent2());
        this.insertPreparedContent(sb, this.getContent1());
        sb.append("<project version=\"" + project.getVersionAsString() + "\"" + CR);
        sb.append("         name=\"" + project.getName() + "\"" + CR);
        if (StringUtils.isNotBlank((CharSequence)project.getWebappname())) {
            sb.append("         webappname=\"" + project.getWebappname() + "\"" + CR);
        }
        sb.append("         debug=\"" + project.getDebugAsString() + "\"" + CR);
        sb.append("         debugcompile=\"" + project.getDebugcompileAsString() + "\"" + CR);
        sb.append("         title=\"" + project.getTitle() + "\"" + CR);
        sb.append("         basedir=\"" + project.getBasedir() + "\"" + CR);
        sb.append("         useCVS=\"" + project.getUseCVSAsString() + "\"" + CR);
        sb.append("         package=\"" + project.getPackage() + "\"" + CR);
        sb.append("         encoding=\"" + project.getEncoding() + "\"" + CR);
        sb.append("         webencoding=\"" + project.getWebencoding() + "\"" + CR);
        sb.append("         relaxer=\"" + project.getRelaxer() + "\"" + CR);
        sb.append("         relaxSchemaType=\"" + project.getRelaxSchemaType() + "\"" + CR);
        sb.append("         description=\"" + project.getDescription() + "\"" + CR);
        sb.append("         licensekey=\"" + project.getLicensekey() + "\">" + CR);
        sb.append(CR);
        this.createPreparedContent(sb, this.getContent3());
        sb.append(CR);
        for (String modelId : modelList) {
            sb.append(this.createEntityReference("model", modelId));
            sb.append(this.createEntityReference("action", modelId));
            sb.append(this.createEntityReference("presentation", modelId));
            sb.append(CR);
        }
        for (String modelId : masterList) {
            sb.append(this.createEntityReference("master", modelId));
            sb.append(CR);
        }
        this.createPreparedContent(sb, this.getContent4());
        sb.append(CR);
        sb.append("</project>");
        sb.append(CR);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.createOutputFilename(this.outputfilename_)), this.encoding_)));
            writer.write(sb.toString());
        }
    }

    private int output_modelActionPresentation(Project project, List<String> modelList, ModelOutputProcessor processor) {
        int numOfTargetSet = 0;
        for (String modelId : modelList) {
            IProjectChoice[] ipcs;
            LinkedHashSet<Object> targetSet = new LinkedHashSet<Object>();
            HashSet<String> actionSet = new HashSet<String>();
            for (IProjectChoice ipc : ipcs = project.getContent()) {
                Presentation presentation;
                String idref;
                if (ipc instanceof Model) {
                    Model model = (Model)ipc;
                    if (modelId.equals(model.getId())) {
                        targetSet.add(model);
                        continue;
                    }
                    idref = model.getIdref();
                    if (StringUtils.isBlank((CharSequence)idref)) continue;
                    if (modelId.equals(idref)) {
                        targetSet.add(model);
                        continue;
                    }
                    if (idref.endsWith("_c")) {
                        if ((idref = idref.substring(0, idref.length() - "_c".length())).endsWith("_jshparam")) {
                            idref = idref.substring(0, idref.length() - "_jshparam".length());
                        }
                    } else if (idref.endsWith("_l")) {
                        idref = idref.substring(0, idref.length() - "_l".length());
                    } else if (idref.endsWith("_t")) {
                        if ((idref = idref.substring(0, idref.length() - "_t".length())).endsWith("T2") || idref.endsWith("T3") || idref.endsWith("T4") || idref.endsWith("T5") || idref.endsWith("T6") || idref.endsWith("T7") || idref.endsWith("T8") || idref.endsWith("T9")) {
                            idref = idref.substring(0, idref.length() - "T?".length());
                        } else if (idref.endsWith("T10")) {
                            idref = idref.substring(0, idref.length() - "T10".length());
                        }
                    }
                    if (!modelId.equals(idref)) continue;
                    targetSet.add(model);
                    continue;
                }
                if (ipc instanceof Action) {
                    Action action = (Action)ipc;
                    if (!modelId.equals(action.getIdref())) continue;
                    targetSet.add(action);
                    actionSet.add(action.getId());
                    continue;
                }
                if (!(ipc instanceof Presentation) || !actionSet.contains(idref = (presentation = (Presentation)ipc).getIdref())) continue;
                targetSet.add(presentation);
            }
            processor.process(modelId, targetSet);
            numOfTargetSet = targetSet.size();
        }
        return numOfTargetSet;
    }

    private void output_projectPackage(Project project) {
        Document doc = XMLManager.createDocument();
        Element element = doc.createElement("project");
        element.setAttribute("package", project.getPackage());
        doc.appendChild(element);
        doc.appendChild(doc.createComment(" for srcgen_template_javasrc target in build-dev.xml "));
        this.saveDocument("projectPackage", doc);
    }

    private void output_environment(Project project) {
        Document doc = null;
        Environment environment = project.getEnvironment();
        if (environment != null) {
            try {
                doc = environment.makeDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        this.saveDocument("environment", doc);
    }

    private void output_manifestlist(Project project) {
        Jarfilelist jarfilelsit;
        ArrayList<Document> list = new ArrayList<Document>();
        Manifestlist manifestlist = project.getManifestlist();
        if (manifestlist != null) {
            try {
                Document doc = manifestlist.makeDocument();
                if (doc != null) {
                    list.add(doc);
                }
            }
            catch (ParserConfigurationException doc) {
                // empty catch block
            }
        }
        if ((jarfilelsit = project.getJarfilelist()) != null) {
            try {
                Document doc = jarfilelsit.makeDocument();
                if (doc != null) {
                    list.add(doc);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        this.saveDocument("manifest", list.toArray(new Document[0]));
    }

    private void output_javascriptlist(Project project) {
        Document doc = null;
        Javascriptlist javascriptlist = project.getJavascriptlist();
        if (javascriptlist != null) {
            try {
                doc = javascriptlist.makeDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        this.saveDocument("javascript", doc);
    }

    private void output_acl(Project project) {
        Document doc = null;
        Acl acl = project.getAcl();
        if (acl != null) {
            for (Principal principal : acl.getPrincipal()) {
                HashSet<Permission> permissionSet = new HashSet<Permission>();
                for (Permission permission : principal.getPermission()) {
                    principal.removePermission(permission);
                    permissionSet.add(permission);
                }
                Permission[] permission_arr = permissionSet.toArray(new Permission[0]);
                Arrays.sort(permission_arr, new PermissionComparator());
                principal.addPermission(permission_arr);
            }
            try {
                doc = acl.makeDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        this.saveDocument("acl", doc);
    }

    private void output_menubar(Project project) {
        Document doc = null;
        Menubar menubar = project.getMenubar();
        if (menubar != null) {
            try {
                doc = menubar.makeDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        this.saveDocument("menubar", doc);
    }

    private void output_jfcdomains(Project project) {
        Document doc = null;
        Jfcdomains jfcdomains = project.getJfcdomains();
        if (jfcdomains != null) {
            try {
                doc = jfcdomains.makeDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        this.saveDocument("jfcdomains", doc);
    }

    private void output_jfcdomodels(Project project) {
        Document doc = null;
        Jfcmodels jfcmodels = project.getJfcmodels();
        if (jfcmodels != null) {
            try {
                doc = jfcmodels.makeDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        this.saveDocument("jfcmodels", doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocument(String name, Object obj) {
        String filename = "appschema" + File.separator + name + ".xml";
        try (PrintWriter writer = null;){
            StringBuilder header = new StringBuilder();
            this.createPreparedContent(header, this.getContent1());
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.createOutputFilename(filename)), this.encoding_)));
            writer.write(header.toString());
            writer.write(CR);
            SimpleXMLFormatter formatter = new SimpleXMLFormatter(writer);
            if (obj instanceof Document) {
                Document doc = (Document)obj;
                formatter.format(doc);
            } else if (obj instanceof Document[]) {
                Document[] docs;
                for (Document doc : docs = (Document[])obj) {
                    formatter.format(doc);
                    writer.write(CR);
                }
            }
        }
    }

    private String createOutputFilename(String outputfilename_) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.outputdirectory_)) {
            sb.append(this.outputdirectory_);
            sb.append(File.separator);
        }
        sb.append(outputfilename_);
        return sb.toString();
    }

    private String createEntityReference(String prefix, String modelId) {
        String entityname = this.createEntityName(prefix, modelId);
        StringBuilder sb = new StringBuilder();
        sb.append("  &");
        sb.append(entityname);
        sb.append(";");
        sb.append(CR);
        return sb.toString();
    }

    private String createEntityElement(String prefix, String modelId) {
        String entityname = this.createEntityName(prefix, modelId);
        String filename = this.createEntityFileName(prefix, modelId);
        StringBuilder sb = new StringBuilder();
        sb.append("<!ENTITY ");
        sb.append(entityname);
        sb.append(" SYSTEM \"");
        sb.append(filename);
        sb.append("\">");
        sb.append(CR);
        return sb.toString();
    }

    private String createEntityFileName(String prefix, String modelId) {
        return this.createEntityFileName(prefix, modelId, "/");
    }

    private String createEntityFileName(String prefix, String modelId, String sep) {
        StringBuilder sb = new StringBuilder();
        sb.append("appschema");
        sb.append(sep);
        sb.append(prefix);
        if (StringUtils.isNotBlank((CharSequence)modelId)) {
            sb.append("-");
            sb.append(modelId);
        }
        sb.append(".xls.xml");
        return sb.toString();
    }

    private String createEntityCoreName(String prefix, String modelId) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append("-");
        sb.append(modelId);
        return sb.toString();
    }

    private String createEntityName(String prefix, String modelId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createEntityCoreName(prefix, modelId));
        sb.append(".xls");
        return sb.toString();
    }

    private void createPreparedContent(StringBuilder sb, String[] contents) {
        for (String s : contents) {
            sb.append(s);
            sb.append(CR);
        }
    }

    private void insertPreparedContent(StringBuilder sb, String[] contents) {
        StringBuilder tmp = new StringBuilder();
        for (String s : contents) {
            tmp.append(s);
            tmp.append(CR);
        }
        sb.insert(0, tmp.toString());
    }

    private String[] getContent1() {
        String[] content1 = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>"};
        return content1;
    }

    private String[] getContent2() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<!DOCTYPE project SYSTEM \"appschema.dtd\" [");
        list.add("<!ENTITY environment SYSTEM \"appschema/environment.xml\">");
        list.add("<!ENTITY manifest SYSTEM \"appschema/manifest.xml\">");
        list.add("<!ENTITY javascript SYSTEM \"appschema/javascript.xml\">");
        list.add("<!ENTITY acl SYSTEM \"appschema/acl.xml\">");
        list.add("<!ENTITY menubar SYSTEM \"appschema/menubar.xml\">");
        list.add("<!ENTITY jfcdomains SYSTEM \"appschema/jfcdomains.xml\">");
        list.add("<!ENTITY jfcmodels SYSTEM \"appschema/jfcmodels.xml\">");
        list.add("<!ENTITY filter SYSTEM \"appschema/filter.xml\">");
        list.add("<!ENTITY common SYSTEM \"appschema/common.xml\">");
        list.add("<!ENTITY common-jcategory SYSTEM \"appschema/common-jcategory.xml\">");
        list.add("<!ENTITY common-jpermission SYSTEM \"appschema/common-jpermission.xml\">");
        list.add("<!ENTITY common-jprincipal SYSTEM \"appschema/common-jprincipal.xml\">");
        Integer size = this.elementSizeMap.get("menulinkaction");
        if (size != null && size > 0) {
            list.add("<!ENTITY menulinkaction SYSTEM \"appschema/menulinkaction.xml\">");
        }
        if ((size = this.elementSizeMap.get("propertiesfile")) != null && size > 0) {
            list.add("<!ENTITY propertiesfile SYSTEM \"appschema/propertiesfile.xml\">");
        }
        if ((size = this.elementSizeMap.get("printlayout")) != null && size > 0) {
            list.add("<!ENTITY printlayout SYSTEM \"appschema/printlayout.xml\">");
        }
        if ((size = this.elementSizeMap.get("job")) != null && size > 0) {
            list.add("<!ENTITY job SYSTEM \"appschema/job.xml\">");
        }
        if ((size = this.elementSizeMap.get("keyevent")) != null && size > 0) {
            list.add("<!ENTITY keyevent SYSTEM \"appschema/keyevent.xml\">");
        }
        if ((size = this.elementSizeMap.get("wadgetlist")) != null && size > 0) {
            list.add("<!ENTITY wadgetlist SYSTEM \"appschema/wadgetlist.xml\">");
        }
        return list.toArray(new String[0]);
    }

    private String[] getContent3() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("  &environment;");
        list.add("  &manifest;");
        list.add("  &javascript;");
        list.add("  &acl;");
        list.add("  &menubar;");
        list.add("  &jfcdomains;");
        list.add("  &jfcmodels;");
        list.add("  &filter;");
        list.add("  &common;");
        list.add("  &common-jcategory;");
        list.add("  &common-jpermission;");
        list.add("  &common-jprincipal;");
        Integer size = this.elementSizeMap.get("menulinkaction");
        if (size != null && size > 0) {
            list.add("  &menulinkaction;");
        }
        if ((size = this.elementSizeMap.get("propertiesfile")) != null && size > 0) {
            list.add("  &propertiesfile;");
        }
        if ((size = this.elementSizeMap.get("keyevent")) != null && size > 0) {
            list.add("  &keyevent;");
        }
        return list.toArray(new String[0]);
    }

    private String[] getContent4() {
        ArrayList<String> list = new ArrayList<String>();
        Integer size = this.elementSizeMap.get("printlayout");
        if (size != null && size > 0) {
            list.add("  &printlayout;");
        }
        if ((size = this.elementSizeMap.get("job")) != null && size > 0) {
            list.add("  &job;");
        }
        if ((size = this.elementSizeMap.get("wadgetlist")) != null && size > 0) {
            list.add("  &wadgetlist;");
        }
        return list.toArray(new String[0]);
    }

    private boolean isReservedId(String modelId) {
        return "jpermission_m".equals(modelId) || "jprincipal".equals(modelId) || "jcategory".equals(modelId) || "hour_m".equals(modelId) || "minute_m".equals(modelId) || "movestep_m".equals(modelId) || "seq".equals(modelId) || "jfcreminder".equals(modelId);
    }

    public static void main(String[] args) {
        String inputfilename = "appschema.xml";
        String outputdirectory = "normalized_appschema";
        String encoding = "utf-8";
        PosixParser parse = new PosixParser();
        try {
            CommandLine line = parse.parse(options, args);
            for (Option option : line) {
                String oname = option.getOpt();
                if ("input".equals(oname)) {
                    inputfilename = option.getValue();
                    continue;
                }
                if ("output".equals(oname)) {
                    outputdirectory = line.getOptionValue("output");
                    continue;
                }
                if ("encoding".equals(oname)) {
                    encoding = line.getOptionValue("encoding");
                    continue;
                }
                if (!"help".equals(oname)) continue;
                NormalizeXMLFormatter.showHelpMessage();
                System.exit(1);
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        File file = new File(inputfilename);
        if (!file.exists()) {
            log.error("File not found, " + inputfilename);
            System.exit(1);
        }
        Project project = null;
        try {
            project = new Project(file);
        }
        catch (Exception e) {
            log.error("File read error, " + inputfilename + " " + e.getMessage());
        }
        NormalizeXMLFormatter formatter = new NormalizeXMLFormatter(inputfilename, encoding);
        formatter.setOutputDirectory(outputdirectory);
        formatter.format(project);
    }

    private static void showHelpMessage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Usage jp.jasminesoft.jfc.tools.xls2appschema.NormalizeXMLFormatter", options);
    }

    static {
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.withDescription((String)"input appschema.xml file. the default value is 'appschema.xml'.");
        OptionBuilder.hasArg();
        Option input = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.withDescription((String)"output appschema.xml directory. the default value is 'normalized_appschema'.");
        OptionBuilder.hasArg();
        Option output = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"encoding");
        OptionBuilder.withDescription((String)"input file encoding. the default value is 'utf-8'.");
        OptionBuilder.hasArg();
        Option encoding = OptionBuilder.create((String)"encoding");
        Option help = new Option("help", "print this message");
        options.addOption(input);
        options.addOption(output);
        options.addOption(encoding);
        options.addOption(help);
    }

    class FilterlistProcessor
    implements ElementProcessor {
        private List<Document> doclist = new ArrayList<Document>();

        FilterlistProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            if (ipc instanceof Filterlist) {
                Filterlist filterlist = (Filterlist)ipc;
                try {
                    this.doclist.add(filterlist.makeDocument());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("filter", this.doclist.toArray(new Document[0]));
        }
    }

    class CommonElementProcessor
    implements ElementProcessor {
        List<Document> doclist = new ArrayList<Document>();

        CommonElementProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            Presentation presentation;
            String filename;
            if (ipc instanceof Model) {
                Model model = (Model)ipc;
                if ("master".equals(model.getType()) && ("hour_m".equals(model.getId()) || "minute_m".equals(model.getId()) || "movestep_m".equals(model.getId())) || "seq".equals(model.getId()) || "jfcreminder".equals(model.getId()) || "reserved".equals(model.getType())) {
                    try {
                        this.doclist.add(model.makeDocument());
                    }
                    catch (ParserConfigurationException parserConfigurationException) {}
                }
            } else if (ipc instanceof Action) {
                Action action = (Action)ipc;
                String aid = action.getId();
                if ("noData".equals(aid) || "empty".equals(aid) || "showListLog".equals(aid) || "showListLogonUsers".equals(aid) || "releaseLogonUser".equals(aid) || "userPreference".equals(aid) || "showAboutApp".equals(aid) || "licenseUpdatorConfig".equals(aid) || "showAboutCluster".equals(aid) || "initLoader".equals(aid) || "maintenanceApp".equals(aid) || "analyticsLog".equals(aid) || "webapi".equals(aid)) {
                    try {
                        this.doclist.add(action.makeDocument());
                    }
                    catch (ParserConfigurationException parserConfigurationException) {}
                }
            } else if (ipc instanceof Presentation && ("logon".equals(filename = (presentation = (Presentation)ipc).getFilename()) || "logoff".equals(filename) || "menu".equals(filename) || "mobileMenu".equals(filename) || "mobileSafariMenu".equals(filename) || "featurePhoneMenu".equals(filename) || "noData".equals(filename) || "empty".equals(filename) || "showListLog".equals(filename) || "showListLogonUsers".equals(filename) || "releaseLogonUser".equals(filename) || "userPreference".equals(filename) || "showAboutApp".equals(filename) || "licenseUpdatorConfig".equals(filename) || "showAboutCluster".equals(filename) || "initLoader".equals(filename) || "maintenanceApp".equals(filename) || "analyticsLog".equals(filename) || "webapi".equals(filename))) {
                try {
                    this.doclist.add(presentation.makeDocument());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("common", this.doclist.toArray(new Document[0]));
        }
    }

    class JcategoryProcessor
    implements ElementProcessor {
        Document doc = null;

        JcategoryProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            Model model;
            if (ipc instanceof Model && "jcategory".equals((model = (Model)ipc).getId())) {
                try {
                    this.doc = model.makeDocument();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("common-jcategory", this.doc);
        }
    }

    class JpermissionProcessor
    implements ElementProcessor {
        Document doc = null;

        JpermissionProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            Model model;
            if (ipc instanceof Model && "jpermission_m".equals((model = (Model)ipc).getId())) {
                try {
                    this.doc = model.makeDocument();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("common-jpermission", this.doc);
        }
    }

    class JprincipalProcessor
    implements ElementProcessor {
        Document doc = null;

        JprincipalProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            Model model;
            if (ipc instanceof Model && "jprincipal".equals((model = (Model)ipc).getId())) {
                try {
                    this.doc = model.makeDocument();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("common-jprincipal", this.doc);
        }
    }

    class MenulinkactionProcessor
    implements ElementProcessor {
        List<Document> doclist = new ArrayList<Document>();

        MenulinkactionProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            if (ipc instanceof Menulinkaction) {
                Menulinkaction menulinkaction = (Menulinkaction)ipc;
                try {
                    this.doclist.add(menulinkaction.makeDocument());
                    NormalizeXMLFormatter.this.elementSizeMap.put("menulinkaction", this.doclist.size());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("menulinkaction", this.doclist.toArray(new Document[0]));
        }
    }

    class PropertiesfileProcessor
    implements ElementProcessor {
        List<Document> doclist = new ArrayList<Document>();

        PropertiesfileProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            if (ipc instanceof Propertiesfile) {
                Propertiesfile propertiesfile = (Propertiesfile)ipc;
                try {
                    this.doclist.add(propertiesfile.makeDocument());
                    NormalizeXMLFormatter.this.elementSizeMap.put("propertiesfile", this.doclist.size());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("propertiesfile", this.doclist.toArray(new Document[0]));
        }
    }

    class PrintlayoutProcessor
    implements ElementProcessor {
        List<Document> doclist = new ArrayList<Document>();

        PrintlayoutProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            if (ipc instanceof Printlayout) {
                Printlayout printlayout = (Printlayout)ipc;
                try {
                    this.doclist.add(printlayout.makeDocument());
                    NormalizeXMLFormatter.this.elementSizeMap.put("printlayout", this.doclist.size());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("printlayout", this.doclist.toArray(new Document[0]));
        }
    }

    class JobProcessor
    implements ElementProcessor {
        List<Document> doclist = new ArrayList<Document>();

        JobProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            if (ipc instanceof Job) {
                Job job = (Job)ipc;
                try {
                    this.doclist.add(job.makeDocument());
                    NormalizeXMLFormatter.this.elementSizeMap.put("job", this.doclist.size());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("job", this.doclist.toArray(new Document[0]));
        }
    }

    class KeyeventProcessor
    implements ElementProcessor {
        List<Document> doclist = new ArrayList<Document>();

        KeyeventProcessor() {
        }

        @Override
        public void process(IProjectChoice ipc) {
            if (ipc instanceof Keyevent) {
                Keyevent keyevent = (Keyevent)ipc;
                try {
                    this.doclist.add(keyevent.makeDocument());
                    NormalizeXMLFormatter.this.elementSizeMap.put("keyevent", this.doclist.size());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void save() {
            NormalizeXMLFormatter.this.saveDocument("keyevent", this.doclist.toArray(new Document[0]));
        }
    }

    class NormalModelOutputProcessor
    extends ModelOutputProcessor {
        NormalModelOutputProcessor() {
        }

        @Override
        void process(String modelId, Set<Object> targetSet) {
            this.output_element("model", "jp.jasminesoft.jfc.gen.appschema.Model", modelId, targetSet);
            this.output_element("action", "jp.jasminesoft.jfc.gen.appschema.Action", modelId, targetSet);
            this.output_element("presentation", "jp.jasminesoft.jfc.gen.appschema.Presentation", modelId, targetSet);
        }
    }

    abstract class ModelOutputProcessor {
        ModelOutputProcessor() {
        }

        abstract void process(String var1, Set<Object> var2);

        protected void output_element(String type, Set<Object> targetSet) {
            this.output_element(type, null, null, targetSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void output_element(String type, String classname, String modelId, Set<Object> targetSet) {
            if (targetSet == null || targetSet.size() == 0) {
                return;
            }
            try (PrintWriter writer = null;){
                String outputfilename_ = NormalizeXMLFormatter.this.createEntityFileName(type, modelId, File.separator);
                StringBuilder header = new StringBuilder();
                NormalizeXMLFormatter.this.createPreparedContent(header, NormalizeXMLFormatter.this.getContent1());
                header.append(CR);
                writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(NormalizeXMLFormatter.this.createOutputFilename(outputfilename_)), NormalizeXMLFormatter.this.encoding_)));
                writer.write(header.toString());
                SimpleXMLFormatter formatter = new SimpleXMLFormatter(writer);
                for (Object o : targetSet) {
                    if (classname != null && !o.getClass().getName().equals(classname)) continue;
                    IProjectChoice ipc = (IProjectChoice)o;
                    formatter.format(ipc.makeDocument());
                    writer.append(CR);
                }
            }
        }
    }

    class MasterModelOutputProcessor
    extends ModelOutputProcessor {
        MasterModelOutputProcessor() {
        }

        @Override
        void process(String modelId, Set<Object> targetSet) {
            this.output_element("master-" + modelId, targetSet);
        }
    }

    static interface ElementProcessor {
        public void process(IProjectChoice var1);

        public void save();
    }

    class CommonModelOutputProcessor
    extends ModelOutputProcessor {
        CommonModelOutputProcessor() {
        }

        @Override
        void process(String modelId, Set<Object> targetSet) {
            this.output_element("common-" + modelId, targetSet);
        }
    }
}

