/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Menu;
import jp.jasminesoft.jfc.gen.appschema.Menubar;
import jp.jasminesoft.jfc.gen.appschema.Menulinkaction;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang3.StringUtils;

public class RearrangeMenuId {
    private Project project;
    private Map<String, String> replaceIdMap;
    private static int count;

    public RearrangeMenuId(Project project) {
        this.project = project;
        this.replaceIdMap = new HashMap<String, String>();
    }

    public void process() {
        Menubar menubar = this.project.getMenubar();
        for (Menu menu : menubar.getMenu()) {
            this.replaceMenuId(menu);
        }
        for (Menu menu : this.project.getContent()) {
            Menulinkaction maction;
            String new_id;
            String menuref;
            if (menu instanceof Action) {
                Action action = (Action)menu;
                menuref = action.getMenuref();
                if (!StringUtils.isNotBlank((CharSequence)menuref) || !StringUtils.isNotBlank((CharSequence)(new_id = this.replaceIdMap.get(menuref)))) continue;
                action.setMenuref(new_id);
                continue;
            }
            if (!(menu instanceof Menulinkaction) || !StringUtils.isNotBlank((CharSequence)(menuref = (maction = (Menulinkaction)menu).getMenuref())) || !StringUtils.isNotBlank((CharSequence)(new_id = this.replaceIdMap.get(menuref)))) continue;
            maction.setMenuref(new_id);
        }
    }

    private void replaceMenuId(Menu menu) {
        String new_id = this.createProxyId();
        this.replaceIdMap.put(menu.getId(), new_id);
        menu.setId(new_id);
        Menu[] cmenu_ary = menu.getMenu();
        if (cmenu_ary != null) {
            for (Menu cmenu : cmenu_ary) {
                this.replaceMenuId(cmenu);
            }
        }
    }

    private String createProxyId() {
        return "menu" + count++;
    }

    public static void reset() {
        count = 1;
    }

    static {
        RearrangeMenuId.reset();
    }
}

