/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.csv2xml.CSVContentHandler;
import jp.jasminesoft.csv2xml.ReplaceCharacter;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefElementContainer;
import jp.jasminesoft.util.ResourceManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DefSheetHandler")
public class WagbyR6DefSheetHandler
implements CSVContentHandler {
    private static boolean debug = false;
    private ResourceManager rman = ResourceManager.getInstance((String)"x2aj");
    private boolean acceptFlag_;
    private int colcnt_;
    private int rowcnt_;
    private Set<String> targetSet_;
    private String filename_;
    private static final String DefaultConvertTableFilename = "xls2xml/conf/repchar.txt";
    private static final String DefaultConvertTableEncoding = "MS932";
    public ReplaceCharacter repl = new ReplaceCharacter();
    @Autowired(required=true)
    private ElementContainer container_;
    private static Map<String, ModelIdAndFilename> processedModelIdAndFilenameMap_ = new HashMap<String, ModelIdAndFilename>();

    public WagbyR6DefSheetHandler() {
        this.repl.setConfigFilename(DefaultConvertTableFilename);
        this.repl.setConfigFileEncoding(DefaultConvertTableEncoding);
    }

    private void init() {
        this.colcnt_ = 0;
        this.rowcnt_ = 0;
    }

    public void beginCSV(String filename) throws IOException {
        this.container_.init();
        this.targetSet_ = new HashSet<String>();
        if (filename != null && filename.length() > 0) {
            int index = filename.lastIndexOf(File.separator);
            this.filename_ = index > 0 ? filename.substring(index + 1) : filename;
        }
    }

    public void endCSV(String filename) throws IOException {
        for (String modelId : this.targetSet_) {
            String errmsg = null;
            errmsg = this.isContainsModelId(modelId);
            if (errmsg != null) {
                ModelIdAndFilename mf = processedModelIdAndFilenameMap_.get(this.convModelId(modelId));
                if (mf == null) {
                    mf = processedModelIdAndFilenameMap_.get(this.convModelIdWithoutSuffix(modelId));
                }
                if (mf == null) {
                    mf = processedModelIdAndFilenameMap_.get(this.convModelId(modelId) + "P");
                }
                if (mf == null) {
                    mf = processedModelIdAndFilenameMap_.get(this.convModelId(modelId) + "C");
                }
                if (mf == null) {
                    mf = processedModelIdAndFilenameMap_.get(this.convModelId(modelId) + "CP");
                }
                if (mf == null) {
                    mf = processedModelIdAndFilenameMap_.get(this.convModelId(modelId) + "L");
                }
                if (mf == null) {
                    mf = processedModelIdAndFilenameMap_.get(this.convModelId(modelId) + "LP");
                }
                if (mf == null) {
                    ((WagbyR6DefElementContainer)this.container_).getMessageListener().error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefSheetHandler.endCSV", new Object[]{modelId}));
                    continue;
                }
                ((WagbyR6DefElementContainer)this.container_).getMessageListener().error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefSheetHandler.endCSV.2", new Object[]{mf.modelId, mf.filename, errmsg}));
                continue;
            }
            processedModelIdAndFilenameMap_.put(this.convModelId(modelId), new ModelIdAndFilename(modelId, this.filename_));
        }
        this.container_.postProcess(this.targetSet_, this.filename_);
        this.targetSet_ = null;
    }

    private final String convModelId(String id) {
        return Utils.getUniqueName(id);
    }

    private final String convModelIdWithoutSuffix(String id) {
        String _id = this.convModelId(id);
        if (_id.endsWith("CP") || _id.endsWith("LP")) {
            _id = _id.substring(0, _id.length() - 2);
        } else if (_id.endsWith("P") || _id.endsWith("C") || _id.endsWith("L")) {
            _id = _id.substring(0, _id.length() - 1);
        }
        return _id;
    }

    private final String isContainsModelId(String modelId) {
        String errmsg = null;
        String _modelId = this.convModelId(modelId);
        if (processedModelIdAndFilenameMap_.containsKey(_modelId)) {
            errmsg = this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefSheetHandler.isContainsModelId");
        } else if (processedModelIdAndFilenameMap_.containsKey(_modelId + "P") || processedModelIdAndFilenameMap_.containsKey(_modelId + "C") || processedModelIdAndFilenameMap_.containsKey(_modelId + "CP") || processedModelIdAndFilenameMap_.containsKey(_modelId + "L") || processedModelIdAndFilenameMap_.containsKey(_modelId + "LP")) {
            errmsg = this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefSheetHandler.isContainsModelId.2");
        }
        return errmsg;
    }

    public void beginSheet(int sheetnum, String name) throws IOException {
        this.acceptFlag_ = false;
        if (name.charAt(0) != '-' && name.charAt(0) != '+') {
            this.acceptFlag_ = true;
        }
        if (!this.acceptFlag_) {
            return;
        }
        this.init();
        this.container_.createRowMap();
    }

    public void endSheet(int sheetnum, String name) throws IOException {
        if (!this.acceptFlag_) {
            return;
        }
        String modelId = this.container_.createRelationMap();
        if (StringUtils.isNotBlank((CharSequence)modelId)) {
            this.targetSet_.add(modelId);
        }
    }

    public void beginRow(int rowcnt) throws IOException {
        if (!this.acceptFlag_) {
            return;
        }
        this.rowcnt_ = rowcnt;
    }

    public void endRow(int rowcnt) throws IOException {
    }

    public void beginColumn(int colcnt) throws IOException {
        if (!this.acceptFlag_) {
            return;
        }
        this.colcnt_ = colcnt;
    }

    public void endColumn(int colcnt) throws IOException {
    }

    public void characters(char[] ch, int start, int length) throws IOException {
        String s;
        if (!this.acceptFlag_) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : ch) {
            sb.append(c);
        }
        String content = s = this.repl.convertString(sb.toString());
        if (debug) {
            System.out.println("(" + this.colcnt_ + "," + this.rowcnt_ + ") " + content);
        }
        this.container_.setElement(content, this.colcnt_, this.rowcnt_);
    }

    public static void reset() {
        processedModelIdAndFilenameMap_ = new HashMap<String, ModelIdAndFilename>();
    }

    private static class ModelIdAndFilename {
        String modelId;
        String filename;

        ModelIdAndFilename(String modelId, String filename) {
            this.modelId = modelId;
            this.filename = filename;
        }

        public String toString() {
            return this.modelId + ":" + this.filename;
        }
    }
}

