/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.model.mailmessage.Mailmessage;
import jp.jasminesoft.jfc.tools.xls2appschema.MailmessageContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="mailmessageContainer")
public class WagbyR6MailmessageContainer
implements MailmessageContainer {
    protected Logger log = LogManager.getLogger(WagbyR6MailmessageContainer.class);
    private static ResourceManager rman = ResourceManager.getInstance((String)"x2aj");
    private Map<String, Map<String, Map<String, Object>>> rootMap = new HashMap<String, Map<String, Map<String, Object>>>();
    private Map<String, Object> targetMap;
    private String targetModelId;
    private String key;
    private String value;
    private String pre_value;
    public static final String SAVEDIR = "webpage" + File.separator + "WEB-INF" + File.separator + "mailmessage" + File.separator;

    @Override
    public void setElement(String content, int colcnt_, int rowcnt_) {
        if (this.targetMap == null) {
            return;
        }
        if (colcnt_ == 1) {
            if (this.key != null && this.value != null) {
                Object o = this.targetMap.get(this.key);
                if ((this.key.endsWith("@to") || this.key.endsWith("@cc") || this.key.endsWith("@bcc")) && ("toend".equals(this.value) || "ccend".equals(this.value) || "bccend".equals(this.value) || StringUtils.isBlank((CharSequence)this.value))) {
                    this.value = this.pre_value;
                }
                if (o == null) {
                    this.targetMap.put(this.key, this.value);
                } else if (o instanceof String) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add((String)o);
                    this.targetMap.put(this.key, list);
                } else if (o instanceof List) {
                    List list = (List)o;
                    list.add(this.value);
                }
            }
            this.key = content;
            this.value = null;
            this.pre_value = null;
        } else {
            this.pre_value = this.value;
            this.value = content;
        }
    }

    @Override
    public void setName(String name) {
        Map<String, Object> typeMap;
        this.targetMap = null;
        String type = StringUtil.lastToken((String)name, (String)"_");
        if (StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        if (name.length() - type.length() - 1 <= 0) {
            return;
        }
        this.targetModelId = name.substring(0, name.length() - type.length() - 1);
        Map<String, Map<String, Object>> modelMap = this.rootMap.get(this.targetModelId);
        if (modelMap == null) {
            modelMap = new HashMap<String, Map<String, Object>>();
            this.rootMap.put(this.targetModelId, modelMap);
        }
        if ((typeMap = modelMap.get(type)) == null) {
            typeMap = new HashMap<String, Object>();
            modelMap.put(type, typeMap);
        }
        this.targetMap = typeMap;
    }

    @Override
    public void postProcess() {
        Map<String, Map<String, Object>> modelMap = this.rootMap.get(this.targetModelId);
        if (modelMap == null) {
            return;
        }
        for (String type : modelMap.keySet()) {
            Map<String, Object> targetMap = modelMap.get(type);
            this.outputProcess(this.targetModelId, type, targetMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputProcess(String modelId, String type, Map<String, Object> targetMap) {
        String body_;
        Object bcc_;
        String from_;
        String subject_;
        String auth_password_;
        String auth_user_;
        String auth_;
        String protocol_;
        String mailhost_;
        String attachmentMaxSize_;
        String base = "model/sendmail/" + type + "/";
        Mailmessage message = new Mailmessage();
        message.setMid(modelId + "_" + type + ".xml");
        if (Utils.isSelectedValue((String)targetMap.get(base + "@individualSend"))) {
            message.setIndividualSend(true);
        }
        if (StringUtils.isNotBlank((CharSequence)(attachmentMaxSize_ = (String)targetMap.get(base + "@attachmentMaxSize")))) {
            message.setAttachmentMaxSize(Integer.parseInt(attachmentMaxSize_));
        }
        if (StringUtils.isNotBlank((CharSequence)(mailhost_ = (String)targetMap.get(base + "@mailhost")))) {
            message.setMailhost(mailhost_);
        }
        if (StringUtils.isNotBlank((CharSequence)(protocol_ = (String)targetMap.get(base + "@protocol")))) {
            message.setProtocol(BJob.SendMailProtocolMap.get(protocol_.toLowerCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)(auth_ = (String)targetMap.get(base + "@auth")))) {
            message.setAuth(Utils.isSelectedValue(auth_));
        }
        if (StringUtils.isNotBlank((CharSequence)(auth_user_ = (String)targetMap.get(base + "@auth_user")))) {
            message.setAuthUser(auth_user_);
        }
        if (StringUtils.isNotBlank((CharSequence)(auth_password_ = (String)targetMap.get(base + "@auth_password")))) {
            message.setAuthPassword(auth_password_);
        }
        if (StringUtils.isNotBlank((CharSequence)(subject_ = (String)targetMap.get(base + "@subject")))) {
            message.setSubject(subject_);
        }
        if (!StringUtils.isNotBlank((CharSequence)(from_ = (String)targetMap.get(base + "@from")))) {
            this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6MailmessageContainer.outputProcess.from", new Object[]{modelId, type}));
            return;
        }
        message.setFrom(from_);
        Object to_ = targetMap.get(base + "@to");
        boolean successFlag_to_ = false;
        if (to_ != null) {
            List list;
            if (to_ instanceof String) {
                if (StringUtils.isNotBlank((CharSequence)((String)to_))) {
                    message.setTo((String)to_);
                    successFlag_to_ = true;
                }
            } else if (to_ instanceof List && (list = (List)to_).size() > 0) {
                for (Object s : list) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    message.addTo((String)s);
                    successFlag_to_ = true;
                }
            }
        }
        if (!successFlag_to_) {
            this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6MailmessageContainer.outputProcess.to", new Object[]{modelId, type}));
            return;
        }
        Object cc_ = targetMap.get(base + "@cc");
        if (cc_ != null) {
            List list;
            if (cc_ instanceof String) {
                if (StringUtils.isNotBlank((CharSequence)((String)cc_))) {
                    message.setCc((String)cc_);
                }
            } else if (cc_ instanceof List && (list = (List)cc_).size() > 0) {
                for (Object s : list) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    message.addCc((String)s);
                }
            }
        }
        if ((bcc_ = targetMap.get(base + "@bcc")) != null) {
            List list;
            if (bcc_ instanceof String) {
                if (StringUtils.isNotBlank((CharSequence)((String)bcc_))) {
                    message.setCc((String)bcc_);
                }
            } else if (bcc_ instanceof List && (list = (List)bcc_).size() > 0) {
                for (String s : list) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    message.addBcc(s);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(body_ = (String)targetMap.get(base + "@body")))) {
            message.setBody(body_);
        }
        FileOutputStream ostream = null;
        PrintWriter writer = null;
        try {
            ostream = new FileOutputStream(SAVEDIR + message.getMid());
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)ostream, "UTF-8"));
            writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.print(message.toString());
            writer.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                writer.close();
                ostream = null;
            }
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

