/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.IOException;
import jp.jasminesoft.csv2xml.CSVContentHandler;
import jp.jasminesoft.csv2xml.ReplaceCharacter;
import jp.jasminesoft.jfc.tools.xls2appschema.ProjectFilterContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ProjectFilterSheetHandler")
public class WagbyR6ProjectFilterSheetHandler
implements CSVContentHandler {
    private static boolean debug = false;
    private boolean acceptFlag_;
    private int colcnt_;
    private int rowcnt_;
    private static final String DefaultConvertTableFilename = "template/repchar.txt";
    private static final String DefaultConvertTableEncoding = "MS932";
    public ReplaceCharacter repl = new ReplaceCharacter();
    @Autowired(required=true)
    private ProjectFilterContainer container_;

    public WagbyR6ProjectFilterSheetHandler() {
        this.repl.setConfigFilename(DefaultConvertTableFilename);
        this.repl.setConfigFileEncoding(DefaultConvertTableEncoding);
    }

    public void setProjectFilterContainer(ProjectFilterContainer container) {
        this.container_ = container;
    }

    private void init() {
        this.colcnt_ = 0;
        this.rowcnt_ = 0;
    }

    public void beginCSV(String filename) throws IOException {
        this.container_.init();
    }

    public void endCSV(String filename) throws IOException {
        this.container_.postProcess();
    }

    public void beginSheet(int sheetnum, String name) throws IOException {
        this.acceptFlag_ = false;
        if (name.charAt(0) != '-' && name.charAt(0) != '+') {
            this.acceptFlag_ = true;
        }
        if (!this.acceptFlag_) {
            return;
        }
        this.container_.createRowMap();
    }

    public void endSheet(int sheetnum, String name) throws IOException {
        if (!this.acceptFlag_) {
            return;
        }
        this.container_.process();
    }

    public void beginRow(int rowcnt) throws IOException {
        if (!this.acceptFlag_) {
            return;
        }
        this.rowcnt_ = rowcnt;
    }

    public void endRow(int rowcnt) throws IOException {
    }

    public void beginColumn(int colcnt) throws IOException {
        if (!this.acceptFlag_) {
            return;
        }
        this.colcnt_ = colcnt;
    }

    public void endColumn(int colcnt) throws IOException {
    }

    public void characters(char[] ch, int start, int length) throws IOException {
        if (!this.acceptFlag_) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : ch) {
            sb.append(c);
        }
        String s = this.repl.convertString(sb.toString());
        String content = s.trim();
        if (debug) {
            System.out.println("(" + this.colcnt_ + "," + this.rowcnt_ + ") " + content);
        }
        this.container_.setElement(content, this.colcnt_, this.rowcnt_);
    }
}

