/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Datalist;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.IDataitemChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relatedkey;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class BActionElement_datalist
extends BActionElement {
    private Set<String> processTypeSet_ = new HashSet<String>();

    public BActionElement_datalist() {
        this.init();
    }

    public abstract void init();

    protected void addProcessType(String processType) {
        this.processTypeSet_.add(processType);
    }

    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project) {
        this.create(modelId, actionType, action, project, -1);
    }

    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project, int num) {
        Dataitem[] rev_dataitems;
        Dataitem[] dataitem_ary;
        Dataitem dataitem;
        Datalist datalist = new Datalist();
        if (this.processTypeSet_.contains("show")) {
            dataitem = this.createDataitem_me(modelId);
            datalist.addDataitem(dataitem);
        }
        if (this.processTypeSet_.contains("fkey") && (dataitem_ary = this.createDataitem_foreignKey(modelId, action, project)) != null && dataitem_ary.length > 0) {
            datalist.addDataitem(dataitem_ary);
        }
        if (this.processTypeSet_.contains("list")) {
            dataitem = this.createDataitem_showlist(modelId, actionType);
            datalist.addDataitem(dataitem);
        }
        if (this.processTypeSet_.contains("updateList") && (dataitem_ary = this.createDataitem_updateList(modelId, action, project)) != null && dataitem_ary.length > 0) {
            if (action.getConfirm()) {
                String screenType = null;
                if (actionType == ActionType.insert) {
                    screenType = rman.getValue("r.action.screentype.insert");
                } else if (actionType == ActionType.update) {
                    screenType = rman.getValue("r.action.screentype.update");
                } else if (actionType == ActionType.copy) {
                    screenType = rman.getValue("r.action.screentype.copy");
                }
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_datalist.create", new Object[]{modelId, screenType}));
            }
            datalist.addDataitem(dataitem_ary);
        }
        if (this.processTypeSet_.contains("total") && (dataitem_ary = this.createDataitem_total(modelId, num)) != null && dataitem_ary.length > 0) {
            datalist.addDataitem(dataitem_ary);
        }
        if (this.processTypeSet_.contains("reverse") && (rev_dataitems = this.createDataitem_revlink(modelId, project)) != null) {
            for (Dataitem item : rev_dataitems) {
                datalist.addDataitem(item);
            }
        }
        HashSet<String> processedIdSet = new HashSet<String>();
        for (Dataitem dataitem2 : datalist.getDataitem()) {
            String idref = dataitem2.getIdref();
            if (processedIdSet.contains(idref) && dataitem2.getType().equals("reverse")) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_datalist.duplicatecheck", new Object[]{modelId, idref}));
            }
            processedIdSet.add(idref);
        }
        action.addContent((IActionChoice)datalist);
    }

    private Dataitem[] createDataitem_revlink(String modelId, Project project) {
        LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>();
        Object[] modelIds = this.getElementContainer().getAllStoreModelId();
        Arrays.sort(modelIds);
        for (Object target : modelIds) {
            String[] names;
            if (Utils.isNoOutputModel((String)target, this.con_) || (names = this.con_.getModelitemNames((String)target)) == null || names.length == 0) continue;
            for (String name : names) {
                String relation_idref;
                boolean isRevlink = Utils.isSelectedValue(this.con_.getModelitemValue((String)target, name, "model/modelitem/relation/@revlink"));
                if (!isRevlink) continue;
                String roleid_type = this.con_.getModelitemValue((String)target, name, "model/modelitem/relation_storeref/@roleid");
                if (!ropt.getValue("OPTION_model_modelitem_relation_storeref_roleid_1_value").equals(roleid_type) || !StringUtils.isNotBlank((CharSequence)(relation_idref = this.con_.getModelitemValue((String)target, name, "model/modelitem/relation/@idref"))) || !relation_idref.equals(modelId)) continue;
                if (map.keySet().contains(target)) {
                    this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_datalist.createDataitem_revlink", new Object[]{target, name, modelId}));
                    continue;
                }
                if (Utils.isShowListDisplayTypeGrid((String)target, this.con_)) {
                    this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_datalist.createDataitem_revlink_nogridsupport", new Object[]{target, name, modelId}));
                    continue;
                }
                map.put(target, name);
            }
        }
        ArrayList<Dataitem> list = null;
        if (map.size() > 0) {
            list = new ArrayList<Dataitem>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                Dataitem dataitem = new Dataitem();
                dataitem.setIdref((String)entry.getKey() + "_lp");
                dataitem.setType("reverse");
                Relatedkey relatedkey = new Relatedkey();
                relatedkey.setContent((String)entry.getValue());
                dataitem.addContent((IDataitemChoice)relatedkey);
                list.add(dataitem);
            }
        }
        if (list == null) {
            return null;
        }
        return list.toArray(new Dataitem[list.size()]);
    }

    public Dataitem createDataitem_me(String modelId) {
        Dataitem dataitem = new Dataitem();
        dataitem.setIdref(modelId + "_p");
        return dataitem;
    }

    public Dataitem[] createDataitem_foreignKey(String modelId, Action action, Project project) {
        Model[] fmodels = Utils.getForeignkeyModel(modelId, project);
        if (fmodels == null || fmodels.length == 0) {
            return null;
        }
        ArrayList<Dataitem> dlist = new ArrayList<Dataitem>();
        for (Model fmodel : fmodels) {
            String fmodelId = fmodel.getId();
            ForeignKey[] fkeys = AppSchemaUtil.getForeignKey((Model)fmodel);
            Dataitem dataitem = null;
            for (ForeignKey fkey : fkeys) {
                if (!modelId.equals(fkey.getIdref())) continue;
                if (dataitem == null) {
                    String _value;
                    dataitem = new Dataitem();
                    dataitem.setType("array2list");
                    dataitem.setIdref(fmodel.getId() + "_lp");
                    int _maxresult = this.getFkeyDataitemMaxResult(modelId, fmodel);
                    if (_maxresult > 0) {
                        dataitem.setMaxresult(_maxresult);
                    }
                    if (this.con_.existsKeyInModel(fmodelId, "model/foreignkey/display/@condition") && StringUtils.isEmpty((CharSequence)(_value = this.con_.getModelValue(fmodelId, "model/foreignkey/display/@condition")))) {
                        dataitem.setShow(false);
                    }
                    if (!Utils.isSelectedValue(this.con_.getModelValue(fmodelId, "model/foreignkey/display/@includingImplicit"))) {
                        dataitem.setIncludingImplicit(false);
                    }
                }
                Relatedkey relatedkey = new Relatedkey();
                relatedkey.setContent(AppSchemaUtil.getForeignKeyTargetItemName((ForeignKey)fkey));
                dataitem.addContent((IDataitemChoice)relatedkey);
            }
            if (dataitem == null) continue;
            dlist.add(dataitem);
        }
        return dlist.toArray(new Dataitem[0]);
    }

    private int getFkeyDataitemMaxResult(String modelId, Model fmodel) {
        boolean paging;
        int _maxresult = -1;
        String maxresult = this.con_.getModelValue(fmodel.getId(), "action[@type=show]/datalist/dataitem/@maxresult");
        if (StringUtils.isNotBlank((CharSequence)maxresult)) {
            try {
                _maxresult = Integer.parseInt(maxresult);
            }
            catch (NumberFormatException e) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_datalist.createDataitem_foreignKey", new Object[]{modelId, maxresult}));
            }
        }
        if (_maxresult <= 0 && (paging = Utils.isSelectedValue(this.con_.getModelValue(fmodel.getId(), "presentation/displaymodel_updatelist/displaypageindex[@type=fkey]")))) {
            String option_str = this.con_.getModelValue(fmodel.getId(), "model/@actionShowListPageOption");
            _maxresult = StringUtils.isBlank((CharSequence)option_str) ? 20 : (option_str.indexOf(",") < 0 ? NumberUtils.toInt((String)option_str) : NumberUtils.toInt((String)option_str.split(",")[0]));
        }
        return _maxresult;
    }

    public Dataitem createDataitem_showlist(String modelId, ActionType actionType) {
        Dataitem dataitem = new Dataitem();
        dataitem.setType("list");
        if (actionType == ActionType.showList || actionType == ActionType.reportList || actionType == ActionType.searchList || actionType == ActionType.searchListForRefgroup) {
            dataitem.setIdref(modelId + "_lp");
        } else if (actionType == ActionType.updateList) {
            dataitem.setIdref(modelId + "_ulp");
        }
        return dataitem;
    }

    public Dataitem[] createDataitem_updateList(String modelId, Action action, Project project) {
        Model[] fmodels = Utils.getUpdatelistForeignkeyModel(modelId, project, this.con_);
        if (fmodels == null || fmodels.length == 0) {
            return null;
        }
        Model smodel = AppSchemaUtil.getModel((Project)project, (String)modelId);
        if (smodel == null) {
            return null;
        }
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey((Model)smodel);
        ArrayList<Dataitem> dlist = new ArrayList<Dataitem>();
        for (Model fmodel : fmodels) {
            String defaultSize;
            ForeignKey[] fkeys;
            String fid = fmodel.getId();
            Dataitem dataitem = new Dataitem();
            String v = this.con_.getModelValue(fid, "presentation[@idref=parent]/layout/panel/@conditionForCopy");
            if ("copy".equals(action.getType()) && Boolean.parseBoolean(v)) {
                dataitem.setType("array2list");
                dataitem.setIdref(fid + "_lp");
            } else {
                dataitem.setType("updateList");
                dataitem.setIdref(fid + "_ulp");
                dataitem.setActionid("updateList" + SourceGenerator.capFirst((String)fid));
                dataitem.setActionheader("UserDefined_" + fid + ":");
            }
            for (ForeignKey fkey : fkeys = AppSchemaUtil.getForeignKey((Model)fmodel)) {
                for (PrimaryKey pkey : pkeys) {
                    if (!pkey.getName().equals(AppSchemaUtil.getForeignKeyTargetItemName((ForeignKey)fkey))) continue;
                    Relatedkey relatedkey = new Relatedkey();
                    relatedkey.setContent(fkey.getName());
                    dataitem.addContent((IDataitemChoice)relatedkey);
                }
            }
            if ("insert".equals(action.getType()) && StringUtils.isNotBlank((CharSequence)(defaultSize = this.con_.getModelValue(fid, "action/updatelist/dataitem/@defaultSize")))) {
                dataitem.setDefaultSize(defaultSize);
            }
            dlist.add(dataitem);
        }
        return dlist.toArray(new Dataitem[0]);
    }

    public Dataitem[] createDataitem_total(String modelId, int num) {
        String multipledisplaymodelForTotalviewValue;
        ArrayList<Dataitem> dlist = new ArrayList<Dataitem>();
        Object multipledisplaymodelForTotalviewKey = "presentation/multipledisplaymodelForTotalview";
        if (num != -1 && num > 1) {
            multipledisplaymodelForTotalviewKey = (String)multipledisplaymodelForTotalviewKey + num;
        }
        if (StringUtils.isNotBlank((CharSequence)(multipledisplaymodelForTotalviewValue = this.con_.getModelValue(modelId, (String)multipledisplaymodelForTotalviewKey)))) {
            String[] tokens = multipledisplaymodelForTotalviewValue.split(",");
            TreeSet<Integer> numSet = new TreeSet<Integer>();
            numSet.add(num);
            for (String token : tokens) {
                try {
                    int onum = Integer.parseInt(token);
                    if (onum < 1 || onum > 10) {
                        // empty if block
                    }
                    numSet.add(onum);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (Integer numtarget : numSet) {
                dlist.add(this.createDataitem_total0(modelId, numtarget));
            }
        } else {
            dlist.add(this.createDataitem_total0(modelId, num));
        }
        return dlist.toArray(new Dataitem[0]);
    }

    private Dataitem createDataitem_total0(String modelId, int num) {
        Dataitem dataitem = new Dataitem();
        dataitem.setType("list");
        StringBuilder sb = new StringBuilder();
        sb.append(modelId);
        if (num != 1) {
            sb.append("T");
            sb.append(num);
        }
        sb.append("_tp");
        dataitem.setIdref(sb.toString());
        return dataitem;
    }
}

