/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.action;

import java.util.List;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.MessageQueue;
import jp.jasminesoft.jfc.gen.appschema.Messagejob;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="messagejob")
public class BActionElement_messagejob
extends BActionElement {
    protected Logger log = LogManager.getLogger(BActionElement_messagejob.class);

    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project) {
        String jobname = StringUtil.capFirst((String)action.getId()) + "Job";
        if (actionType.equals((Object)ActionType.download)) {
            if (BJob.isUseDownloadJob(this.con_, modelId) && BActionElement_messagejob.isEnable(this.con_, modelId, actionType)) {
                this.addMessagejob(modelId, actionType, action, project, jobname);
            }
        } else if (actionType.equals((Object)ActionType.uploadUpdate)) {
            if (BActionElement_messagejob.isEnableUploadUpdate(this.con_, modelId, actionType)) {
                this.addMessagejob(modelId, actionType, action, project, jobname);
            }
        } else if (actionType.equals((Object)ActionType.reportList)) {
            if (BJob.isUseReportListJob(this.con_, modelId) && BActionElement_messagejob.isEnable(this.con_, modelId, actionType)) {
                this.addMessagejob(modelId, actionType, action, project, jobname);
            }
        } else if (actionType.equals((Object)ActionType.showList) && BActionElement_messagejob.isEnableReportListInShowList(this.con_, modelId)) {
            jobname = "ReportList" + StringUtil.capFirst((String)modelId) + "Job";
            this.addMessagejob(modelId, ActionType.reportList, action, project, jobname);
        }
    }

    public static boolean isEnableUploadUpdate(ElementContainer con_, String modelId, ActionType actionType) {
        if (BJob.isUseUploadUpdateJob(con_, modelId) && BActionElement_messagejob.isEnable(con_, modelId, actionType)) {
            return true;
        }
        return Utils.isAutoScaling(con_) || Utils.isMicroservice(con_);
    }

    public static boolean isEnableReportListInShowList(ElementContainer con_, String modelId) {
        String enableRepositoryKey = "action/reportListInShowList/messagejob/@enable";
        return BJob.isUseReportListJob(con_, modelId) && BActionElement_messagejob.isEnable(con_, modelId, "action/reportListInShowList/messagejob/@enable");
    }

    private static boolean isEnable(ElementContainer con_, String modelId, ActionType actionType) {
        String enableRepositoryKey = "action/" + actionType + "/messagejob/@enable";
        return BActionElement_messagejob.isEnable(con_, modelId, enableRepositoryKey);
    }

    private static boolean isEnable(ElementContainer con_, String modelId, String enableRepositoryKey) {
        return Utils.isSelectedValue(con_.getModelValue(modelId, enableRepositoryKey));
    }

    public void addMessagejob(String modelId, ActionType actionType, Action action, Project project, String jobname) {
        String repositoryKeyHeader = "action/" + actionType + "/messagejob";
        String exchange = this.con_.getModelValue(modelId, repositoryKeyHeader + "/@exchange");
        String routingKey = this.con_.getModelValue(modelId, repositoryKeyHeader + "/@routingKey");
        routingKey = this.getRoutingKey(actionType, action, project, routingKey);
        Messagejob messagejob = new Messagejob();
        if (StringUtils.isNotBlank((CharSequence)exchange)) {
            messagejob.setExchange(exchange);
        }
        if (StringUtils.isNotBlank((CharSequence)routingKey)) {
            messagejob.setRoutingKey(routingKey);
        }
        messagejob.setJobname(jobname);
        action.addContent((IActionChoice)messagejob);
    }

    private String getRoutingKey(ActionType actionType, Action action, Project project, String routingKey) {
        int idx;
        if (routingKey != null && routingKey.equals("null")) {
            routingKey = null;
        }
        List messageQueues = AppSchemaUtil.getMessageQueue((Environment)project.getEnvironment());
        boolean isRabbitMQ = false;
        boolean isActiveMQ = false;
        boolean isEmpty = true;
        for (MessageQueue messageQueue : messageQueues) {
            if (messageQueue.getType().equals("RabbitMQ")) {
                isRabbitMQ = true;
                isEmpty = false;
                continue;
            }
            if (!messageQueue.getType().equals("ActiveMQ")) continue;
            isActiveMQ = true;
            isEmpty = false;
        }
        if (isEmpty) {
            Object[] o = new Object[]{action.getIdref(), action.getDescription()};
            this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_messagejob.notenabled", o));
            return null;
        }
        String type = null;
        Object rtkey = routingKey;
        if (routingKey != null && (idx = routingKey.indexOf(":")) > 0) {
            type = routingKey.substring(0, idx);
            rtkey = routingKey.length() > idx + 1 ? routingKey.substring(idx + 1) : null;
        }
        if (StringUtils.isNotBlank(type)) {
            if (type.equalsIgnoreCase("RabbitMQ")) {
                if (!isRabbitMQ) {
                    Object[] o = new Object[]{action.getIdref(), action.getDescription(), type};
                    this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_messagejob.send_queue_name.notenabledtype", o));
                }
            } else if (type.equalsIgnoreCase("ActiveMQ")) {
                if (!isActiveMQ) {
                    Object[] o = new Object[]{action.getIdref(), action.getDescription(), type};
                    this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_messagejob.send_queue_name.notenabledtype", o));
                }
            } else if (!type.equalsIgnoreCase("default")) {
                Object[] o = new Object[]{action.getIdref(), action.getDescription(), type};
                this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_messagejob.send_queue_name.nothingtype", o));
            }
        }
        if (actionType.equals((Object)ActionType.uploadUpdate) && StringUtils.isBlank((CharSequence)rtkey)) {
            rtkey = "wagbyUploadUpdateJobQueue";
            if (Utils.isMicroservice(this.con_)) {
                rtkey = (String)rtkey + "_" + Utils.getBuildDomain(this.con_);
            }
            if (StringUtils.isNotBlank((CharSequence)type)) {
                return type + ":" + (String)rtkey;
            }
            return rtkey;
        }
        return routingKey;
    }
}

