/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.action;

import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.Print;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_print_info;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BActionElement_print
extends BActionElement {
    private static final String judgeKey = "printlayout/filename";
    private static final String footer2 = "_2";
    private static final String footer3 = "_3";

    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project) {
        TreeMap<Integer, BActionElement_print_info> map = new TreeMap<Integer, BActionElement_print_info>();
        for (String element : this.con_.getKeysByModelAndKeyPrefix(modelId, judgeKey)) {
            if (element.contains("_")) continue;
            Integer fileNumber = this.getFileNumber(element);
            BActionElement_print_info pinfo = (BActionElement_print_info)map.get(fileNumber);
            if (pinfo == null) {
                pinfo = new BActionElement_print_info();
                map.put(fileNumber, pinfo);
            }
            pinfo.filename = Utils.getPrintlayoutTemplateFileName(Utils.getPrintlayoutFileName(modelId, element, this.con_));
            pinfo.label = Utils.getPrintlayoutLabel(modelId, element, this.con_);
            pinfo.type = Utils.getPrintlayoutType(modelId, element, this.con_);
            pinfo.library = Utils.getPrintlayoutLibraryType(modelId, element, this.con_);
            pinfo.filetype = Utils.getPrintlayoutFileType(modelId, element, this.con_);
            String displayName = Utils.getPrintlayoutDisplayname(modelId, element, this.con_);
            if (!StringUtils.isNotBlank((CharSequence)displayName) || !displayName.contains("JDBC")) continue;
            pinfo.datasource = "jdbc";
        }
        this.create0(modelId, actionType, action, project, map);
    }

    private Integer getFileNumber(String element) {
        Integer num;
        assert (element != null && element.startsWith(judgeKey));
        String num_part = element.substring(judgeKey.length());
        if (num_part.endsWith(footer2) || num_part.endsWith(footer3)) {
            num_part = num_part.substring(0, num_part.length() - 2);
        }
        try {
            num = Integer.valueOf(num_part);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return num;
    }

    protected abstract void create0(String var1, ActionType var2, Action var3, Project var4, Map<Integer, BActionElement_print_info> var5);

    protected void create0(String modelId, ActionType actionType, Action action, Project project, Map<Integer, BActionElement_print_info> map, String type) {
        for (BActionElement_print_info pinfo : map.values()) {
            if (!type.equals(pinfo.type) || !pinfo.isValid()) continue;
            Print print = this.createPrint(modelId, pinfo);
            if (!this.isExist(print, action)) {
                action.addContent((IActionChoice)print);
                continue;
            }
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_print.duplicate", new Object[]{modelId, print.getIdref()}));
        }
    }

    protected Print createPrint(String modelId, BActionElement_print_info pinfo) {
        Print print = new Print();
        StringBuilder sb = new StringBuilder();
        sb.append("Print");
        sb.append(SourceGenerator.capFirst((String)modelId));
        sb.append("_");
        if (!"excel".equals(pinfo.filetype)) {
            sb.append(pinfo.filetype);
            sb.append("_");
        }
        sb.append(pinfo.filename);
        print.setAction(sb.toString());
        String id = Utils.getPrintLayoutId(modelId, pinfo.filename, pinfo.type, pinfo.filetype);
        print.setIdref(id);
        return print;
    }

    protected boolean isExist(Print print, Action action) {
        boolean ret = false;
        Object[] o_prints = AppSchemaUtil.getPrint((Action)action);
        if (ArrayUtils.isNotEmpty((Object[])o_prints)) {
            for (Object o_print : o_prints) {
                if (!o_print.getAction().equals(print.getAction()) || !o_print.getIdref().equals(print.getIdref())) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }
}

