/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.action;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Script;
import jp.jasminesoft.jfc.gen.appschema.Transaction;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="transaction")
public class BActionElement_transaction
extends BActionElement {
    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project) {
        this.create(modelId, actionType, action, project, -1);
    }

    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project, int num) {
        Model smodel = AppSchemaUtil.getModel((Project)project, (String)action.getIdref());
        String[] mitemNames = this.con_.getModelitemNames(modelId);
        ForeignKey[] fkeys = AppSchemaUtil.getForeignKey((Model)smodel);
        ForeignKey targetfkey = null;
        for (String mitemName : mitemNames) {
            Modelitem s_mitem;
            String key = this.createTargetKey(actionType);
            boolean isTransaction = Utils.isSelectedValue(this.con_.getModelitemValue(modelId, mitemName, key));
            if (!isTransaction || (s_mitem = AppSchemaUtil.getModelitem((String)mitemName, (Model)smodel)) == null) continue;
            if (fkeys != null) {
                for (ForeignKey fkey : fkeys) {
                    if (!fkey.getName().equals(mitemName)) continue;
                    targetfkey = fkey;
                    break;
                }
            }
            if (!"storeref".equals(s_mitem.getType()) && targetfkey == null) continue;
            if (targetfkey != null) {
                Transaction transaction = new Transaction();
                transaction.setKey(mitemName);
                String transactionModel = this.con_.getModelitemValue(modelId, mitemName, key + "_2");
                if (StringUtils.isNotBlank((CharSequence)transactionModel)) {
                    transaction.setContent(transactionModel);
                } else {
                    transaction.setContent(targetfkey.getIdref());
                }
                action.addContent((IActionChoice)transaction);
            } else {
                String transactionModel;
                Relation relation = AppSchemaUtil.getRelationTypeExceptRef((Modelitem)s_mitem);
                Relation relationIsRef = AppSchemaUtil.getRelationTypeIsRef((Modelitem)s_mitem);
                if (relation == null && relationIsRef == null || (transactionModel = this.con_.getModelitemValue(modelId, mitemName, key + "_2")) == null && relation == null) continue;
                Transaction transaction = new Transaction();
                transaction.setKey(mitemName);
                if (StringUtils.isNotBlank((CharSequence)transactionModel)) {
                    transaction.setContent(transactionModel);
                } else {
                    String idref = null;
                    if (relation != null) {
                        idref = relation.getIdref();
                    } else if (relationIsRef != null) {
                        idref = relationIsRef.getIdref();
                    }
                    if (idref != null) {
                        transaction.setContent(idref);
                    } else {
                        this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_transaction.create"));
                    }
                }
                action.addContent((IActionChoice)transaction);
            }
            if (actionType != ActionType.insert && actionType != ActionType.update && actionType != ActionType.copy && actionType != ActionType.delete) continue;
            this.addTransactionScriptElement(modelId, mitemName, action, "insertTransaction");
            this.addTransactionScriptElement(modelId, mitemName, action, "updateTransaction");
            this.addTransactionScriptElement(modelId, mitemName, action, "deleteTransaction");
        }
    }

    private String createTargetKey(ActionType actionType) {
        StringBuilder sb = new StringBuilder();
        sb.append("action/transaction");
        if (actionType == ActionType.insert) {
            sb.append("ForInsert");
        } else if (actionType == ActionType.copy) {
            sb.append("ForCopyInsert");
        } else if (actionType == ActionType.update) {
            sb.append("ForUpdate");
        } else if (actionType == ActionType.delete) {
            sb.append("ForDelete");
        }
        return sb.toString();
    }

    private void addTransactionScriptElement(String modelId, String itemname, Action action, String pattern) {
        if (pattern == null) {
            return;
        }
        String s = this.con_.getModelitemValue(modelId, itemname, "action/script/@" + pattern);
        if (StringUtils.isBlank((CharSequence)s)) {
            return;
        }
        Script script = new Script();
        script.setName(itemname);
        script.setType(pattern);
        script.setContent(s);
        action.addContent((IActionChoice)script);
    }
}

