/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.action;

import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.View;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="view_schedule")
public class BActionElement_view_schedule
extends BActionElement {
    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project) {
        View view = new View();
        view.setType("schedule");
        TreeMap<String, Item> viewitemMap = new TreeMap<String, Item>();
        String chartType = Utils.getScheduleviewType(modelId, this.con_);
        if ("timeline".equals(chartType)) {
            this.checkTimelineRequiredItem(modelId);
            view.setScheduleType("timeline");
            this.setTimelineViewItem(modelId, viewitemMap);
        } else if ("gantt".equals(chartType)) {
            this.checkGanttRequiredItem(modelId);
            view.setScheduleType("gantt");
            this.setGanttViewItem(modelId, viewitemMap);
        }
        view.addItem(viewitemMap.values().toArray(new Item[0]));
        action.addContent((IActionChoice)view);
    }

    private void checkTimelineRequiredItem(String modelId) {
        String[] requiredItems = new String[]{"action/view/scheduleview/timeline/item/@rowLabel", "action/view/scheduleview/timeline/item/@start", "action/view/scheduleview/timeline/item/@end"};
        this.checkSckeduleViewRequiredItem(modelId, requiredItems);
    }

    private void checkGanttRequiredItem(String modelId) {
        String[] requiredItems = new String[]{"action/view/scheduleview/gantt/item/@taskId", "action/view/scheduleview/gantt/item/@taskName", "action/view/scheduleview/gantt/item/@start", "action/view/scheduleview/gantt/item/@end"};
        this.checkSckeduleViewRequiredItem(modelId, requiredItems);
    }

    private void checkSckeduleViewRequiredItem(String modelId, String[] requiredItems) {
        if (!Stream.of(requiredItems).anyMatch(key -> StringUtils.isBlank((CharSequence)this.con_.getModelValue(modelId, (String)key)))) {
            return;
        }
        this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.CreatePanel_body_scheduleview.create0", new Object[]{Utils.getModelName(modelId, this.con_)}));
    }

    private void setTimelineViewItem(String modelId, Map<String, Item> viewitemMap) {
        this.setViewItem(modelId, "action/view/scheduleview/timeline/item/@rowLabel", "rowLabel", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/timeline/item/@barLabel", "barLabel", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/timeline/item/@start", "start", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/timeline/item/@end", "end", viewitemMap);
    }

    private void setGanttViewItem(String modelId, Map<String, Item> viewitemMap) {
        this.setViewItem(modelId, "action/view/scheduleview/gantt/item/@taskId", "taskId", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/gantt/item/@taskName", "taskName", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/gantt/item/@resourceId", "resourceId", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/gantt/item/@start", "start", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/gantt/item/@end", "end", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/gantt/item/@duration", "duration", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/gantt/item/@progress", "progress", viewitemMap);
        this.setViewItem(modelId, "action/view/scheduleview/gantt/item/@dependencies", "dependencies", viewitemMap);
    }

    private void setViewItem(String modelId, String repositoryKey, String itemName, Map<String, Item> viewitemMap) {
        String itemId = this.con_.getModelValue(modelId, repositoryKey);
        if (StringUtils.isBlank((CharSequence)itemId)) {
            return;
        }
        if (!Utils.hasListModel(modelId, itemId, this.con_)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.CreatePanel_body_scheduleview.create1", new Object[]{modelId, itemId}));
        }
        Item item = new Item();
        item.setName(itemName);
        item.setContent(itemId);
        viewitemMap.put(itemName, item);
    }
}

