/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.master;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Inititem;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilderFileTemplate;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BDomains;
import jp.jasminesoft.util.LocaleUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="BMaster")
public class BMaster
extends AppSchemaBuilderFileTemplate {
    protected Logger log = LogManager.getLogger(BMaster.class);
    @Autowired
    private BDomains bDomains_;

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    public void process(Project project) {
        Object[] modelIds = this.con_.getAllMasterModelId();
        Arrays.sort(modelIds);
        for (Object modelId : modelIds) {
            if (Utils.isNoOutputModel((String)modelId, this.con_)) continue;
            this.log.debug("Processing " + (String)modelId + " master model definition...");
            Object desc = this.con_.getModelValue((String)modelId, "model/@description");
            if (StringUtils.isBlank((CharSequence)desc)) {
                desc = modelId;
            }
            boolean createEditpage = Utils.isSelectedValue(this.con_.getModelValue((String)modelId, "createEditpage"));
            Integer menuorder = Utils.getMasterModelMenuorder((String)modelId, this.con_);
            String menuref = Utils.getMasterModelMenuref((String)modelId, this.con_);
            String menucolor = this.con_.getModelValue((String)modelId, "model/@menucolor");
            Model master = this.createMasterModel((String)modelId, (String)desc);
            this.setInititem(master);
            if (this.bDomains_ != null) {
                this.bDomains_.create((String)modelId, master, project);
            }
            project.addContent((IProjectChoice)master);
            if (!createEditpage) continue;
            this.createMasterAction((String)modelId, (String)desc, menuorder, menuref, menucolor, project);
            this.createMasterPresentation((String)modelId, (String)desc, project);
        }
    }

    private void createMasterAction(String modelId, String desc, Integer menuorder, String menuref, String menucolor, Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("capid", JavaSourceGenerator.capFirst((String)modelId));
        replaceMap.put("idref", modelId);
        if (StringUtils.isBlank((CharSequence)menuref)) {
            menuref = "mastermenu";
        }
        replaceMap.put("menuref", menuref);
        if (menuorder != null) {
            replaceMap.put("menuorder", menuorder);
        }
        if (StringUtils.isNotBlank((CharSequence)menucolor)) {
            replaceMap.put("menucolor", menucolor);
        }
        replaceMap.put("description", desc);
        String permname = null;
        String aclId = this.con_.getModelValue(modelId, "acl/@id");
        permname = aclId == null || "".equals(aclId) ? "jshparam_master" : modelId;
        replaceMap.put("permname", permname);
        this.readAppSchemaElement("action_master.xml", replaceMap, project);
    }

    private void createMasterPresentation(String modelId, String desc, Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("capid", JavaSourceGenerator.capFirst((String)modelId));
        replaceMap.put("description", desc);
        replaceMap.put("sidebarSubmenu", Utils.isSelectedValue(this.con_.getProjectValue("customize/sidebarSubmenu")));
        this.readAppSchemaElement("presentation_master.xml", replaceMap, project);
    }

    private void setInititem(Model model) {
        String modelId = model.getId();
        String[] modelitemNames = this.con_.getModelitemNames(modelId);
        String locale_str = LocaleUtil.getLocaleString((Locale)Locale.getDefault());
        for (String modelitemName : modelitemNames) {
            if (!Utils.isInteger(modelitemName)) continue;
            String id = this.con_.getModelitemValue(modelId, modelitemName, "model/inititem/@id");
            String content = this.con_.getModelitemValue(modelId, modelitemName, "model/inititem/text()");
            String content_en = this.con_.getModelitemValue(modelId, modelitemName, "model/inititem/text_en()");
            if (StringUtils.isBlank((CharSequence)id)) continue;
            int _id = StringUtil.intValue((String)id);
            if (_id < 0) {
                this.log.warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.master.BMaster.setInititem", new Object[]{modelId, String.valueOf(id)}));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)content_en)) {
                StringBuilder sb = new StringBuilder();
                sb.append("{ ");
                sb.append("\"").append(locale_str).append("\":\"");
                sb.append(content);
                sb.append("\", \"en\":\"");
                sb.append(content_en);
                sb.append("\" }");
                content = sb.toString();
            }
            Inititem item = new Inititem();
            item.setId(_id);
            item.setContent(content);
            model.addContent((IModelChoice)item);
        }
    }

    private Model createMasterModel(String modelId, String desc) {
        String storage;
        Model model = new Model();
        model.setType("master");
        model.setUseRelax(false);
        model.setId(modelId);
        model.setTablename(modelId);
        model.setDescription(desc);
        if (this.con_.existsKeyInModel(modelId, "model/@storage=static") && StringUtils.isBlank((CharSequence)(storage = this.con_.getModelValue(modelId, "model/@storage=static")))) {
            model.setStorage("static");
        }
        return model;
    }
}

