/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.model;

import java.util.ArrayList;
import java.util.List;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.DefaultValue;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.BaseConverter;
import jp.jasminesoft.jfc.tools.xls2appschema.IType;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.model.PreDefaultValue;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class BDefaultValue
extends BaseConverter {
    protected boolean isUsed_init() {
        return true;
    }

    protected boolean isUsed_select() {
        return true;
    }

    protected boolean isUsed_selectForEnd() {
        return true;
    }

    protected boolean isUsed_search() {
        return false;
    }

    protected boolean isUsed_searchForEnd() {
        return false;
    }

    protected boolean isUsed_insert() {
        return true;
    }

    protected boolean isUsed_update() {
        return true;
    }

    protected boolean isUsed_show() {
        return true;
    }

    protected boolean isUsed_readUpdate() {
        return true;
    }

    public void create(String modelId, Model model, Project project) {
        String[] names;
        for (String name : names = this.con_.getModelitemNames(modelId)) {
            String column;
            String type = this.con_.getModelitemValue(modelId, name, "model/modelitem/@type");
            String detailType = StringUtils.isNotBlank((CharSequence)type) ? IType.getIType(type) : null;
            ArrayList<PreDefaultValue> dlist_init = new ArrayList<PreDefaultValue>();
            ArrayList<PreDefaultValue> dlist_insert = new ArrayList<PreDefaultValue>();
            ArrayList<PreDefaultValue> dlist_update = new ArrayList<PreDefaultValue>();
            ArrayList<PreDefaultValue> dlist_select = new ArrayList<PreDefaultValue>();
            ArrayList<PreDefaultValue> dlist_selectForEnd = new ArrayList<PreDefaultValue>();
            ArrayList<PreDefaultValue> dlist_search = new ArrayList<PreDefaultValue>();
            ArrayList<PreDefaultValue> dlist_searchForEnd = new ArrayList<PreDefaultValue>();
            ArrayList<PreDefaultValue> dlist_show = new ArrayList<PreDefaultValue>();
            ArrayList<PreDefaultValue> dlist_readUpdate = new ArrayList<PreDefaultValue>();
            if ("special-fixed-init-dateTime".equals(detailType)) {
                dlist_init.add(new PreDefaultValue(name, "dateTime", "now"));
                dlist_insert.add(new PreDefaultValue(name, "dateTime", "now"));
            } else if ("special-fixed-init-userid".equals(detailType)) {
                dlist_init.add(new PreDefaultValue(name, "userid"));
                dlist_insert.add(new PreDefaultValue(name, "userid"));
            } else if ("special-fixed-update-dateTime".equals(detailType)) {
                dlist_init.add(new PreDefaultValue(name, "dateTime", "now"));
                dlist_insert.add(new PreDefaultValue(name, "dateTime", "now"));
                dlist_update.add(new PreDefaultValue(name, "dateTime", "now"));
            } else if ("special-fixed-update-userid".equals(detailType)) {
                dlist_init.add(new PreDefaultValue(name, "userid"));
                dlist_insert.add(new PreDefaultValue(name, "userid"));
                dlist_update.add(new PreDefaultValue(name, "userid"));
            } else {
                column = "model/modelitem/defaultValue[@action=init]";
                if (this.checkAddPreDefaultValue(modelId, name, column)) {
                    this.addPreDefaultValue(modelId, name, column, dlist_init, model, project);
                } else if ("special-url".equals(detailType)) {
                    dlist_init.add(new PreDefaultValue(name, "string", "http://"));
                }
                column = "model/modelitem/defaultValue[@action=show]";
                if (this.checkAddPreDefaultValue(modelId, name, column)) {
                    this.addPreDefaultValue(modelId, name, column, dlist_show, model, project);
                }
                if (this.checkAddPreDefaultValue(modelId, name, column = "model/modelitem/defaultValue[@action=insert]")) {
                    this.addPreDefaultValue(modelId, name, column, dlist_insert, model, project);
                }
                if (this.checkAddPreDefaultValue(modelId, name, column = "model/modelitem/defaultValue[@action=update]")) {
                    this.addPreDefaultValue(modelId, name, column, dlist_update, model, project);
                }
                if (this.checkAddPreDefaultValue(modelId, name, column = "model/modelitem/defaultValue[@action=readUpdate]")) {
                    this.addPreDefaultValue(modelId, name, column, dlist_readUpdate, model, project);
                }
            }
            column = "model/modelitem/defaultValue[@action=select]";
            if (this.checkAddPreDefaultValue(modelId, name, column)) {
                this.addPreDefaultValue(modelId, name, column, dlist_select, model, project);
            }
            if (this.checkAddPreDefaultValue(modelId, name, column = "model/modelitem/defaultValue[@action=selectForEnd]")) {
                this.addPreDefaultValue(modelId, name, column, dlist_selectForEnd, model, project);
            }
            if (this.checkAddPreDefaultValue(modelId, name, column = "model/modelitem/defaultValue[@action=search]")) {
                this.addPreDefaultValue(modelId, name, column, dlist_search, model, project);
            }
            if (this.checkAddPreDefaultValue(modelId, name, column = "model/modelitem/defaultValue[@action=searchForEnd]")) {
                this.addPreDefaultValue(modelId, name, column, dlist_searchForEnd, model, project);
            }
            if (this.isUsed_init()) {
                this.outputDefaultValue(dlist_init, "init", model, modelId, name, detailType);
            }
            if (this.isUsed_select()) {
                this.outputDefaultValue(dlist_select, "select", model, modelId, name, detailType);
            }
            if (this.isUsed_selectForEnd()) {
                this.outputDefaultValue(dlist_selectForEnd, "selectForEnd", model, modelId, name, detailType);
            }
            if (this.isUsed_search()) {
                this.outputDefaultValue(dlist_search, "search", model, modelId, name, detailType);
            }
            if (this.isUsed_searchForEnd()) {
                this.outputDefaultValue(dlist_searchForEnd, "searchForEnd", model, modelId, name, detailType);
            }
            if (this.isUsed_show()) {
                this.outputDefaultValue(dlist_show, "show", model, modelId, name, detailType);
            }
            if (this.isUsed_insert()) {
                this.outputDefaultValue(dlist_insert, "insert", model, modelId, name, detailType);
            }
            if (this.isUsed_update()) {
                this.outputDefaultValue(dlist_update, "update", model, modelId, name, detailType);
            }
            if (!this.isUsed_readUpdate()) continue;
            this.outputDefaultValue(dlist_readUpdate, "readUpdate", model, modelId, name, detailType);
        }
    }

    private boolean checkAddPreDefaultValue(String modelId, String name, String column) {
        if (StringUtils.isNotBlank((CharSequence)this.con_.getModelitemValue(modelId, name, column + "_2"))) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)this.con_.getModelitemValue(modelId, name, column));
    }

    protected void addPreDefaultValue(String modelId, String name, String column, List<PreDefaultValue> dlist, Model model, Project project) {
        String searchtype;
        String type = this.convertDefaultValueType(modelId, name, this.con_.getModelitemValue(modelId, name, column));
        String value = this.con_.getModelitemValue(modelId, name, column + "_2");
        if (value != null) {
            value = value.trim();
        }
        if ("condition".equals(model.getType()) && "check".equals(searchtype = Utils.getSearchtype(modelId, name, this.con_)) && StringUtils.isNotBlank((CharSequence)value) && value.trim().equalsIgnoreCase("ALL")) {
            type = "special-storeref-check";
        }
        if (("userid".equals(type) || "jgroupid".equals(type)) && StringUtils.isNotBlank((CharSequence)value)) {
            this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BDefaultValue.addPreDefaultValue.1", new Object[]{modelId, name, value}));
            value = "";
        } else if (("javacode".equals(type) || "operation".equals(type)) && !StringUtils.isNotBlank((CharSequence)value)) {
            String m = "javacode".equals(type) ? ropt.getValue("OPTION_model_modelitem_defaultValue_5_value_disp") : ropt.getValue("OPTION_model_modelitem_defaultValue_4_value_disp");
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BDefaultValue.addPreDefaultValue.2", new Object[]{modelId, name, m}));
        }
        if ("javacode".equals(type)) {
            value = StringUtil.replaceAll((String)value, (String)("${" + modelId + "}"), (String)modelId);
        }
        String type0 = this.getPreDefaultValueType(modelId, name, project, type);
        if (type != null && (type.equals("special-storeref-check") && JavaSourceGenerator.isBasicType((String)type0) || type.equals("special-masterref-check")) && "ALL".equals(value)) {
            value = "-1";
        }
        type = type != null && type.startsWith("special-storeref") && this.isReservedSpecialCase(value) ? "string" : type0;
        dlist.add(new PreDefaultValue(name, type, value));
    }

    private String getPreDefaultValueType(String modelId, String name, Project project, String type) {
        if ("special-masterref-combo".equals(type) || "special-masterref-radio".equals(type) || "special-masterref-check".equals(type)) {
            type = "int";
        } else if ("special-mailaddress".equals(type) || "special-url".equals(type) || "special-filename".equals(type) || "zipcode".equals(type)) {
            type = "string";
        } else if (type != null && type.startsWith("special-storeref")) {
            String detailType;
            String roleid_type;
            String relation_idref = this.con_.getModelitemValue(modelId, name, "model/modelitem/relation/@idref");
            if (StringUtils.isBlank((CharSequence)relation_idref)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BDefaultValue.getPreDefaultValueType.1", new Object[]{modelId, name}));
            }
            if (StringUtils.isBlank((CharSequence)(roleid_type = this.con_.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@roleid")))) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BDefaultValue.getPreDefaultValueType.2", new Object[]{modelId, name}));
                return type;
            }
            String roleid = null;
            if (ropt.getValue("OPTION_model_modelitem_relation_storeref_roleid_1_value").equals(roleid_type) || ropt.getValue("OPTION_model_modelitem_relation_storeref_roleid_2_value").equals(roleid_type)) {
                roleid = this.con_.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@roleid_2");
                if (StringUtils.isBlank((CharSequence)roleid)) {
                    String[] names_;
                    for (String name_ : names_ = this.con_.getModelitemNames(relation_idref)) {
                        String pkey = this.con_.getModelitemValue(relation_idref, name_, "model/modelitem/@primaryKey");
                        if (!StringUtils.isNotBlank((CharSequence)pkey)) continue;
                        roleid = name_;
                        break;
                    }
                }
            } else {
                roleid = roleid_type;
            }
            if (ropt.getValue("OPTION_model_modelitem_relation_storeref_roleid_2_value").equals(roleid_type) && StringUtils.isBlank((CharSequence)roleid)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BDefaultValue.getPreDefaultValueType.3", new Object[]{modelId, name}));
                return type;
            }
            String rolecontent = this.con_.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@rolecontent");
            if (StringUtils.isBlank((CharSequence)rolecontent)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BDefaultValue.getPreDefaultValueType.4", new Object[]{modelId, name}));
                return type;
            }
            if (ropt.getValue("OPTION_model_modelitem_relation_storeref_roleid_1_value").equals(roleid_type)) {
                detailType = Utils.getDetailType(relation_idref, roleid, this.con_);
                return this.getPreDefaultValueType(relation_idref, roleid, project, detailType);
            }
            detailType = Utils.getDetailType(relation_idref, rolecontent, this.con_);
            return this.getPreDefaultValueType(relation_idref, rolecontent, project, detailType);
        }
        return type;
    }

    protected abstract void outputDefaultValue(List<PreDefaultValue> var1, String var2, Model var3, String var4, String var5, String var6);

    protected DefaultValue createDefaultValue(String name, String type, String action) {
        return this.createDefaultValue(name, type, action, null);
    }

    protected DefaultValue createDefaultValue(String name, String type, String action, String content) {
        String _tmp;
        if (!JavaSourceGenerator.isValidValue((String)type, (String)content) && !this.isReservedSpecialCase(_tmp = StringUtil.removePreAndPostWhitespaceWithoutInside((String)content))) {
            return null;
        }
        DefaultValue dv = new DefaultValue();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            dv.setName(name);
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            dv.setType(type);
        }
        if (StringUtils.isNotBlank((CharSequence)action)) {
            dv.setAction(action);
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            dv.setContent(content);
        }
        return dv;
    }

    private boolean isReservedSpecialCase(String tmp) {
        if (StringUtils.isBlank((CharSequence)tmp)) {
            return false;
        }
        return tmp.startsWith("SESSION(") && tmp.endsWith(")") || tmp.startsWith("REQUEST(") && tmp.endsWith(")") || tmp.startsWith("ATTRIBUTE(") && tmp.endsWith(")") || tmp.startsWith("PAGEMAP(") && tmp.endsWith(")") || tmp.startsWith("APPMAP(") && tmp.endsWith(")");
    }

    protected String convertDefaultValueType(String modelId, String name, String type) {
        String ret = null;
        if (ropt.getValue("OPTION_model_modelitem_typeDetail_string_1_value").equals(type)) {
            ret = "string";
        } else if (ropt.getValue("OPTION_model_modelitem_defaultValue_1_value").equals(type) || ropt.getValue("OPTION_model_modelitem_defaultValue_1_value_alt").equals(type)) {
            ret = "random:string";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_number_1_value").equals(type)) {
            ret = "int";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_dateTime_1_value").equals(type)) {
            ret = "date";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_dateTime_3_value").equals(type)) {
            ret = "time";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_dateTime_2_value").equals(type)) {
            ret = "dateTime";
        } else if (ropt.getValue("OPTION_model_modelitem_defaultValue_2_value").equals(type)) {
            ret = "userid";
        } else if (ropt.getValue("OPTION_model_modelitem_defaultValue_3_value").equals(type)) {
            ret = "jgroupid";
        } else if (ropt.getValue("OPTION_model_modelitem_defaultValue_goukei").equals(type)) {
            ret = "sum";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_number_2_value").equals(type)) {
            ret = "byte";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_number_3_value").equals(type)) {
            ret = "short";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_number_4_value").equals(type)) {
            ret = "int";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_number_5_value").equals(type)) {
            ret = "long";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_number_6_value").equals(type)) {
            ret = "float";
        } else if (ropt.getValue("OPTION_model_modelitem_typeDetail_number_7_value").equals(type)) {
            ret = "double";
        } else if (ropt.getValue("OPTION_model_modelitem_defaultValue_5_value").equals(type)) {
            ret = "javacode";
        } else if (ropt.getValue("OPTION_model_modelitem_defaultValue_4_value").equals(type)) {
            ret = "operation";
        } else if (StringUtils.isNotBlank((CharSequence)type)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BDefaultValue.convertDefaultValueType.1", new Object[]{modelId, name, type}));
        }
        String detailType = Utils.getDetailType(modelId, name, this.con_);
        if (ret == null) {
            ret = detailType;
        } else if (!"javacode".equals(ret) && !"operation".equals(ret)) {
            boolean mismatch = false;
            if ("date".equals(ret)) {
                if (!detailType.equals("date") && !detailType.startsWith("special-storeref")) {
                    mismatch = true;
                }
            } else if ("time".equals(ret)) {
                if (!detailType.equals("time") && !detailType.startsWith("special-storeref")) {
                    mismatch = true;
                }
            } else if ("dateTime".equals(ret)) {
                if (!(detailType.equals("dateTime") || detailType.startsWith("special-storeref") || detailType.equals("special-fixed-init-dateTime") || detailType.equals("special-fixed-update-dateTime"))) {
                    mismatch = true;
                }
            } else if (!"date".equals(ret) && !"time".equals(ret) && !"dateTime".equals(ret) && (detailType.equals("date") || detailType.equals("time") || detailType.equals("dateTime"))) {
                mismatch = true;
            }
            if (mismatch) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BDefaultValue.convertDefaultValueType.2", new Object[]{modelId, name, type, IType.getDescription(detailType)}));
            }
        }
        if (ret.equals("special-fixed-init-dateTime") || ret.equals("special-fixed-update-dateTime")) {
            ret = "dateTime";
        }
        return ret;
    }
}

