/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Css;
import jp.jasminesoft.jfc.gen.appschema.Csslist;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Javascript;
import jp.jasminesoft.jfc.gen.appschema.Javascriptlist;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.BaseConverter;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionTemplate;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.BPresentation;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.CreatePanelFactory;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.PanelType;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.PresentationType;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BPresentationTemplate
extends BaseConverter {
    private CompatibilityManager compatibilityManager = CompatibilityManager.getInstance();
    protected CreatePanelFactory pfactory_;
    protected String LAYOUTTYPE_MOBILE = "tiles:mobile";
    protected String LAYOUTTYPE_TILES = "tiles:classic2";
    protected String LAYOUTTYPE_THYMELEAF = "thymeleaf";
    protected String LAYOUTTYPE_THYMELEAF_PRINT = "thymeleaf:print";
    protected String LAYOUTTYPE_THYMELEAF_STANDARD = "thymeleaf:standard";

    @Autowired(required=true)
    public void setCreatePanelFactory(CreatePanelFactory pfactory) {
        this.pfactory_ = pfactory;
    }

    public abstract ActionType getType();

    public abstract PresentationType getPresentationType();

    public abstract String getIdrefType();

    public abstract String getLayoutType();

    public boolean isValid(String modelId, Project project) {
        String type = BActionTemplate.getProperAppSchemaActionType(this.getType());
        if (type == null) {
            return false;
        }
        Action[] actions = AppSchemaUtil.getActionByModelId((Project)project, (String)modelId);
        if (actions == null || actions.length == 0) {
            return false;
        }
        for (Action action : actions) {
            if (!action.getValid()) continue;
            return true;
        }
        return false;
    }

    public void setPresentationAttribute(String modelId, Action action, Presentation presentation, Project project, int num, int copyIndex) {
        StringBuilder idref = new StringBuilder();
        idref.append(this.getId(modelId));
        String capid = Utils.getCapid(modelId);
        StringBuilder filename = new StringBuilder();
        if (PresentationType.printScreen != this.getPresentationType() && PresentationType.printListScreen != this.getPresentationType() && PresentationType.subWindowShow != this.getPresentationType()) {
            if (ActionType.insert == this.getType() && this.getPresentationType() == PresentationType.confirmInsert && Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@confirmInsert"))) {
                filename.append("confirmInsert");
            } else if (ActionType.update == this.getType() && this.getPresentationType() == PresentationType.confirmUpdate && Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@confirmUpdate"))) {
                filename.append("confirmUpdate");
            } else {
                filename.append(this.getIdrefType());
            }
            filename.append(capid);
            if (this.getPresentationType() == PresentationType.searchListForRefgroup) {
                filename.append("Jshparam");
            }
        } else {
            filename.append((Object)this.getPresentationType());
            filename.append(capid);
            if (PresentationType.printScreen == this.getPresentationType() && Utils.isWizardModel(modelId, this.con_)) {
                idref.append("P");
                filename.append("P");
            }
            presentation.setFilename(filename.toString());
        }
        if (ActionType.showList == this.getType() && num == BPresentation.SHOWLIST_RESULT && PresentationType.totalview != this.getPresentationType()) {
            filename.append("$2");
            presentation.setFilename(filename.toString());
        }
        if (ActionType.copy == this.getType()) {
            if (Utils.isWizardModel(modelId, this.con_)) {
                idref.append("C");
                idref.append(copyIndex);
                filename.append("C");
                filename.append(copyIndex);
                idref.append("P");
                filename.append("P");
                filename.append(num);
                presentation.setFilename(filename.toString());
            } else {
                idref.append("C");
                idref.append(num);
            }
        }
        if (ActionType.insert == this.getType() || ActionType.update == this.getType() || ActionType.show == this.getType() && PresentationType.printScreen != this.getPresentationType() && PresentationType.subWindowShow != this.getPresentationType()) {
            if (Utils.isWizardModel(modelId, this.con_)) {
                idref.append("P");
                if (this.getPresentationType() != PresentationType.confirmInsert && this.getPresentationType() != PresentationType.confirmUpdate) {
                    filename.append("P");
                    filename.append(num);
                }
                presentation.setFilename(filename.toString());
            } else if ((ActionType.insert == this.getType() || ActionType.copy == this.getType()) && Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@confirmInsert"))) {
                presentation.setFilename(filename.toString());
            } else if (ActionType.update == this.getType() && Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@confirmUpdate"))) {
                presentation.setFilename(filename.toString());
            }
        }
        if (PresentationType.totalview == this.getPresentationType()) {
            if (num != 1) {
                idref.append("T");
                idref.append(num);
            }
            idref.append("Totalview");
        } else if (PresentationType.calendar == this.getPresentationType()) {
            idref.append("Calendarview");
        } else if (PresentationType.scheduleview == this.getPresentationType()) {
            idref.append("Scheduleview");
        }
        if (PresentationType.updateList == this.getPresentationType()) {
            presentation.setFilename(filename.toString());
        }
        presentation.setIdref(idref.toString());
        if ((ActionType.showList == this.getType() && num != BPresentation.SHOWLIST_RESULT || ActionType.download == this.getType() || ActionType.insert == this.getType() || ActionType.update == this.getType() || ActionType.copy == this.getType() || ActionType.download == this.getType() || ActionType.updateList == this.getType()) && PresentationType.calendar != this.getPresentationType() && PresentationType.totalview != this.getPresentationType() && PresentationType.scheduleview != this.getPresentationType() && PresentationType.printListScreen != this.getPresentationType() && Utils.isSelectedValue(this.con_.getProjectValue("project/customize/@enableFocusFirstElement"))) {
            presentation.setEnableFocusFirstElement(true);
        }
        if (Utils.isMobile(modelId, this.con_) && !"mobile".equals(this.getLayoutType())) {
            presentation.setMobile(Utils.getMobile(modelId, this.con_));
        }
    }

    public void setPresentationElement(String modelId, String modelId_ref, Action action, Presentation presentation, Project project, int num, int copyIndex) {
        Layout layout = new Layout();
        if (Utils.isSmartPhone(modelId, this.con_) && !"mobile".equals(this.getLayoutType())) {
            layout.setType(this.LAYOUTTYPE_MOBILE);
        } else if (Utils.isCSSLayout(modelId, this.con_) && !Utils.isSmartPhone(modelId, this.con_)) {
            if (PresentationType.printScreen == this.getPresentationType() || PresentationType.printListScreen == this.getPresentationType()) {
                layout.setType(this.LAYOUTTYPE_THYMELEAF_PRINT);
            } else if (PresentationType.subWindowShow == this.getPresentationType()) {
                layout.setType(this.LAYOUTTYPE_THYMELEAF_STANDARD);
            } else {
                layout.setType(this.LAYOUTTYPE_THYMELEAF);
            }
        } else {
            layout.setType(this.getLayoutType());
        }
        this.setLayoutOutputmethod(modelId, layout);
        if ("tiles:print".equals(this.getLayoutType()) || PresentationType.searchListMobile == this.getPresentationType() && "mobile".equals(this.getLayoutType())) {
            Panel panel = this.getPanel(PanelType.body, modelId, action, project, num, copyIndex);
            if ("mobile".equals(this.getLayoutType())) {
                this.setSearchListFilename(panel);
            }
            if (panel != null) {
                layout.addPanel(panel);
            }
            presentation.setLayout(layout);
            return;
        }
        if ((ActionType.showList == this.getType() || ActionType.showListRestrictparam == this.getType() || ActionType.searchList == this.getType() || ActionType.searchListForRefgroup == this.getType() || ActionType.updateList == this.getType() || ActionType.reportList == this.getType()) && PresentationType.calendar != this.getPresentationType() && PresentationType.totalview != this.getPresentationType() && PresentationType.scheduleview != this.getPresentationType()) {
            this.addPanel(PanelType.pagetitle, modelId, action, project, num, copyIndex, layout);
            if (!Utils.isCSSLayout(modelId, this.con_) || PresentationType.showList != this.getPresentationType()) {
                this.addPanel(PanelType.header, modelId, action, project, num, copyIndex, layout);
            }
        } else {
            if (!Utils.isCSSLayout(modelId, this.con_) || PresentationType.show != this.getPresentationType() && PresentationType.insert != this.getPresentationType() && PresentationType.update != this.getPresentationType() && PresentationType.copy != this.getPresentationType() && PresentationType.subWindowShow != this.getPresentationType()) {
                this.addPanel(PanelType.header, modelId, action, project, num, copyIndex, layout);
            }
            this.addPanel(PanelType.pagetitle, modelId, action, project, num, copyIndex, layout);
        }
        if (PresentationType.searchList != this.getPresentationType() && PresentationType.searchListForRefgroup != this.getPresentationType() && PresentationType.subWindowShow != this.getPresentationType()) {
            if (!Utils.isCSSLayout(modelId, this.con_) || PresentationType.show != this.getPresentationType() && PresentationType.showList != this.getPresentationType() && PresentationType.insert != this.getPresentationType() && PresentationType.update != this.getPresentationType() && PresentationType.updateList != this.getPresentationType() && PresentationType.copy != this.getPresentationType()) {
                this.addPanel(PanelType.errormsg, modelId, action, project, num, copyIndex, layout);
                this.addPanel(PanelType.submenu, modelId, action, project, num, copyIndex, layout);
                this.addPanel(PanelType.sidebar, modelId, action, project, num, copyIndex, layout);
                this.addPanel(PanelType.pankuzu, modelId, action, project, num, copyIndex, layout);
            }
            if (PresentationType.calendar == this.getPresentationType() || PresentationType.totalview == this.getPresentationType() || PresentationType.scheduleview == this.getPresentationType()) {
                this.addPanel(PanelType.description, modelId, action, project, num, copyIndex, layout);
            }
        }
        this.addPanel(PanelType.navigationbar, modelId, action, project, num, copyIndex, layout);
        if (PresentationType.calendar != this.getPresentationType() && PresentationType.totalview != this.getPresentationType() && PresentationType.scheduleview != this.getPresentationType()) {
            this.addPanel(PanelType.description, modelId, action, project, num, copyIndex, layout);
        }
        this.addPanel(PanelType.body, modelId, action, project, num, copyIndex, layout);
        this.addPanel(PanelType.footer, modelId, action, project, num, copyIndex, layout);
        this.addPanel(PanelType.closewindow, modelId, action, project, num, copyIndex, layout);
        this.addPanel(PanelType.endbody, modelId, action, project, num, copyIndex, layout);
        presentation.setLayout(layout);
        this.addJavascriptlist(modelId, presentation);
    }

    protected void setLayoutOutputmethod(String modelId, Layout layout) {
        if (Utils.isMobile(modelId, this.con_) || Utils.isCalendarOutput(modelId, this.con_) && "classic".equals(Utils.getCalendarType(modelId, this.con_))) {
            layout.setOutputmethod("HTMLTable");
        } else if (Utils.isCSSLayout(modelId, this.con_)) {
            layout.setOutputmethod("CSSLayout");
        } else {
            layout.setOutputmethod("HTMLTable");
        }
    }

    private void addJavascriptlist(String modelId, Presentation presentation) {
        this.addRokuyoJavascriptlist(modelId, presentation);
        this.addJfcparticipantUtilJavascriptlist(modelId, presentation);
        this.addGoogleChartJavaScriptLib(modelId, presentation);
        this.addJspreadSheetJavaScriptLib(modelId, presentation);
    }

    private void addRokuyoJavascriptlist(String modelId, Presentation presentation) {
        if (Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/view/@rokuyo")) && PresentationType.calendar == this.getPresentationType()) {
            this.setJavascriptlist("system/qreki.js", presentation);
        }
    }

    private void addJfcparticipantUtilJavascriptlist(String modelId, Presentation presentation) {
        if ("jfcparticipant_setting".equals(modelId) && (PresentationType.insert == this.getPresentationType() || PresentationType.update == this.getPresentationType() || PresentationType.copy == this.getPresentationType())) {
            this.setJavascriptlist("jfcparticipant_setting/jfcparticipantSettingUtil.js", presentation);
        }
    }

    private void addGoogleChartJavaScriptLib(String modelId, Presentation presentation) {
        if (!Utils.isScheduleviewOutput(modelId, this.con_) || PresentationType.scheduleview != this.getPresentationType()) {
            return;
        }
        this.setJavascriptlist(ropt.getValue("action_view_scheduleview_js_lib_url"), presentation);
    }

    private void addJspreadSheetJavaScriptLib(String modelId, Presentation presentation) {
        if (!Utils.isCSSLayout(modelId, this.con_) || Utils.isMobile(modelId, this.con_) || PresentationType.showList != this.getPresentationType() && PresentationType.updateList != this.getPresentationType()) {
            return;
        }
        String showListDisplayType = this.con_.getModelValue(modelId, "presentation/displaymodel/@showListDisplayType");
        if (!"spreadsheet".equals(showListDisplayType)) {
            return;
        }
        ArrayList<String> cssLists = new ArrayList<String>(Arrays.asList("css/jsuites.css,css/jspreadsheet.css,css/jspreadsheet.datatables.css".split(",")));
        this.setCsslist(cssLists, presentation);
    }

    private void setJavascriptlist(String content, Presentation presentation) {
        Javascriptlist javascriptlist = new Javascriptlist();
        Javascript javascript = new Javascript();
        javascript.setContent(content);
        javascriptlist.setJavascript(javascript);
        presentation.setJavascriptlist(javascriptlist);
    }

    private void setJavascriptlists(List<String> scriptFiles, Presentation presentation) {
        Javascriptlist javascriptlist = new Javascriptlist();
        scriptFiles.stream().forEach(scriptFile -> {
            Javascript javascript = new Javascript();
            javascript.setContent(scriptFile);
            javascriptlist.addJavascript(javascript);
        });
        presentation.setJavascriptlist(javascriptlist);
    }

    private void setCsslist(List<String> cssFiles, Presentation presentation) {
        Csslist csslist = new Csslist();
        cssFiles.stream().forEach(cssFile -> {
            Css css = new Css();
            css.setContent(cssFile);
            csslist.addCss(css);
        });
        presentation.setCsslist(csslist);
    }

    public String getId(String modelId) {
        return this.getIdrefType() + SourceGenerator.capFirst((String)modelId);
    }

    public void create(String modelId, Project project) {
        this.create(modelId, modelId, project, -1, -1);
    }

    public void create(String modelId, String modelId_ref, Project project) {
        this.create(modelId, modelId_ref, project, -1, -1);
    }

    public void create(String modelId, Project project, int num) {
        this.create(modelId, modelId, project, num, -1);
    }

    public void create(String modelId, Project project, int num, int copyIndex) {
        this.create(modelId, modelId, project, num, copyIndex);
    }

    public void create(String modelId, String modelId_ref, Project project, int num, int copyIndex) {
        if (!this.isValid(modelId, project)) {
            return;
        }
        Action action = null;
        Action[] _actions = AppSchemaUtil.getActionByModelId((Project)project, (String)modelId);
        String __type = BActionTemplate.getProperAppSchemaActionType(this.getType());
        for (Action _action : _actions) {
            if (!_action.getType().equals(__type)) continue;
            if (this.getPresentationType() == PresentationType.totalview) {
                if (!"total".equals(_action.getView())) continue;
                if (num > 1) {
                    Object __id = this.getId(modelId);
                    __id = (String)__id + "T" + num + "Totalview";
                    if (!_action.getId().equals(__id)) continue;
                }
                action = _action;
                break;
            }
            action = _action;
            break;
        }
        if (action == null) {
            return;
        }
        Presentation presentation = new Presentation();
        this.setPresentationAttribute(modelId, action, presentation, project, num, copyIndex);
        this.setPresentationElement(modelId, modelId_ref, action, presentation, project, num, copyIndex);
        project.addContent((IProjectChoice)presentation);
    }

    private void addPanel(PanelType type, String modelId, Action action, Project project, int num, int copyIndex, Layout layout) {
        Panel panel = this.pfactory_.create(type, modelId, this.getPresentationType(), action, project, num, copyIndex);
        if (panel != null) {
            layout.addPanel(panel);
        }
    }

    private Panel getPanel(PanelType type, String modelId, Action action, Project project, int num, int copyIndex) {
        return this.pfactory_.create(type, modelId, this.getPresentationType(), action, project, num, copyIndex);
    }

    private void setSearchListFilename(Panel panel) {
        IPanelChoice[] ipcs;
        for (IPanelChoice ipc : ipcs = panel.getContent()) {
            if (ipc instanceof Displaycondition) {
                Displaycondition displaycondition = (Displaycondition)ipc;
                displaycondition.setOutputfilename(this.getMobileFilename(displaycondition.getOutputfilename()));
                continue;
            }
            if (!(ipc instanceof Displaymodel)) continue;
            Displaymodel displaymodel = (Displaymodel)ipc;
            displaymodel.setOutputfilename(this.getMobileFilename(displaymodel.getOutputfilename()));
        }
    }

    private String getMobileFilename(String filename) {
        StringBuilder outputfilename = new StringBuilder();
        outputfilename.append(filename).append("Mobile");
        return outputfilename.toString();
    }
}

