/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displaygraph;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Displaytext;
import jp.jasminesoft.jfc.gen.appschema.Displaytotalratio;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.View;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.CreatePanel_body;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.DisplaytextFactory;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.PUtils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.PresentationType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="CreatePanel_body_totalview")
public class CreatePanel_body_totalview
extends CreatePanel_body {
    private String idreftype = "totalview";
    static final String[][] types = new String[][]{{"3Dbar", ropt.getValue("OPTION_model_graphType_15_value")}, {"area", ropt.getValue("OPTION_model_graphType_12_value")}, {"bar", ropt.getValue("OPTION_model_graphType_3_value")}, {"clusteredBar", ropt.getValue("OPTION_model_graphType_4_value")}, {"clusteredColumn", ropt.getValue("OPTION_model_graphType_2_value")}, {"column", ropt.getValue("OPTION_model_graphType_1_value")}, {"line", ropt.getValue("OPTION_model_graphType_8_value")}, {"mline", ropt.getValue("OPTION_model_graphType_9_value")}, {"pie", ropt.getValue("OPTION_model_graphType_7_value")}, {"piev", ropt.getValue("OPTION_model_graphType_6_value")}, {"scatter", ropt.getValue("OPTION_model_graphType_11_value")}, {"stackedArea", ropt.getValue("OPTION_model_graphType_13_value")}, {"stackedBar", ropt.getValue("OPTION_model_graphType_5_value")}, {"stackedColumn", ropt.getValue("OPTION_model_graphType_14_value")}, {"stackedLine", ropt.getValue("OPTION_model_graphType_10_value")}};
    static final String[][] colors = new String[][]{{"blue", ropt.getValue("OPTION_model_graphColor_1_value")}, {"cyan", ropt.getValue("OPTION_model_graphColor_3_value")}, {"green", ropt.getValue("OPTION_model_graphColor_6_value")}, {"orange", ropt.getValue("OPTION_model_graphColor_2_value")}, {"purple", ropt.getValue("OPTION_model_graphColor_5_value")}, {"red", ropt.getValue("OPTION_model_graphColor_4_value")}};

    @Override
    public Panel create(String modelId, PresentationType ptype, Action action, Project project, int num, int copyIndex) {
        Panel panel = new Panel();
        panel.setName(this.getMyPanelName());
        String capid = Utils.getCapid(modelId);
        Displaycondition displaycondition = new Displaycondition();
        displaycondition.setSearchbuttonlabel(PUtils.getProperLabelResource("project/message/@condition.do.search", "condition.do.search", this.con_));
        displaycondition.setEvent("Search_Condition");
        displaycondition.setResetbuttonlabel(PUtils.getProperLabelResource("project/message/@condition.label.reset", "condition.label.reset", this.con_));
        displaycondition.setLabel("");
        displaycondition.setWidth(rman.getValue("condition.width"));
        displaycondition.setIdref(modelId + "_cp");
        StringBuilder actionName = new StringBuilder();
        actionName.append("showList");
        actionName.append(capid);
        if (num != 1) {
            actionName.append("T");
            actionName.append(num);
        }
        actionName.append("Totalview");
        displaycondition.setAction(actionName.toString());
        displaycondition.setOutputfilename("condition" + capid + "Cp2");
        if (Utils.isResetOnly(modelId, this.con_)) {
            displaycondition.setResetOnly(true);
        }
        PUtils.setDisplayitemsCondition(modelId, this.con_, this.idreftype, displaycondition, project);
        PUtils.setDisplayconditionButtonLayout(displaycondition, modelId, this.con_);
        panel.addContent((IPanelChoice)displaycondition);
        Object multipledisplaymodelForTotalviewKey = "presentation/multipledisplaymodelForTotalview";
        if (num != -1 && num > 1) {
            multipledisplaymodelForTotalviewKey = (String)multipledisplaymodelForTotalviewKey + num;
        }
        String multipledisplaymodelForTotalviewValue = this.con_.getModelValue(modelId, (String)multipledisplaymodelForTotalviewKey);
        TreeSet<Integer> numSet = new TreeSet<Integer>();
        if (StringUtils.isNotBlank((CharSequence)multipledisplaymodelForTotalviewValue)) {
            String[] tokens = multipledisplaymodelForTotalviewValue.split(",");
            numSet.add(num);
            for (String token : tokens) {
                try {
                    int onum = Integer.parseInt(token);
                    if (onum < 1 || onum > 10) {
                        // empty if block
                    }
                    numSet.add(onum);
                }
                catch (NumberFormatException onum) {
                    // empty catch block
                }
            }
            for (Integer numtarget : numSet) {
                String titleKey = "model/@totalviewPagetitle" + (Serializable)(numtarget > 1 ? numtarget : "");
                String title = this.getTitle(modelId, numtarget, titleKey, this.con_);
                Displaytext dtext = DisplaytextFactory.createDisplaytext(modelId);
                dtext.setValueClass("totalview_title");
                dtext.setContent(title);
                panel.addContent((IPanelChoice)dtext);
                this.create0(modelId, panel, ptype, action, project, numtarget, copyIndex);
            }
        } else {
            this.create0(modelId, panel, ptype, action, project, num, copyIndex);
        }
        ArrayList<Displaygraph> displaygraphs = new ArrayList<Displaygraph>();
        numSet.add(num);
        for (Integer numtarget : numSet) {
            Displaygraph displaygraph = this.getTotalviewDisplaygraph(modelId, this.con_, numtarget);
            if (displaygraph == null) continue;
            displaygraphs.add(displaygraph);
        }
        if (!displaygraphs.isEmpty()) {
            Panel graphPanel = new Panel();
            graphPanel.setPanelClass("plain");
            graphPanel.setAlign("center");
            for (Displaygraph displaygraph : displaygraphs) {
                graphPanel.addContent((IPanelChoice)displaygraph);
            }
            panel.addContent((IPanelChoice)graphPanel);
        }
        return panel;
    }

    private void create0(String modelId, Panel panel, PresentationType ptype, Action action, Project project, int num, int copyIndex) {
        String displaytotalratio;
        Displaymodel displaymodel = new Displaymodel();
        displaymodel.setLabel("");
        displaymodel.setValueClass("display_field_right,display_field2_right");
        displaymodel.setWidth(rman.getValue("showlist.width"));
        displaymodel.setAutoalignment(false);
        StringBuilder idref = new StringBuilder();
        idref.append(modelId);
        if (num != 1) {
            idref.append("T");
            idref.append(num);
        }
        idref.append("_tp");
        displaymodel.setIdref(idref.toString());
        String keyfooter = "";
        if (num >= 2) {
            keyfooter = Integer.toString(num);
        }
        if (!StringUtils.isBlank((CharSequence)(displaytotalratio = this.con_.getModelValue(modelId, "presentation//displaytotalratio" + keyfooter)))) {
            boolean useDisplaytotalration = true;
            View view = AppSchemaUtil.getView((Action)action);
            if (view != null) {
                Item[] items;
                for (Item item : items = view.getItem()) {
                    String type = item.getType();
                    if (type == null || type.equals("sum") || type.equals("count")) continue;
                    useDisplaytotalration = false;
                    this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.CreatePanel_body_totalview.create0", new Object[]{modelId, action.getDescription(), type}));
                    break;
                }
            }
            if (useDisplaytotalration) {
                Displaytotalratio dtr = new Displaytotalratio();
                String dtr_numberformat = this.con_.getModelValue(modelId, "presentation//displaytotalratio/@numberformat" + keyfooter);
                if (!StringUtils.isBlank((CharSequence)dtr_numberformat)) {
                    dtr.setNumberformat(dtr_numberformat);
                }
                displaymodel.addContent((IDisplaymodelChoice)dtr);
            }
        }
        this.setTotalviewDisplayitem(modelId, this.con_, num, displaymodel);
        panel.addContent((IPanelChoice)displaymodel);
    }

    private void setTotalviewDisplayitem(String modelId, ElementContainer con, int num, Displaymodel displaymodel) {
        StringBuilder totalNum = new StringBuilder();
        totalNum.append("total");
        StringBuilder viewAttr = new StringBuilder();
        viewAttr.append("@totalview");
        if (num > 1 && num <= 10) {
            totalNum.append(num);
            viewAttr.append(num);
        }
        TreeMap<String, String> demensionName = new TreeMap<String, String>();
        ArrayList<String> majorNames = new ArrayList<String>();
        for (String name : con.getModelitemNames(modelId)) {
            String totalViewKey = "action/view/item[@type=" + totalNum.toString() + "]/@name";
            String totalviewType = con.getModelitemValue(modelId, name, totalViewKey);
            if (totalviewType == null) continue;
            if (totalviewType.contains(ropt.getValue("OPTION_action_view_item_type_total_dimension"))) {
                demensionName.put(totalviewType, name);
                continue;
            }
            if (!totalviewType.contains(ropt.getValue("OPTION_action_view_item_type_total_major"))) continue;
            majorNames.add(name);
        }
        for (String key : demensionName.keySet()) {
            this.setTotalviewDimension(modelId, (String)demensionName.get(key), con, viewAttr.toString(), displaymodel, num);
        }
        for (String majorName : majorNames) {
            this.setTotalviewMajor(modelId, majorName, con, viewAttr.toString(), displaymodel, num);
        }
    }

    private void setTotalviewDimension(String modelId, String name, ElementContainer con, String viewAttr, Displaymodel displaymodel, int num) {
        Displayitem displayitem = new Displayitem();
        displayitem.setName(name);
        String labelname = Utils.getLabelName(modelId, name, con, "TotalView");
        if (StringUtils.isBlank((CharSequence)labelname)) {
            labelname = Utils.getLabelName(modelId, name, con, "Show");
        }
        if (StringUtils.isNotBlank((CharSequence)labelname)) {
            displayitem.setLabelname(labelname);
        }
        displayitem.setValueClass("display_field_center,display_field2_center");
        this.setStyle(modelId, name, num, con, displayitem);
        displaymodel.addContent((IDisplaymodelChoice)displayitem);
    }

    private void setTotalviewMajor(String modelId, String name, ElementContainer con, String viewAttr, Displaymodel displaymodel, int num) {
        Displayitem displayitem = new Displayitem();
        displayitem.setName(name);
        String labelname = Utils.getLabelName(modelId, name, con, "TotalView");
        if (StringUtils.isBlank((CharSequence)labelname)) {
            labelname = Utils.getLabelName(modelId, name, con, "Show");
        }
        if (StringUtils.isNotBlank((CharSequence)labelname)) {
            displayitem.setLabelname(labelname);
        }
        this.setNumberformatForTotalviewMajor(modelId, name, con, displayitem);
        this.setStyle(modelId, name, num, con, displayitem);
        displaymodel.addContent((IDisplaymodelChoice)displayitem);
    }

    private void setStyle(String modelId, String name, int num, ElementContainer con, Displayitem displayitem) {
        String style;
        String ind_style;
        String common_style;
        StringBuilder stylebuf = new StringBuilder();
        Object common_style_key = "presentation/totalview/displayitem/@style";
        if (num >= 2) {
            common_style_key = (String)common_style_key + num;
        }
        if (StringUtils.isNotBlank((CharSequence)(common_style = con.getModelValue(modelId, (String)common_style_key)))) {
            stylebuf.append(common_style.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(ind_style = con.getModelitemValue(modelId, name, "presentation/displayitem/@styleForShowListTotalView")))) {
            if (!stylebuf.toString().endsWith(";")) {
                stylebuf.append(";");
            }
            stylebuf.append(ind_style);
        }
        if (StringUtils.isNotBlank((CharSequence)(style = stylebuf.toString()))) {
            displayitem.setStyle(style);
        }
    }

    private void setNumberformatForTotalviewMajor(String modelId, String name, ElementContainer con, Displayitem displayitem) {
        String numberformat = Utils.getNumberFormat(modelId, name, con);
        if (StringUtils.isNotBlank((CharSequence)numberformat)) {
            displayitem.setNumberformat(numberformat);
        } else if (Utils.isDetailType(modelId, name, con, "double") || Utils.isDetailType(modelId, name, con, "float")) {
            displayitem.setNumberformat("#,##0.0#");
        } else {
            displayitem.setNumberformat("#,###");
        }
    }

    private Displaygraph getTotalviewDisplaygraph(String modelId, ElementContainer con, int num) {
        String graphFontSize;
        String pieLabelLength;
        String pieFontSize;
        String height;
        String width;
        String htitle;
        StringBuilder graphKey = new StringBuilder();
        graphKey.append("model/@isGraph");
        if (num > 1 && num <= 10) {
            graphKey.append(num);
        }
        if (!Utils.isSelectedValue(con.getModelValue(modelId, graphKey.toString()))) {
            return null;
        }
        Displaygraph displaygraph = new Displaygraph();
        StringBuilder idref = new StringBuilder();
        idref.append(modelId);
        if (num != 1) {
            idref.append("T");
            idref.append(num);
        }
        idref.append("_tp");
        displaygraph.setIdref(idref.toString());
        StringBuilder titleKey = new StringBuilder();
        titleKey.append("model/@totalviewPagetitle");
        StringBuilder graphVHtitleKey = new StringBuilder();
        graphVHtitleKey.append("model/@graphVtitleHtitle");
        StringBuilder graphWidthHeightKey = new StringBuilder();
        graphWidthHeightKey.append("model/@graphWidthHeight");
        StringBuilder pieFontSizeKey = new StringBuilder("model/@graphPieFontSize");
        StringBuilder pieLabelLengthKey = new StringBuilder("model/@graphPieLabelLength");
        StringBuilder graphFontSizeKey = new StringBuilder("model/@graphFontSize");
        StringBuilder showKey = new StringBuilder("model/@graphShow");
        StringBuilder typeKey = new StringBuilder("model/@graphType");
        StringBuilder colorKey = new StringBuilder("model/@graphColor");
        if (num > 1 && num <= 10) {
            titleKey.append(num);
            graphVHtitleKey.append(num);
            graphWidthHeightKey.append(num);
            pieFontSizeKey.append(num);
            pieLabelLengthKey.append(num);
            graphFontSizeKey.append(num);
            showKey.append(num);
            typeKey.append(num);
            colorKey.append(num);
        }
        String title = this.getTitle(modelId, num, titleKey.toString(), con);
        displaygraph.setTitle(title);
        String vtitle = con.getModelValue(modelId, graphVHtitleKey.toString());
        if (StringUtils.isNotBlank((CharSequence)vtitle)) {
            displaygraph.setVtitle(vtitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(htitle = con.getModelValue(modelId, graphVHtitleKey.toString() + "_2")))) {
            displaygraph.setHtitle(htitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(width = con.getModelValue(modelId, graphWidthHeightKey.toString() + "_2")))) {
            displaygraph.setWidth(width);
        }
        if (StringUtils.isNotBlank((CharSequence)(height = con.getModelValue(modelId, graphWidthHeightKey.toString())))) {
            displaygraph.setHeight(height);
        }
        if (StringUtils.isNotBlank((CharSequence)(pieFontSize = con.getModelValue(modelId, pieFontSizeKey.toString())))) {
            displaygraph.setPieFontSize(pieFontSize);
        }
        if (StringUtils.isNotBlank((CharSequence)(pieLabelLength = con.getModelValue(modelId, pieLabelLengthKey.toString())))) {
            displaygraph.setPieLabelLength(pieLabelLength);
        }
        if (StringUtils.isNotBlank((CharSequence)(graphFontSize = con.getModelValue(modelId, graphFontSizeKey.toString())))) {
            displaygraph.setGraphFontSize(graphFontSize);
        }
        if (con.existsKeyInModel(modelId, showKey.toString())) {
            String show = con.getModelValue(modelId, showKey.toString());
            if (StringUtils.isNotBlank((CharSequence)show)) {
                displaygraph.setShow(true);
            } else {
                displaygraph.setShow(false);
            }
        } else {
            displaygraph.setShow(true);
        }
        String type = con.getModelValue(modelId, typeKey.toString());
        type = type != null ? type.trim() : null;
        boolean isSetTypeFlag = false;
        for (String[] type1 : types) {
            if (!type1[1].equals(type)) continue;
            displaygraph.setType(type1[0]);
            isSetTypeFlag = true;
            break;
        }
        if (!isSetTypeFlag && StringUtils.isNotBlank((CharSequence)type)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.CreatePanel_body_totalview.create0", new Object[]{modelId, type}));
        }
        String color = con.getModelValue(modelId, colorKey.toString());
        for (String[] color1 : colors) {
            if (!color1[1].equals(color)) continue;
            displaygraph.setColor(color1[0]);
            break;
        }
        return displaygraph;
    }

    private String getTitle(String modelId, int num, String titleKey, ElementContainer con) {
        String title = con.getModelValue(modelId, titleKey);
        if (StringUtils.isBlank((CharSequence)title)) {
            StringBuilder description = new StringBuilder();
            description.append(con.getModelValue(modelId, "model/@description"));
            description.append(PUtils.getProperLabelResource("project/message/@title.totalview", "title.totalview", con));
            if (this.getTotalviewCount(modelId, con) > 1) {
                description.append("(");
                description.append(num);
                description.append(")");
            }
            title = description.toString();
        }
        return title;
    }

    private int getTotalviewCount(String modelId, ElementContainer con) {
        int count = 0;
        for (String key : con.getKeysByModelAndKeyPrefix(modelId, "model/@totalviewOutput")) {
            if (!Utils.isSelectedValue(con.getModelValue(modelId, key))) continue;
            ++count;
        }
        return count;
    }
}

