/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.printlayout;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Printall;
import jp.jasminesoft.jfc.gen.appschema.Printlayout;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="BPrintlayout")
public class BPrintlayout
extends AppSchemaBuilder {
    protected static final Logger log = LogManager.getLogger(BPrintlayout.class);

    @Override
    public void process(Project project) {
        Object[] modelIds = this.con_.getAllStoreModelId();
        Arrays.sort(modelIds);
        String REPKEY = "printlayout/filename";
        HashMap<Object, HashSet<String>> useTypesByModelId = null;
        for (Object modelId : modelIds) {
            log.debug("Processing " + (String)modelId + " printlayout definition...");
            int max_length = 1;
            for (String key : this.con_.getKeysByModelAndKeyPrefix((String)modelId, "printlayout/filename")) {
                max_length = Math.max(max_length, StringUtil.intValue((String)key.substring("printlayout/filename".length())));
            }
            for (int i = 1; i <= max_length; ++i) {
                HashSet<String> useTypes;
                String idx;
                String dispositiontype;
                String key = "printlayout/filename" + i;
                String filename = Utils.getPrintlayoutFileName((String)modelId, key, this.con_);
                String displayname = Utils.getPrintlayoutDisplayname((String)modelId, key, this.con_);
                if (StringUtils.isBlank((CharSequence)filename) || StringUtils.isBlank((CharSequence)displayname)) continue;
                String type = Utils.getPrintlayoutType((String)modelId, key, this.con_);
                String useLiblary = Utils.getPrintlayoutLibraryType((String)modelId, key, this.con_);
                String filetype = Utils.getPrintlayoutFileType((String)modelId, key, this.con_);
                String outputfilename = this.con_.getModelValue((String)modelId, "printlayout/outputfilename" + key.substring("printlayout/filename".length()));
                Printlayout printlayout = new Printlayout();
                printlayout.setUselibrary(useLiblary);
                printlayout.setType(filetype);
                String id = Utils.getPrintLayoutId((String)modelId, Utils.getPrintlayoutTemplateFileName(filename), type, filetype);
                printlayout.setId(id);
                Object filename_ = null;
                filename_ = filename.startsWith("TEMPLATE(") ? filename : filename + ("jasperreports".equals(useLiblary) ? ".jrxml" : ".xls");
                printlayout.setFilename((String)filename_);
                if (displayname.contains("JDBC")) {
                    printlayout.setDatasource("jdbc");
                }
                if (!StringUtils.isBlank((CharSequence)outputfilename)) {
                    printlayout.setOutputfilename(outputfilename);
                }
                dispositiontype = StringUtils.isEmpty((CharSequence)(dispositiontype = this.con_.getModelValue((String)modelId, "printlayout/dispositiontype" + (idx = key.substring("printlayout/filename".length()))))) ? "inline" : (ropt.getValue("OPTION_printlayout_dispositiontype_download").equals(dispositiontype) ? "attachment" : "inline");
                printlayout.setDispositiontype(dispositiontype);
                project.addContent((IProjectChoice)printlayout);
                if (useTypesByModelId == null) {
                    useTypesByModelId = new HashMap<Object, HashSet<String>>();
                }
                if ((useTypes = (HashSet<String>)useTypesByModelId.get(modelId)) == null) {
                    useTypes = new HashSet<String>();
                    useTypesByModelId.put(modelId, useTypes);
                }
                useTypes.add(filetype);
            }
        }
        if (useTypesByModelId != null) {
            for (IProjectChoice ipc : project.getContent()) {
                Action action;
                Printall printall;
                if (!(ipc instanceof Action) || (printall = AppSchemaUtil.getPrintall((Action)(action = (Action)ipc))) == null) continue;
                Set useTypes = (Set)useTypesByModelId.get(action.getIdref());
                if (AppSchemaUtil.isEnablePrintallOutputMethodPdf((Printall)printall)) {
                    if (useTypes.contains("pdf")) continue;
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.printlayout.BPrintlayout.typemismatch", new Object[]{action.getIdref(), action.getDescription(), "pdf"}));
                    continue;
                }
                if (!AppSchemaUtil.isEnablePrintallOutputMethodSheet((Printall)printall) || useTypes.contains("excel")) continue;
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.printlayout.BPrintlayout.typemismatch", new Object[]{action.getIdref(), action.getDescription(), "excel"}));
            }
        }
    }
}

