/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.core.resources.PropertyUtils;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import jp.jasminesoft.jfc.core.util.SystemUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextGenerator;
import jp.jasminesoft.jfc.gen.appschema.Activemq;
import jp.jasminesoft.jfc.gen.appschema.Anormlib;
import jp.jasminesoft.jfc.gen.appschema.ApplicationContextConfig;
import jp.jasminesoft.jfc.gen.appschema.AwsConnectInfo;
import jp.jasminesoft.jfc.gen.appschema.Cacheinfo;
import jp.jasminesoft.jfc.gen.appschema.Cluster;
import jp.jasminesoft.jfc.gen.appschema.ClusterMachine;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Dblockmanager;
import jp.jasminesoft.jfc.gen.appschema.Defaultlogon;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Filestore;
import jp.jasminesoft.jfc.gen.appschema.IEnvironmentChoice;
import jp.jasminesoft.jfc.gen.appschema.Init;
import jp.jasminesoft.jfc.gen.appschema.Initloader;
import jp.jasminesoft.jfc.gen.appschema.Logonuserinfo;
import jp.jasminesoft.jfc.gen.appschema.MessageQueue;
import jp.jasminesoft.jfc.gen.appschema.Notnulldefault;
import jp.jasminesoft.jfc.gen.appschema.Openapi;
import jp.jasminesoft.jfc.gen.appschema.Param;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.QuartzJDBCJobstore;
import jp.jasminesoft.jfc.gen.appschema.RdbSetting;
import jp.jasminesoft.jfc.gen.appschema.Rdbtypemap;
import jp.jasminesoft.jfc.gen.appschema.Redisdatabase;
import jp.jasminesoft.jfc.gen.appschema.Replication;
import jp.jasminesoft.jfc.gen.appschema.SchemaMigration;
import jp.jasminesoft.jfc.gen.appschema.Script;
import jp.jasminesoft.jfc.gen.appschema.Security;
import jp.jasminesoft.jfc.gen.appschema.Subdatabase;
import jp.jasminesoft.jfc.tools.repository.RepositoryManagerUtil;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.util.JavaVersion;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="BEnvironment")
public class BEnvironment
extends AppSchemaBuilder {
    public static final String SUBDATABASE_RESOURCENAME_PREFIX = "jdbc/jfc";
    protected Logger log = LogManager.getLogger(BEnvironment.class);
    private static Map<String, String> DEFAULT_DBSETTING_MAP;
    private static Map<String, String> DEFAULT_MYSQL_DBSETTING_MAP;
    private static final TimeRange[] TimeRanges;
    private static final Pattern NumPattern;

    @Override
    public void process(Project project) {
        Environment env = new Environment();
        this.setBrowserCacheMaxAge(env);
        this.setJavac(env);
        this.setJavadocMaxMemory(env);
        this.setJvmMaxPermSize(env);
        this.setTomcatdirAndPac(env);
        this.setTomcatMem(env);
        this.setTomcatPortAndOtherInfo(env, project);
        this.setTomcatOption(env);
        this.setCacheinfo(env);
        this.setDatabase(env, project);
        this.setAnorm(env);
        this.setInitLoader(env, project);
        this.setDefaultlogon(env);
        this.setInit(env);
        this.setCluster(env);
        this.setDblockmanager(env);
        this.setApplicationContext(env);
        this.setDojodirAndPac(env);
        this.setChangeAjaxElement(env);
        this.setLogonuserinfomsg(env);
        this.setTextSearchAttirbute(env);
        this.setLogtype(env);
        this.setGoogleMap(env);
        this.setDefaultRESTAPIVersion(env);
        this.setInvalidMark(env);
        this.setHttpSessionStoreType(env);
        this.setDateTimeFormat(env);
        this.setSecurity(env);
        this.setMessageQueue(env);
        this.setScript(env);
        this.setJFCAppModeManager(env);
        this.setDomain(env);
        this.setAwsConnectionInfo(env);
        this.setFilestore(env);
        this.setOpenapi(env);
        this.setBeforeDeleteCheckOtherModelRef(env);
        project.setEnvironment(env);
    }

    private void setDateTimeFormat(Environment env) {
        String s = this.con_.getProjectValue("project/environment/@dateformat");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            env.setDateformat(s);
        }
        if (StringUtils.isNotBlank((CharSequence)(s = this.con_.getProjectValue("project/environment/@timeformat")))) {
            env.setTimeformat(s);
        }
        if (StringUtils.isNotBlank((CharSequence)(s = this.con_.getProjectValue("project/environment/@datetimeformat")))) {
            env.setDatetimeformat(s);
        }
    }

    private void setHttpSessionStoreType(Environment env) {
        String s = this.con_.getProjectValue("project/environment/@httpsessionstoretype");
        if (StringUtils.isBlank((CharSequence)s)) {
            env.setHttpSessionStoreType("httpsession");
        } else if (s.equals("HTTP Session")) {
            env.setHttpSessionStoreType("httpsession");
        } else if (s.equals("Spring Session HashMap")) {
            env.setHttpSessionStoreType("springsession_hashmap");
            this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setHttpSessionStoreType.hashmap"));
        } else if (s.equals("Spring Session Redis")) {
            env.setHttpSessionStoreType("springsession_redis");
        } else {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setHttpSessionStoreType.unknowntype", new Object[]{s}));
        }
        String sessionCookieDomain = this.con_.getProjectValue("project/environment/@sessionCookieDomain");
        if (StringUtils.isNotBlank((CharSequence)sessionCookieDomain)) {
            env.setSessionCookieDomain(sessionCookieDomain);
        }
        String host = this.con_.getProjectValue("project/environment/@redis_host");
        String password = this.con_.getProjectValue("project/environment/@redis_password");
        String port = this.con_.getProjectValue("project/environment/@redis_port");
        String namespace = this.con_.getProjectValue("project/environment/@redis_springSessionNamespace");
        Redisdatabase rdb = new Redisdatabase();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            rdb.setHost(host);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            rdb.setPassword(password);
        }
        if (StringUtils.isNotBlank((CharSequence)port)) {
            try {
                rdb.setPort(Integer.parseInt(port));
            }
            catch (NumberFormatException e) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setHttpSessionStoreType.illegalport", new Object[]{port}));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            rdb.setSpringSessionNamespace(namespace);
        }
        env.addContent((IEnvironmentChoice)rdb);
    }

    private void setInvalidMark(Environment env) {
        if (!this.con_.existsKeyInProject("project/environment/@invalidmark")) {
            env.setInvalidMark(" (-)");
        } else {
            String s = this.con_.getProjectValue("project/environment/@invalidmark");
            if (StringUtils.isNotBlank((CharSequence)s)) {
                env.setInvalidMark(" " + s);
            } else {
                env.setInvalidMark("");
            }
        }
    }

    private void setDefaultRESTAPIVersion(Environment env) {
        String s = this.con_.getProjectValue("project/environment/@defaultrestapiversion");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            env.setDefaultrestapiversion(s);
        }
    }

    private void setGoogleMap(Environment env) {
        env.setGooglmapsapikey(this.con_.getProjectValue("project/environment/init/@googlemaps_apikey"));
    }

    private void setLogtype(Environment env) {
        if (Utils.isSelectedValue(this.con_.getProjectValue("project/environment/@logtype"))) {
            env.setLogtype("changelog");
        }
    }

    private void setLogonuserinfomsg(Environment env) {
        Logonuserinfo logonuserinfomsg = new Logonuserinfo();
        String msg = this.con_.getProjectValue("project/customize/@logonuserinfomsg");
        if (StringUtils.isBlank((CharSequence)msg)) {
            msg = rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setLogonuserinfomsg");
        }
        if (msg.indexOf("${") >= 0) {
            int len = msg.length();
            StringBuilder sb = new StringBuilder("\"");
            for (int i = 0; i < len; ++i) {
                char c = msg.charAt(i);
                if (c == '$' && i + 1 < len && msg.charAt(i + 1) == '{') {
                    char c0;
                    sb.append("\" + ");
                    StringBuilder var = new StringBuilder("USERINFO(\"");
                    for (int j = i += 2; j < len && (c0 = msg.charAt(j)) != '}'; ++j) {
                        var.append(c0);
                        ++i;
                    }
                    var.append("\")");
                    sb.append((CharSequence)var);
                    sb.append(" + \"");
                    continue;
                }
                sb.append(c);
            }
            sb.append("\"");
            msg = sb.toString();
        }
        logonuserinfomsg.setContent(msg);
        env.addContent((IEnvironmentChoice)logonuserinfomsg);
    }

    private void setApplicationContext(Environment env) {
        ApplicationContextConfig appconfig = new ApplicationContextConfig();
        boolean lazyinit = Utils.isLazyinitAttribute(this.con_);
        if (lazyinit) {
            appconfig.setLazyinit(lazyinit);
        }
        env.addContent((IEnvironmentChoice)appconfig);
    }

    private void setCluster(Environment env) {
        if (!Utils.isCluster(this.con_)) {
            return;
        }
        Cluster cluster = new Cluster();
        cluster.setUseCluster(true);
        String connect_retry = this.con_.getProjectValue("project/environment/cluster/@connect_retry");
        if (StringUtils.isBlank((CharSequence)connect_retry)) {
            connect_retry = "3";
        }
        cluster.setConnectRetryByString(connect_retry);
        String connect_sleeptime = this.con_.getProjectValue("project/environment/cluster/@connect_sleeptime");
        if (StringUtils.isBlank((CharSequence)connect_sleeptime)) {
            connect_sleeptime = "5000";
        }
        cluster.setConnectSleeptimeByString(connect_sleeptime);
        LinkedHashSet<ClusterMachine> clusterSet = new LinkedHashSet<ClusterMachine>();
        for (int i = 1; i <= 10; ++i) {
            String machinename = this.getClusterMachinename(i);
            String ip_addr = this.getClusterIpAddr(i);
            String jmx_port = this.getClusterJmxPort(i);
            String rmi_port = this.getClusterRmiPort(i);
            String thismachine = this.getClusterThismachine(i);
            if (machinename == null || "".equals(machinename) || ip_addr == null || "".equals(ip_addr) || jmx_port == null || "".equals(jmx_port) || rmi_port == null || "".equals(rmi_port)) continue;
            if ("".equals(machinename)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setCluster.1", new Object[]{String.valueOf(i)}));
            }
            if ("".equals(ip_addr)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setCluster.2", new Object[]{String.valueOf(i)}));
            }
            if ("".equals(jmx_port)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setCluster.3", new Object[]{String.valueOf(i)}));
            }
            int jmxPort = 0;
            try {
                jmxPort = Integer.parseInt(jmx_port);
            }
            catch (NumberFormatException e) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setCluster.4", new Object[]{String.valueOf(i)}));
            }
            if ("".equals(rmi_port)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setCluster.5", new Object[]{String.valueOf(i)}));
            }
            int rmiPort = 0;
            try {
                rmiPort = Integer.parseInt(rmi_port);
            }
            catch (NumberFormatException e) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setCluster.6", new Object[]{String.valueOf(i)}));
            }
            if (jmxPort == rmiPort) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setCluster.7", new Object[]{String.valueOf(i)}));
            }
            ClusterMachine clusterMachine = new ClusterMachine();
            clusterMachine.setMachinename(StringUtil.escapeStringForXML((String)machinename));
            clusterMachine.setIpaddr(StringUtil.escapeStringForXML((String)ip_addr));
            clusterMachine.setJmxPort(jmxPort);
            clusterMachine.setRmiPort(rmiPort);
            boolean thismachineFlag = Utils.isSelectedValue(thismachine);
            if (thismachineFlag) {
                clusterMachine.setThismachine(thismachineFlag);
            }
            clusterSet.add(clusterMachine);
        }
        cluster.setClusterMachine(clusterSet.toArray(new ClusterMachine[0]));
        env.addContent((IEnvironmentChoice)cluster);
    }

    private String getClusterThismachine(int number) {
        String value = "";
        value = this.con_.getProjectValue("project/environment/cluster/cluster_machine" + number + "_5");
        return value;
    }

    private String getClusterRmiPort(int number) {
        String value = "";
        value = this.con_.getProjectValue("project/environment/cluster/cluster_machine" + number + "_4");
        return value;
    }

    private String getClusterJmxPort(int number) {
        String value = "";
        value = this.con_.getProjectValue("project/environment/cluster/cluster_machine" + number + "_3");
        return value;
    }

    private String getClusterIpAddr(int number) {
        String value = "";
        value = this.con_.getProjectValue("project/environment/cluster/cluster_machine" + number + "_2");
        return value;
    }

    private String getClusterMachinename(int number) {
        String value = "";
        value = this.con_.getProjectValue("project/environment/cluster/cluster_machine" + number);
        return value;
    }

    private void setDblockmanager(Environment env) {
        boolean isAutoscale = Utils.isAutoScaling(this.con_);
        if (!Utils.isDblockmanager(this.con_) && !isAutoscale) {
            return;
        }
        Dblockmanager dlm = new Dblockmanager();
        dlm.setUse(true);
        if (isAutoscale) {
            dlm.setClearThismachineAtPostConstruct(false);
        }
        env.addContent((IEnvironmentChoice)dlm);
    }

    private void setInit(Environment env) {
        String _icsfilename;
        String _inet_bottomarea;
        String _inet_sidebar;
        String _inet_pankuzu;
        String _inet_submenu;
        String _inet_logoficon;
        String _inet_helpicon;
        String _inet_menuicon;
        String _inet_fontsize;
        String language_selectable;
        String passwordReminder;
        String display_passwordReminder_selectable;
        String display_passwordReminder;
        String display_bottomarea_selectable;
        String display_bottomarea;
        String display_pankuzu_selectable;
        String display_pankuzu;
        String display_calendarFirstDayOfWeek_selectable;
        String calendarFirstDayOfWeek;
        String display_submenu_position_selectable;
        String submenu_position;
        String display_submenu_selectable;
        String display_submenu;
        String display_globallink_selectable;
        String display_globallink;
        String display_logofficon_selectable;
        String display_logofficon;
        String display_helpicon_selectable;
        String display_helpicon;
        String display_menuicon_selectable;
        String display_menuicon;
        String display_fontsize_selectable;
        String display_fontsize;
        String display_cssfilename_selectable;
        boolean refreshJuserEveryAccess;
        String userinfo_oldpasswd_save_size;
        String userinfo_passwd_change_warn_period;
        String userinfo_passwd_expire_period;
        String userinfo_failedpassword_count;
        String userinfo_passwd_digest_algorithm;
        Object mailhost;
        String cssfilemanager;
        String download_dir;
        String appmenu;
        String logon_module;
        String session_timeout;
        String max_logon;
        String max_multiple_logon;
        String encoding_convert;
        String jsp_encoding;
        Init init = new Init();
        String security_url = this.con_.getProjectValue("project/environment/init/@security_url");
        if (StringUtils.isNotBlank((CharSequence)security_url)) {
            this.addParam4Init(init, "security_url", security_url);
        }
        if (StringUtils.isNotBlank((CharSequence)(jsp_encoding = this.con_.getProjectValue("project/environment/init/@jsp_encoding")))) {
            this.addParam4Init(init, "jsp_encoding", jsp_encoding);
        }
        if (StringUtils.isNotBlank((CharSequence)(encoding_convert = this.con_.getProjectValue("project/environment/init/@encoding_convert")))) {
            this.addParam4Init(init, "encoding_convert", encoding_convert);
        }
        if (StringUtils.isNotBlank((CharSequence)(max_multiple_logon = this.con_.getProjectValue("project/environment/init/@max_multiple_logon")))) {
            this.addParam4Init(init, "max_multiple_logon", max_multiple_logon);
        }
        if (StringUtils.isNotBlank((CharSequence)(max_logon = this.con_.getProjectValue("project/environment/init/@max_logon")))) {
            this.addParam4Init(init, "max_logon", max_logon);
        }
        if (StringUtils.isNotBlank((CharSequence)(session_timeout = this.con_.getProjectValue("project/environment/init/@session_timeout")))) {
            this.addParam4Init(init, "session_timeout", session_timeout);
        }
        if (StringUtils.isNotBlank((CharSequence)(logon_module = this.con_.getProjectValue("project/environment/init/@logon_module")))) {
            this.addParam4Init(init, "logon_module", logon_module);
        }
        if (StringUtils.isNotBlank((CharSequence)(appmenu = this.con_.getProjectValue("project/environment/init/@appmenu")))) {
            this.addParam4Init(init, "appmenu", appmenu);
        }
        if (StringUtils.isNotBlank((CharSequence)(download_dir = this.con_.getProjectValue("project/environment/init/@download_dir")))) {
            this.addParam4Init(init, "download_dir", download_dir);
        }
        if (StringUtils.isNotBlank((CharSequence)(cssfilemanager = this.con_.getProjectValue("project/environment/init/@cssfilemanager")))) {
            this.addParam4Init(init, "cssfilemanager", cssfilemanager);
        }
        if (StringUtils.isNotBlank((CharSequence)(mailhost = this.con_.getProjectValue("project/environment/mail/@mailhost")))) {
            String mailport = this.con_.getProjectValue("project/environment/mail/@port");
            if (Utils.isInteger(mailport)) {
                mailhost = (String)mailhost + ":" + mailport;
            }
        } else {
            mailhost = this.con_.getProjectValue("project/environment/init/@mailhost");
        }
        if (StringUtils.isNotBlank((CharSequence)mailhost)) {
            this.addParam4Init(init, "mailhost", (String)mailhost);
        }
        this.addParam4Init(init, "mailmessage", "${DEPLOYHOME}/WEB-INF/mailmessage");
        this.addParam4Init(init, "is_output_remote_addr_in_logdata", "true");
        String csv_encoding = this.con_.getProjectValue("project/environment/init/@csv_encoding");
        if (StringUtils.isBlank((CharSequence)csv_encoding)) {
            csv_encoding = "Windows-31J";
        }
        this.addParam4Init(init, "csv_encoding", csv_encoding);
        String download_charset = this.con_.getProjectValue("project/environment/init/@download_charset");
        if (StringUtils.isNotBlank((CharSequence)download_charset)) {
            this.addParam4Init(init, "download_charset", download_charset);
        }
        if (StringUtils.isNotBlank((CharSequence)(userinfo_passwd_digest_algorithm = this.passwdHashAlgorithm())) && !this.isBCrypt(userinfo_passwd_digest_algorithm)) {
            this.addParam4Init(init, "userinfo_passwd_digest_algorithm", userinfo_passwd_digest_algorithm);
        }
        if (StringUtils.isNotBlank((CharSequence)(userinfo_failedpassword_count = this.con_.getProjectValue("project/environment/user/@userinfo_failedpassword_count")))) {
            this.addParam4Init(init, "userinfo_failedpassword_count", userinfo_failedpassword_count);
        }
        if (StringUtils.isNotBlank((CharSequence)(userinfo_passwd_expire_period = this.con_.getProjectValue("project/environment/user/@userinfo_passwd_expire_period")))) {
            this.addParam4Init(init, "userinfo_passwd_expire_period", userinfo_passwd_expire_period);
        }
        if (StringUtils.isNotBlank((CharSequence)(userinfo_passwd_change_warn_period = this.con_.getProjectValue("project/environment/user/@userinfo_passwd_change_warn_period")))) {
            this.addParam4Init(init, "userinfo_passwd_change_warn_period", userinfo_passwd_change_warn_period);
        }
        if (StringUtils.isNotBlank((CharSequence)(userinfo_oldpasswd_save_size = this.con_.getProjectValue("project/environment/user/@userinfo_oldpasswd_save_size")))) {
            this.addParam4Init(init, "userinfo_oldpasswd_save_size", userinfo_oldpasswd_save_size);
        }
        this.addParam4Init(init, "refreshJuserEveryAccess", (refreshJuserEveryAccess = Utils.isSelectedValue(this.con_.getProjectValue("project/customize/@refreshJuserEveryAccess"))) ? "true" : "false");
        boolean auto_logoff = Utils.isSelectedValue(this.con_.getProjectValue("project/customize/@auto_logoff"));
        this.addParam4Init(init, "auto_logoff", auto_logoff ? "true" : "false");
        boolean backToMenuAfterSessionTimeout = Utils.isSelectedValue(this.con_.getProjectValue("project/customize/@backToMenuAfterSessionTimeout"));
        this.addParam4Init(init, "backToMenuAfterSessionTimeout", backToMenuAfterSessionTimeout ? "true" : "false");
        String display_cssfilename = this.con_.getProjectValue("project/environment/preference/@cssfilename");
        if (StringUtils.isNotBlank((CharSequence)display_cssfilename)) {
            this.addParam4Init(init, "cssfilename", display_cssfilename);
        }
        if (StringUtils.isNotBlank((CharSequence)(display_cssfilename_selectable = this.con_.getProjectValue("project/environment/preference/@cssfilename_2")))) {
            this.addParam4Init(init, "cssfilename_selectable", this.convSelectableValue(display_cssfilename_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_fontsize = this.con_.getProjectValue("project/environment/preference/@fontsize")))) {
            this.addParam4Init(init, "fontsize", this.convFontsizeValue(display_fontsize));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_fontsize_selectable = this.con_.getProjectValue("project/environment/preference/@fontsize_2")))) {
            this.addParam4Init(init, "fontsize_selectable", this.convSelectableValue(display_fontsize_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_menuicon = this.con_.getProjectValue("project/environment/preference/@menuicon")))) {
            this.addParam4Init(init, "display_menuicon", this.convDisplayableValue(display_menuicon));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_menuicon_selectable = this.con_.getProjectValue("project/environment/preference/@menuicon_2")))) {
            this.addParam4Init(init, "display_menuicon_selectable", this.convSelectableValue(display_menuicon_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_helpicon = this.con_.getProjectValue("project/environment/preference/@helpicon")))) {
            this.addParam4Init(init, "display_helpicon", this.convDisplayableValue(display_helpicon));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_helpicon_selectable = this.con_.getProjectValue("project/environment/preference/@helpicon_2")))) {
            this.addParam4Init(init, "display_helpicon_selectable", this.convSelectableValue(display_helpicon_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_logofficon = this.con_.getProjectValue("project/environment/preference/@logofficon")))) {
            this.addParam4Init(init, "display_logofficon", this.convDisplayableValue(display_logofficon));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_logofficon_selectable = this.con_.getProjectValue("project/environment/preference/@logofficon_2")))) {
            this.addParam4Init(init, "display_logofficon_selectable", this.convSelectableValue(display_logofficon_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_globallink = this.con_.getProjectValue("project/environment/preference/@globallink")))) {
            this.addParam4Init(init, "display_globallink", this.convDisplayableValue(display_globallink));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_globallink_selectable = this.con_.getProjectValue("project/environment/preference/@globallink_2")))) {
            this.addParam4Init(init, "display_globallink_selectable", this.convSelectableValue(display_globallink_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_submenu = this.con_.getProjectValue("project/environment/preference/@submenu")))) {
            this.addParam4Init(init, "display_submenu", this.convDisplayableValue(display_submenu));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_submenu_selectable = this.con_.getProjectValue("project/environment/preference/@submenu_2")))) {
            this.addParam4Init(init, "display_submenu_selectable", this.convSelectableValue(display_submenu_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(submenu_position = this.con_.getProjectValue("project/environment/preference/@submenu_position")))) {
            this.addParam4Init(init, "submenu_position", submenu_position);
        }
        if (StringUtils.isNotBlank((CharSequence)(display_submenu_position_selectable = this.con_.getProjectValue("project/environment/preference/@submenu_position_2")))) {
            this.addParam4Init(init, "submenu_position_selectable", this.convSelectableValue(display_submenu_position_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(calendarFirstDayOfWeek = this.con_.getProjectValue("project/environment/preference/@calendarFirstDayOfWeek")))) {
            this.addParam4Init(init, "calendarFirstDayOfWeek", calendarFirstDayOfWeek);
        }
        if (StringUtils.isNotBlank((CharSequence)(display_calendarFirstDayOfWeek_selectable = this.con_.getProjectValue("project/environment/preference/@calendarFirstDayOfWeek_2")))) {
            this.addParam4Init(init, "calendarFirstDayOfWeek_selectable", this.convSelectableValue(display_calendarFirstDayOfWeek_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_pankuzu = this.con_.getProjectValue("project/environment/preference/@pankuzu")))) {
            this.addParam4Init(init, "display_pankuzu", this.convDisplayableValue(display_pankuzu));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_pankuzu_selectable = this.con_.getProjectValue("project/environment/preference/@pankuzu_2")))) {
            this.addParam4Init(init, "display_pankuzu_selectable", this.convSelectableValue(display_pankuzu_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_bottomarea = this.con_.getProjectValue("project/environment/preference/@bottomarea")))) {
            this.addParam4Init(init, "display_bottomarea", this.convDisplayableValue(display_bottomarea));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_bottomarea_selectable = this.con_.getProjectValue("project/environment/preference/@bottomarea_2")))) {
            this.addParam4Init(init, "display_bottomarea_selectable", this.convSelectableValue(display_bottomarea_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_passwordReminder = this.con_.getProjectValue("project/environment/preference/@remindPassword")))) {
            this.addParam4Init(init, "display_passwordReminder", this.convUsableValue(display_passwordReminder));
        }
        if (StringUtils.isNotBlank((CharSequence)(display_passwordReminder_selectable = this.con_.getProjectValue("project/environment/preference/@remindPassword_2")))) {
            this.addParam4Init(init, "display_passwordReminder_selectable", this.convSelectableValue(display_passwordReminder_selectable));
        }
        if ("USE".equals(passwordReminder = StringUtil.getValueAsNormalizedAlphabet((String)this.con_.getProjectValue("project/environment/@remind_password"))) || "USESQL".equals(passwordReminder)) {
            this.addParam4Init(init, "passwordReminder", passwordReminder);
            this.addParam4Init(init, "passwordReminder_selectable", "true");
            env.setRemindPassword(passwordReminder);
        }
        if (StringUtils.isNotBlank((CharSequence)(language_selectable = this.con_.getProjectValue("project/environment/preference/@language_2")))) {
            this.addParam4Init(init, "language_selectable", this.convSelectableValue(language_selectable));
        }
        if (StringUtils.isNotBlank((CharSequence)(_inet_fontsize = this.con_.getProjectValue("project/environment/defaultlogon/@fontsize")))) {
            this.addParam4Init(init, "display_fontsize_as_inetuser", this.convDisplayableValue(_inet_fontsize));
        }
        if (StringUtils.isNotBlank((CharSequence)(_inet_menuicon = this.con_.getProjectValue("project/environment/defaultlogon/@menuicon")))) {
            this.addParam4Init(init, "display_menuicon_as_inetuser", this.convDisplayableValue(_inet_menuicon));
        }
        if (StringUtils.isNotBlank((CharSequence)(_inet_helpicon = this.con_.getProjectValue("project/environment/defaultlogon/@helpicon")))) {
            this.addParam4Init(init, "display_helpicon_as_inetuser", this.convDisplayableValue(_inet_helpicon));
        }
        if (StringUtils.isNotBlank((CharSequence)(_inet_logoficon = this.con_.getProjectValue("project/environment/defaultlogon/@logofficon")))) {
            this.addParam4Init(init, "display_logofficon_as_inetuser", this.convDisplayableValue(_inet_logoficon));
        }
        if (StringUtils.isNotBlank((CharSequence)(_inet_submenu = this.con_.getProjectValue("project/environment/defaultlogon/@submenu")))) {
            this.addParam4Init(init, "display_submenu_as_inetuser", this.convDisplayableValue(_inet_submenu));
        }
        if (StringUtils.isNotBlank((CharSequence)(_inet_pankuzu = this.con_.getProjectValue("project/environment/defaultlogon/@pankuzu")))) {
            this.addParam4Init(init, "display_pankuzu_as_inetuser", this.convDisplayableValue(_inet_pankuzu));
        }
        if (StringUtils.isNotBlank((CharSequence)(_inet_sidebar = this.con_.getProjectValue("project/environment/defaultlogon/@sidebar")))) {
            this.addParam4Init(init, "display_sidebar_as_inetuser", this.convDisplayableValue(_inet_sidebar));
        }
        if (StringUtils.isNotBlank((CharSequence)(_inet_bottomarea = this.con_.getProjectValue("project/environment/defaultlogon/@bottomarea")))) {
            this.addParam4Init(init, "display_bottomarea_as_inetuser", this.convDisplayableValue(_inet_bottomarea));
        }
        if (StringUtils.isNotBlank((CharSequence)(_icsfilename = this.con_.getProjectValue("project/environment/@icsfilename")))) {
            this.addParam4Init(init, "icsfilename", _icsfilename);
        } else {
            this.addParam4Init(init, "icsfilename", "JapanHolidays.ics");
        }
        env.addContent((IEnvironmentChoice)init);
    }

    private String convFontsizeValue(String s) {
        if (ropt.getValue("OPTION_project_environment_preference_fontsize_1_value").equals(s)) {
            return "small";
        }
        if (ropt.getValue("OPTION_project_environment_preference_fontsize_2_value").equals(s)) {
            return "middle";
        }
        if (ropt.getValue("OPTION_project_environment_preference_fontsize_3_value").equals(s)) {
            return "large";
        }
        return "middle";
    }

    private String convDisplayableValue(String s) {
        if (ropt.getValue("OPTION_project_environment_preference_DisplayNone_1_value").equals(s)) {
            return "true";
        }
        return "false";
    }

    private String convSelectableValue(String s) {
        if (ropt.getValue("OPTION_project_environment_preference_AllowNone_1_value").equals(s)) {
            return "true";
        }
        return "false";
    }

    private String convUsableValue(String s) {
        if (ropt.getValue("OPTION_project_environment_preference_AvailNone_1_value").equals(s)) {
            return "true";
        }
        return "false";
    }

    private void addParam4Init(Init init, String key, String value) {
        Param param = new Param();
        param.setKey(key);
        param.setValue(value);
        init.addParam(param);
    }

    private void setDefaultlogon(Environment env) {
        String _defaultlongon = this.con_.getProjectValue("project/environment/defaultlogon");
        String _defaultlogon_userid = this.con_.getProjectValue("project/environment/defaultlogon/@userid");
        String _defaultlogon_password = this.con_.getProjectValue("project/environment/defaultlogon/@password");
        if (StringUtils.isBlank((CharSequence)_defaultlongon)) {
            return;
        }
        Defaultlogon defaultlogon = new Defaultlogon();
        if (StringUtils.isNotBlank((CharSequence)_defaultlogon_userid)) {
            defaultlogon.setUserid(_defaultlogon_userid);
        }
        if (StringUtils.isNotBlank((CharSequence)_defaultlogon_password)) {
            defaultlogon.setPassword(_defaultlogon_password);
        }
        env.addContent((IEnvironmentChoice)defaultlogon);
    }

    private void setInitLoader(Environment env, Project project) {
        Initloader loader = new Initloader();
        loader.setConfigPath("conf/initdb.xml");
        loader.setExportDirectoryPrefix("data_");
        Object initloader_basepath = null;
        initloader_basepath = "ROOT".equals(Utils.getDeployname(project)) ? "../webapps/ROOT/WEB-INF/export" : "../webapps/" + project.getWebappname() + "/WEB-INF/export";
        loader.setBasePath((String)initloader_basepath);
        String initloader_exportparentpath = this.con_.getProjectValue("project/environment/initloader/@exportParentPath");
        if (StringUtils.isBlank((CharSequence)initloader_exportparentpath)) {
            initloader_exportparentpath = "../../export";
        }
        loader.setExportParentPath(initloader_exportparentpath);
        loader.setImportParentPath(initloader_exportparentpath);
        env.addContent((IEnvironmentChoice)loader);
    }

    private void setAnorm(Environment env) {
        if (!Utils.isZipcodetype(this.con_)) {
            return;
        }
        Anormlib anormlib = new Anormlib();
        String anormVersion = this.con_.getProjectValue("project/customize/@anormversion");
        if ("R4".equals(anormVersion)) {
            anormlib.setType("horb");
            anormlib.setHorburl("horb://localhost:9001");
        } else if ("R5".equals(anormVersion)) {
            anormlib.setType("rmi");
            anormlib.setUrl("//localhost/Normalizer");
        } else if ("R5(JSON)".equals(anormVersion) || "R6(JSON)".equals(anormVersion)) {
            anormlib.setType("json");
            String anormServer = this.con_.getProjectValue("project/customize/@anormserver");
            if (StringUtils.isNotBlank((CharSequence)anormServer)) {
                anormlib.setUrl(anormServer);
            } else {
                anormlib.setUrl("http://localhost:8080/anorm/v1/anorm");
            }
        } else {
            anormlib.setType("jar");
        }
        env.addContent((IEnvironmentChoice)anormlib);
    }

    private void setDatabase(Environment env, Project project) {
        boolean isAutoScaling;
        String dbtype = this.con_.getProjectValue("project/environment/database/@database");
        String url = this.con_.getProjectValue("project/environment/database/@url");
        String user = this.con_.getProjectValue("project/environment/database/@user");
        String password = this.con_.getProjectValue("project/environment/database/@password");
        String quoteidtype = this.con_.getProjectValue("project/environment/database/@quoteidtype");
        String autoreconnect = this.con_.getProjectValue("project/environment/database/@autoreconnect");
        String maxactive = this.con_.getProjectValue("project/environment/database/@maxactive");
        String maxidle = this.con_.getProjectValue("project/environment/database/@maxidle");
        String maxwait = this.con_.getProjectValue("project/environment/database/@maxwait");
        String charencoding = this.con_.getProjectValue("project/environment/database/@charencoding");
        String schema = this.con_.getProjectValue("project/environment/database/@schema");
        boolean columnDefault = Utils.isSelectedValue(this.con_.getProjectValue("project/environment/database/@columnDefault"));
        boolean encryptopassword = Utils.isSelectedValue(this.con_.getProjectValue("project/environment/database/@encryptopassword"));
        if (StringUtils.isBlank((CharSequence)charencoding)) {
            charencoding = "UTF-8";
        }
        Database database = this.database(dbtype, url, user, password, quoteidtype, autoreconnect, maxactive, maxidle, maxwait, charencoding, schema, columnDefault, encryptopassword, project);
        String enableQuartzJDBCJobstore = this.con_.getProjectValue("project/environment/database/@enableQuartzJDBCJobstore");
        boolean bl = isAutoScaling = Utils.isAutoScaling(this.con_) || Utils.isMicroservice(this.con_);
        if (StringUtils.isNotBlank((CharSequence)enableQuartzJDBCJobstore) || isAutoScaling) {
            this.addQuartzJDBCJobstore(database);
        }
        this.addSchemaMigration(database);
        this.addDefaultRdbdatatype(database);
        env.addContent((IEnvironmentChoice)database);
        this.setSubdatabase(env, project);
    }

    protected void addSchemaMigration(Database database) {
        String nndatetime;
        String nntime;
        String nndate;
        String nndouble;
        String nnfloat;
        String nnlong;
        String nnint;
        String nnshort;
        String nnbyte;
        SchemaMigration schemaMigration = new SchemaMigration();
        String nnstring = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@string");
        if (StringUtils.isNotEmpty((CharSequence)nnstring)) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("string");
            nnd.setContent(nnstring);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nnbyte = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@byte")))) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("byte");
            nnd.setContent(nnbyte);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nnshort = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@short")))) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("short");
            nnd.setContent(nnshort);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nnint = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@int")))) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("int");
            nnd.setContent(nnint);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nnlong = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@long")))) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("long");
            nnd.setContent(nnlong);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nnfloat = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@float")))) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("float");
            nnd.setContent(nnfloat);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nndouble = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@double")))) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("double");
            nnd.setContent(nndouble);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nndate = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@date")))) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("date");
            nnd.setContent(nndate);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nntime = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@time")))) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("time");
            nnd.setContent(nntime);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nndatetime = this.con_.getProjectValue("project/environment/database/schema_migration/notnull/default/@datetime")))) {
            Notnulldefault nnd = new Notnulldefault();
            nnd.setType("datetime");
            nnd.setContent(nndatetime);
            schemaMigration.addNotnulldefault(nnd);
        }
        if (schemaMigration.sizeNotnulldefault() > 0) {
            database.setSchemaMigration(schemaMigration);
        }
    }

    protected void addDefaultRdbdatatype(Database database) {
        Rdbtypemap rinfo;
        RdbSetting rdbsetting = new RdbSetting();
        String defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@string");
        if (StringUtils.isNotEmpty((CharSequence)defaulttype)) {
            rinfo = new Rdbtypemap();
            rinfo.setType("string");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
            rinfo = new Rdbtypemap();
            rinfo.setType("special-mailaddress");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
            rinfo = new Rdbtypemap();
            rinfo.setType("special-url");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
            rinfo = new Rdbtypemap();
            rinfo.setType("special-filename");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
            rinfo = new Rdbtypemap();
            rinfo.setType("special-fixed-init-userid");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
            rinfo = new Rdbtypemap();
            rinfo.setType("special-fixed-update-userid");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@byte")))) {
            rinfo = new Rdbtypemap();
            rinfo.setType("byte");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@short")))) {
            rinfo = new Rdbtypemap();
            rinfo.setType("short");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@int")))) {
            rinfo = new Rdbtypemap();
            rinfo.setType("int");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@long")))) {
            rinfo = new Rdbtypemap();
            rinfo.setType("long");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@float")))) {
            rinfo = new Rdbtypemap();
            rinfo.setType("float");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@double")))) {
            rinfo = new Rdbtypemap();
            rinfo.setType("double");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@date")))) {
            rinfo = new Rdbtypemap();
            rinfo.setType("date");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@time")))) {
            rinfo = new Rdbtypemap();
            rinfo.setType("time");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaulttype = this.con_.getProjectValue("project/environment/database/rdb_setting/mapping/@datetime")))) {
            rinfo = new Rdbtypemap();
            rinfo.setType("dateTime");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
            rinfo = new Rdbtypemap();
            rinfo.setType("special-fixed-init-dateTime");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
            rinfo = new Rdbtypemap();
            rinfo.setType("special-fixed-update-dateTime");
            rinfo.setContent(defaulttype);
            rdbsetting.addRdbtypemap(rinfo);
        }
        if (rdbsetting.sizeRdbtypemap() > 0) {
            database.setRdbSetting(rdbsetting);
        }
    }

    protected void setSubdatabase(Environment env, Project project) {
        ArrayList<Database> list = new ArrayList<Database>();
        for (int i = 2; i <= 11; ++i) {
            String dbtype = this.con_.getProjectValue("project/environment/subdatabase/database/@database" + i);
            String url = this.con_.getProjectValue("project/environment/subdatabase/database/@url" + i);
            String user = this.con_.getProjectValue("project/environment/subdatabase/database/@user" + i);
            String password = this.con_.getProjectValue("project/environment/subdatabase/database/@password" + i);
            String quoteidtype = this.con_.getProjectValue("project/environment/subdatabase/database/@quoteidtype" + i);
            String autoreconnect = this.con_.getProjectValue("project/environment/subdatabase/database/@autoreconnect" + i);
            String maxactive = this.con_.getProjectValue("project/environment/subdatabase/database/@maxactive" + i);
            String maxidle = this.con_.getProjectValue("project/environment/subdatabase/database/@maxidle" + i);
            String maxwait = this.con_.getProjectValue("project/environment/subdatabase/database/@maxwait" + i);
            String charencoding = this.con_.getProjectValue("project/environment/subdatabase/database/@charencoding" + i);
            String schema = this.con_.getProjectValue("project/environment/subdatabase/database/@schema" + i);
            boolean columnDefault = Utils.isSelectedValue(this.con_.getProjectValue("project/environment/database/@columnDefault" + i));
            boolean encryptopassword = Utils.isSelectedValue(this.con_.getProjectValue("project/environment/database/@encryptopassword" + i));
            if (StringUtils.isBlank((CharSequence)dbtype)) continue;
            Database database = this.database(dbtype, url, user, password, quoteidtype, autoreconnect, maxactive, maxidle, maxwait, charencoding, schema, columnDefault, encryptopassword, project);
            database.setName(SUBDATABASE_RESOURCENAME_PREFIX + i);
            database.setSessionFactory("sessionFactory" + i);
            database.setTransactionManager("transactionManager" + i);
            list.add(database);
        }
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Subdatabase subdatabase = new Subdatabase();
        subdatabase.addDatabase(list.toArray(new Database[list.size()]));
        env.addContent((IEnvironmentChoice)subdatabase);
    }

    protected Database database(String database_type, String database_url, String database_user, String database_password, String database_quoteidtype, String database_autoreconnect, String database_maxactive, String database_maxidle, String database_maxwait, String database_charencoding, String schema, boolean columnDefault, boolean encryptopassword, Project project) {
        if (StringUtils.isBlank((CharSequence)database_type)) {
            database_type = "hsqldb";
        }
        if ("hsqldb".equals(database_type = RepositoryManagerUtil.checkOldExpression(database_type, this.log))) {
            String deploy_name = Utils.getDeployname(project);
            StringBuilder sb = new StringBuilder();
            sb.append("jdbc:hsqldb:file:${catalina.home}/webapps/");
            sb.append(deploy_name);
            sb.append("/WEB-INF/data/");
            sb.append(deploy_name);
            sb.append("db");
            database_url = sb.toString();
            database_user = "sa";
            database_password = "";
        }
        Database database = new Database();
        database.setType(database_type);
        if (StringUtils.isBlank((CharSequence)database_maxactive)) {
            database_maxactive = "24";
        }
        database.setMaxActiveByString(database_maxactive);
        if (StringUtils.isBlank((CharSequence)database_maxidle)) {
            database_maxidle = "8";
        }
        database.setMaxIdleByString(database_maxidle);
        if (StringUtils.isBlank((CharSequence)database_maxwait)) {
            database_maxwait = "2000";
        }
        database.setMaxWaitByString(database_maxwait);
        database.setJdbc2(true);
        database.setCharencoding(database_charencoding);
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            database.setHibernateSchema(schema);
        }
        database.setUrl(database_url);
        database.setUser(database_user);
        database.setPassword(database_password);
        if (StringUtils.isEmpty((CharSequence)database_user)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.database"));
        }
        if (Utils.isSelectedValue(database_autoreconnect)) {
            database.setAutoReconnect(true);
        }
        database.setDriver(this.getDbsetting(database_type, ".driver"));
        database.setQuoteid(this.getDbsetting(database_type, ".quoteid"));
        database.setQuotewhere(this.getDbsetting(database_type, ".quotewhere"));
        database.setQuoteidinwhere(this.getDbsetting(database_type, ".quoteidinwhere"));
        database.setQuoteidForHibernate(this.getDbsetting(database_type, ".quoteidforhibernate"));
        String v = this.getDbsetting(database_type, ".tablenameseparatorforhibernate");
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "$";
        }
        database.setTablenameSeparatorForHibernate(v);
        v = this.getDbsetting(database_type, ".hibernateDialect");
        if (StringUtils.isNotBlank((CharSequence)v)) {
            database.setHibernateDialect(v);
        } else {
            this.log.error("Hibernate Dialect is null, key=" + database_type + ".hibernateDialect");
        }
        v = this.getDbsetting(database_type, ".maxTablenameLength");
        if (StringUtils.isNotBlank((CharSequence)v)) {
            database.setMaxTablenameLengthByString(v);
        }
        if (StringUtils.isNotBlank((CharSequence)(v = this.getDbsetting(database_type, ".maxIndexnameLength")))) {
            database.setMaxIndexnameLengthByString(v);
        }
        if (StringUtils.isNotBlank((CharSequence)(v = this.getDbsetting(database_type, ".maxColumnnameLength")))) {
            database.setMaxColumnnameLengthByString(v);
        }
        if (StringUtils.isNotBlank((CharSequence)(v = this.getDbsetting(database_type, ".maxLengthStringDataType")))) {
            database.setMaxLengthStringDataTypeByString(v);
        }
        if (StringUtils.isNotBlank((CharSequence)(v = this.getDbsetting(database_type, ".characterLargeObjectDataType")))) {
            database.setCharacterLargeObjectDataType(v);
        }
        if (StringUtils.isNotBlank((CharSequence)(v = this.getDbsetting(database_type, ".supportTimeDataType")))) {
            database.setSupportTimeDataTypeByString(v);
        }
        database.setSearchStringEscapeInLike(this.getDbsetting(database_type, ".searchStringEscapeInLike"));
        database.setCreateSequenceDDL(this.getDbsetting(database_type, ".createSequenceDDL"));
        database.setSequenceDML(this.getDbsetting(database_type, ".sequenceDML"));
        database.setDropIndexDDL(this.getDbsetting(database_type, ".dropIndexDDL"));
        database.setSpringBatchDDL(this.getDbsetting(database_type, ".springBatchDDL"));
        v = this.getDbsetting(database_type, ".masterDDL");
        if (StringUtils.isNotBlank((CharSequence)v)) {
            database.setMasterDDL(v);
        } else {
            this.log.error("JDBC Master DDL is null, key=" + database_type + ".masterDDL");
        }
        database.setValidationQuery(this.getDbsetting(database_type, ".validationQuery"));
        database.setConnectionInitSqls(this.getDbsetting(database_type, ".connectionInitSqls"));
        v = this.getDbsetting(database_type, ".version");
        if (StringUtils.isNotBlank((CharSequence)v)) {
            database.setVersion(v);
        }
        if (columnDefault) {
            database.setColumnDefault(true);
        }
        if (encryptopassword) {
            database.setEncryptopassword(encryptopassword);
        }
        database.setDropSequenceDDL(this.getDbsetting(database_type, ".dropSequenceDDL"));
        database.setCreateIndexDDL(this.getDbsetting(database_type, ".createIndexDDL"));
        database.setJfcworkstateDropIndexDDL(this.getDbsetting(database_type, ".jfcworkstateDropIndexDDL"));
        database.setJfcworkstateCreateIndexDDL(this.getDbsetting(database_type, ".jfcworkstateCreateIndexDDL"));
        if (!"hsqldb".equals(database_type) && ropt.getValue("OPTION_project_environment_database_quoteidtype_2_value").equals(database_quoteidtype)) {
            database.setQuoteid("");
            database.setQuotewhere("");
            database.setQuoteidinwhere("");
            database.setQuoteidForHibernate("");
        }
        return database;
    }

    private String getDbsetting(String database_type, String key) {
        String value = RepositoryManagerUtil.dbSettings.get(database_type + key);
        if (value == null) {
            value = RepositoryManagerUtil.dbSettings.get("default" + key);
        }
        if (value == null && DbTypeManager.isDatabaseType((String)database_type, (String)"mysql")) {
            value = DEFAULT_MYSQL_DBSETTING_MAP.get(key);
        }
        if (value == null) {
            value = DEFAULT_DBSETTING_MAP.get(key);
        }
        return value;
    }

    private void addQuartzJDBCJobstore(Database database) {
        String database_type = database.getType();
        String enableQuartzJDBCStore = this.getDbsetting(database_type, ".quartzJDBCJobstoreEnabled");
        if (Boolean.valueOf(enableQuartzJDBCStore).booleanValue()) {
            String ddl = this.getDbsetting(database_type, ".quartzJDBCJobstoreDDL");
            String driverDelegateClass = this.getDbsetting(database_type, ".quartzJDBCJobstoreDriverDelegateClass");
            QuartzJDBCJobstore qjj = new QuartzJDBCJobstore();
            qjj.setDdl(ddl);
            qjj.setDriverDelegateClass(driverDelegateClass);
            SpringApplicationContextGenerator.JFCQuartzJobManagerClass c = Utils.isMicroservice(this.con_) ? SpringApplicationContextGenerator.JFCQuartzJobManagerClass.V1MSA : SpringApplicationContextGenerator.JFCQuartzJobManagerClass.V1;
            qjj.setJFCQuartzJobManagerType(c.getClassname());
            database.setQuartzJDBCJobstore(qjj);
        } else {
            this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.addQuartzJDBCJobstore.IllegalDatabaseType"));
        }
    }

    private void setCacheinfo(Environment env) {
        Cacheinfo cacheinfo = new Cacheinfo();
        cacheinfo.setType("slim");
        String maxBytesLocalHeap = this.con_.getProjectValue("project/environment/cacheinfo/@maxBytesLocalHeap");
        if (StringUtils.isNotBlank((CharSequence)maxBytesLocalHeap)) {
            cacheinfo.setMaxBytesLocalHeap(maxBytesLocalHeap);
        }
        this.setReplication(cacheinfo);
        env.addContent((IEnvironmentChoice)cacheinfo);
    }

    protected void setReplication(Cacheinfo cacheinfo) {
        if (!Utils.isAutoScaling(this.con_) && !Utils.isMicroservice(this.con_)) {
            return;
        }
        if (!"broker".equals(this.getActivemqSendDest())) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setReplication.ActivemqSendDestTypeIsNotBroker"));
            return;
        }
        Activemq activemq = new Activemq();
        activemq.setProviderURL(this.getActivemqBrokerURL());
        activemq.setUserName(this.getActivemqUser());
        activemq.setPassword(this.getActivemqPassword());
        Replication replication = new Replication();
        replication.setActivemq(activemq);
        cacheinfo.setReplication(replication);
    }

    private void setTomcatOption(Environment env) {
        StringBuilder sb = new StringBuilder();
        String opt = this.con_.getProjectValue("project/tomcat/@option");
        if (StringUtils.isBlank((CharSequence)opt)) {
            sb.append(" -Dsun.nio.cs.map=x-windows-iso2022jp/ISO-2022-JP");
            sb.append(" -Duser.timezone=Asia/Tokyo");
        } else {
            sb.append(opt);
        }
        JavaVersion javaver = AppSchemaUtil.getJavaVersion((Environment)env);
        if (!javaver.atLeast(JavaVersion.JAVA_1_8)) {
            this.setTomcatOptionPermSize(env, sb);
        }
        if (!SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15)) {
            sb.append(" -Dnashorn.args=--no-deprecation-warning");
        }
        env.setTomcatOption(sb.toString());
    }

    private void setTomcatOptionPermSize(Environment env, StringBuilder sb) {
        String permsize;
        String value = env.getJvmMaxPermSize();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            sb.append(" -XX:MaxPermSize=");
            sb.append(value);
            sb.append("m");
        }
        if (StringUtils.isNotBlank((CharSequence)(permsize = this.con_.getProjectValue("project/tomcat/@PermSize")))) {
            sb.append(" -XX:PermSize=");
            sb.append(permsize);
            sb.append("m");
        }
    }

    private void setTomcatPortAndOtherInfo(Environment env, Project project) {
        String tomcatCacheTtl;
        String tomcatCacheMaxSize;
        String tomcatMaxPostSize;
        String tomcatMaxParameterCount;
        String tomcatMaxHttpHeaderSize;
        String tomcatredirectport;
        String tomcatservershutdown;
        String tomcatserverport;
        String tomcatajp13secret;
        String tomcatajp13port;
        String tomcathttpport = this.con_.getProjectValue("project/tomcat/@tomcathttpport");
        if (StringUtils.isNotBlank((CharSequence)tomcathttpport)) {
            env.setTomcatHttpPort(tomcathttpport);
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatajp13port = this.con_.getProjectValue("project/tomcat/@tomcatajp13port")))) {
            env.setTomcatAJP13Port(tomcatajp13port);
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatajp13secret = this.con_.getProjectValue("project/tomcat/@tomcatajp13secret")))) {
            env.setTomcatAJP13Secret(tomcatajp13secret);
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatserverport = this.con_.getProjectValue("project/tomcat/@tomcatserverport")))) {
            env.setTomcatServerPort(tomcatserverport);
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatservershutdown = this.con_.getProjectValue("project/tomcat/@tomcatservershutdown")))) {
            env.setTomcatServerShutdown(tomcatservershutdown);
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatredirectport = this.con_.getProjectValue("project/tomcat/@tomcatredirectport")))) {
            env.setTomcatRedirectPort(tomcatredirectport);
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatMaxHttpHeaderSize = this.con_.getProjectValue("project/tomcat/@maxHttpHeaderSize")))) {
            env.setTomcatMaxHttpHeaderSize(tomcatMaxHttpHeaderSize);
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatMaxParameterCount = this.con_.getProjectValue("project/tomcat/@maxParameterCount")))) {
            env.setTomcatMaxParameterCount(tomcatMaxParameterCount);
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatMaxPostSize = this.con_.getProjectValue("project/tomcat/@maxPostSize")))) {
            env.setTomcatMaxPostSize(tomcatMaxPostSize);
        }
        boolean isROOTdeployment = false;
        String webappname = project.getWebappname();
        if (StringUtils.isBlank((CharSequence)webappname)) {
            isROOTdeployment = true;
        }
        env.setIsROOTdeployment(isROOTdeployment);
        String checkClientSessionId = this.con_.getProjectValue("project/tomcat/@checkClientSessionId");
        if (StringUtils.isNotBlank((CharSequence)checkClientSessionId)) {
            env.setCheckClientSessionId(Boolean.parseBoolean(checkClientSessionId));
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatCacheMaxSize = this.con_.getProjectValue("project/tomcat/@cacheMaxSize")))) {
            env.setTomcatCacheMaxSize(tomcatCacheMaxSize);
        }
        if (StringUtils.isNotBlank((CharSequence)(tomcatCacheTtl = this.con_.getProjectValue("project/tomcat/@cacheTtl")))) {
            env.setTomcatCacheTtl(tomcatCacheTtl);
        }
    }

    private void setTomcatMem(Environment env) {
        int msmemi = -1;
        String msmem = this.con_.getProjectValue("project/tomcat/@msmem");
        if (StringUtils.isNotBlank((CharSequence)msmem)) {
            try {
                msmemi = Integer.parseInt(msmem);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (msmemi >= 0) {
                env.setMsmem(Integer.toString(msmemi));
            } else {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.msmem"));
            }
        }
        int mxmemi = -1;
        String mxmem = this.con_.getProjectValue("project/tomcat/@mxmem");
        if (StringUtils.isNotBlank((CharSequence)mxmem)) {
            try {
                mxmemi = Integer.parseInt(mxmem);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (mxmemi > 0) {
                env.setMxmem(Integer.toString(mxmemi));
            } else {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.mxmem"));
            }
        }
        if (msmemi >= 0 && mxmemi > 0 && mxmemi < msmemi) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.msmemIsLargerThanMxmem"));
        }
        double maxrampercent = -1.0;
        String maxRAMPercentage = this.con_.getProjectValue("project/tomcat/@maxRAMPercentage");
        if (StringUtils.isNotBlank((CharSequence)maxRAMPercentage)) {
            try {
                maxrampercent = Double.parseDouble(maxRAMPercentage);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (maxrampercent > 0.0 && maxrampercent < 100.0) {
                env.setMaxRAMPercentage(maxrampercent);
            } else {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.maxRAMPercentage"));
            }
        }
        double initrampercent = -1.0;
        String initialRAMPercentage = this.con_.getProjectValue("project/tomcat/@initialRAMPercentage");
        if (StringUtils.isNotBlank((CharSequence)initialRAMPercentage)) {
            try {
                initrampercent = Double.parseDouble(initialRAMPercentage);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (initrampercent >= 0.0 && initrampercent < 100.0) {
                env.setInitialRAMPercentage(initrampercent);
            } else {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.initialRAMPercentage"));
            }
        }
        if (maxrampercent > 0.0 && initrampercent >= 0.0 && maxrampercent < initrampercent) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.initialRAMPercentageIsLargerThanMax"));
        }
    }

    private void setTomcatdirAndPac(Environment env) {
        String[] lists;
        String tomcatfilename = null;
        File currentDirectory = new File(JFCAppGenerator.envDir());
        for (String s : lists = currentDirectory.list()) {
            if (!s.startsWith("apache-tomcat-") || tomcatfilename != null && tomcatfilename.length() <= s.length()) continue;
            tomcatfilename = s;
        }
        if (tomcatfilename == null) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setTomcatdirAndPac"));
            return;
        }
        tomcatfilename = this.removeExt(tomcatfilename);
        env.setTomcatdir(tomcatfilename);
        env.setTomcatpac(tomcatfilename);
        String version = tomcatfilename.substring("apache-tomcat-".length());
        version = version.substring(0, version.indexOf("."));
        int version_ = NumberUtils.toInt((String)version);
        if (version_ < 7) {
            version = "8";
        }
        env.setTomcat(version);
    }

    private void setDojodirAndPac(Environment env) {
        String[] lists;
        String dojofilename = null;
        File currentDirectory = new File(JFCAppGenerator.envDir());
        for (String s : lists = currentDirectory.list()) {
            if (!s.startsWith("dojo-")) continue;
            dojofilename = s;
            break;
        }
        if (dojofilename == null) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setDojodirAndPac"));
            return;
        }
        dojofilename = this.removeExt(dojofilename);
        env.setDojoExtractDir(dojofilename);
        env.setDojopac(dojofilename);
        env.setDojoWebpageDir(dojofilename);
    }

    private String removeExt(String filename) {
        String[] exts;
        for (String ext : exts = new String[]{".zip", ".tar.gz"}) {
            if (!filename.endsWith(ext)) continue;
            filename = filename.substring(0, filename.length() - ext.length());
        }
        return filename;
    }

    private void setJvmMaxPermSize(Environment env) {
        JavaVersion javaver = AppSchemaUtil.getJavaVersion((Environment)env);
        String value = this.con_.getProjectValue("project/tomcat/@MaxPermSize");
        if (StringUtils.isNotBlank((CharSequence)value) && !javaver.atLeast(JavaVersion.JAVA_1_8)) {
            env.setJvmMaxPermSize(value);
        } else {
            env.setJvmMaxPermSize("");
        }
    }

    private void setJavadocMaxMemory(Environment env) {
        String value = this.con_.getProjectValue("project/environment/@javadocMaxMemory");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            env.setJavadocMaxMemory(value);
        }
    }

    private void setJavac(Environment env) {
        String value = this.con_.getProjectValue("project/environment/@javacMaxMemory");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            env.setJavacMaxMemory(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.con_.getProjectValue("project/environment/@javacTarget")))) {
            env.setJavacTarget(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.con_.getProjectValue("project/environment/@javacSource")))) {
            env.setJavacSource(value);
        }
    }

    private void setBrowserCacheMaxAge(Environment env) {
        String BrowserCacheMaxAgeKey = "project/environment/@browserCacheMaxAge";
        if (!this.con_.existsKeyInProject("project/environment/@browserCacheMaxAge")) {
            int num = 2678400;
            env.setBrowserCacheMaxAge(2678400);
            return;
        }
        String value = this.con_.getProjectValue("project/environment/@browserCacheMaxAge");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                int num = BEnvironment.getTimeRangeSeconds(value);
                env.setBrowserCacheMaxAge(num);
            }
            catch (IllegalArgumentException e) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setBrowserCacheMaxAge", new Object[]{value}));
            }
        }
    }

    public static int getTimeRangeSeconds(String value) throws IllegalArgumentException {
        Matcher mat = NumPattern.matcher(value);
        int seconds = 0;
        String numstr = null;
        block2: while (mat.find()) {
            int num;
            numstr = mat.group(1);
            try {
                if (numstr.startsWith("+")) {
                    numstr = numstr.substring(1);
                }
                num = Integer.parseInt(numstr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
            String range = mat.group(2).trim();
            if (range.equals("")) {
                seconds += num * TimeRanges[0].getSeconds();
                continue;
            }
            for (TimeRange timerange : TimeRanges) {
                if (!timerange.matches(range)) continue;
                seconds += num * timerange.getSeconds();
                continue block2;
            }
            throw new IllegalArgumentException();
        }
        if (numstr == null) {
            throw new IllegalArgumentException();
        }
        return seconds;
    }

    private void setChangeAjaxElement(Environment env) {
        String value;
        String ChangeAjaxElementKey = "project/environment/@change_ajax_element";
        if (this.con_.existsKeyInProject("project/environment/@change_ajax_element") && !StringUtils.isNotBlank((CharSequence)(value = this.con_.getProjectValue("project/environment/@change_ajax_element")))) {
            env.setChangeAjaxElement(false);
        }
    }

    private void setTextSearchAttirbute(Environment env) {
        String maxchar_per_data = this.con_.getProjectValue("project/environment/init/@textsearch_maxchar_per_data");
        if (StringUtils.isNotBlank((CharSequence)maxchar_per_data)) {
            try {
                int textsearchMaxcharPerData = Integer.parseInt(maxchar_per_data);
                if (textsearchMaxcharPerData > 0) {
                    env.setTextsearchMaxcharPerData(textsearchMaxcharPerData);
                }
            }
            catch (Exception e) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setTextSearchAttirbute", new Object[]{maxchar_per_data}));
            }
        }
        String text_extractor = this.con_.getProjectValue("project/environment/init/@textsearch_text_extractor");
        String textsearchTextExtractor = "SampleTextExtractor";
        if (StringUtils.isNotBlank((CharSequence)text_extractor)) {
            if (ropt.getValue("OPTION_project_environment_init_textsearch_text_extractor_1_value").equals(text_extractor)) {
                textsearchTextExtractor = "SampleTextExtractor";
            } else if ("Tika".equals(text_extractor)) {
                textsearchTextExtractor = "TikaTextExtractor";
            } else if ("xdoc2txt".equals(text_extractor)) {
                textsearchTextExtractor = "Xdoc2txtTextExtractor";
            } else if ("TextPorter".equals(text_extractor)) {
                textsearchTextExtractor = "TextPorterTextExtractor";
            }
        }
        if (textsearchTextExtractor != null) {
            env.setTextsearchTextExtractor(textsearchTextExtractor);
        }
    }

    protected void setSecurity(Environment env) {
        String oidcPropKey;
        Param param;
        String keyPrefix = "project/environment/security/param/";
        Security security = new Security();
        for (String key : this.con_.getProjectRepositoryAsMap().keySet()) {
            String value;
            if (StringUtils.isBlank((CharSequence)key) || !key.startsWith(keyPrefix) || StringUtils.isBlank((CharSequence)(value = this.con_.getProjectValue(key)))) continue;
            if (key.equals("project/environment/security/param/bcrypt/strength")) {
                if (!this.isBCrypt()) continue;
                if (!NumberUtils.isCreatable((String)value) || !Range.between((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(31)).contains((Object)NumberUtils.toInt((String)value))) {
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setSecurity.1", new Object[]{value}));
                    continue;
                }
            }
            String newKey = "wagby.security." + StringUtils.removeStart((String)key, (String)keyPrefix).replace("/", ".");
            Param param2 = new Param();
            param2.setKey(newKey);
            param2.setValue(value);
            security.addParam(param2);
        }
        String authenticationType = Utils.getAuthenticationType(this.con_);
        if (StringUtils.isNotBlank((CharSequence)authenticationType)) {
            param = new Param();
            param.setKey("wagby.security.authenticationType");
            if ("remote_user".equals(authenticationType)) {
                authenticationType = "requestRemoteUser";
            }
            param.setValue(authenticationType);
            security.addParam(param);
        }
        if (Utils.isAutoScaling(this.con_)) {
            param = new Param();
            param.setKey("wagby.redis.logonStatus");
            param.setValue("true");
            security.addParam(param);
        }
        if (StringUtils.isNotBlank((CharSequence)this.con_.getProjectValue(oidcPropKey = "project/environment/security/oidc/properties"))) {
            Properties props = PropertyUtils.loadQuietly((Reader)new StringReader(this.con_.getProjectValue(oidcPropKey)));
            for (Object key : props.keySet()) {
                Param param3 = new Param();
                param3.setKey(key.toString());
                param3.setValue(props.get(key).toString());
                security.addParam(param3);
            }
        }
        if (security.sizeParam() > 0) {
            env.addContent((IEnvironmentChoice)security);
        }
    }

    private boolean isBCrypt() {
        return this.isBCrypt(this.passwdHashAlgorithm());
    }

    private boolean isBCrypt(String passwdHashAlgorithm) {
        return "BCrypt".equalsIgnoreCase(this.passwdHashAlgorithm());
    }

    private String passwdHashAlgorithm() {
        return this.con_.getProjectValue("project/environment/user/@userinfo_passwd_digest_algorithm");
    }

    private void setMessageQueue(Environment env) {
        String default_connection_dest = this.con_.getProjectValue("project/environment/messageQueue/@default_connection_dest");
        boolean isRabbitMQ = Utils.isSelectedValue(this.con_.getProjectValue("project/environment/messageQueue/@enableJob"));
        boolean isActiveMQ = Utils.isSelectedValue(this.con_.getProjectValue("project/environment/messageQueue/@enableJob_activemq"));
        if (!isRabbitMQ && !isActiveMQ) {
            return;
        }
        MessageQueue mqRabbitMQ = null;
        if (isRabbitMQ) {
            mqRabbitMQ = this.createRabbitMQMessageQueue();
        }
        MessageQueue mqActiveMQ = null;
        if (isActiveMQ) {
            mqActiveMQ = this.createActiveMQMessageQueue();
        }
        if (mqRabbitMQ != null && mqActiveMQ != null) {
            if (default_connection_dest == null) {
                mqRabbitMQ.setPrimary(true);
            } else if (default_connection_dest.equalsIgnoreCase("RabbitMQ")) {
                mqRabbitMQ.setPrimary(true);
            } else if (default_connection_dest.equalsIgnoreCase("ActiveMQ")) {
                mqActiveMQ.setPrimary(true);
            } else {
                mqRabbitMQ.setPrimary(true);
            }
            env.addContent((IEnvironmentChoice)mqRabbitMQ);
            env.addContent((IEnvironmentChoice)mqActiveMQ);
        } else if (mqRabbitMQ != null) {
            mqRabbitMQ.setPrimary(true);
            env.addContent((IEnvironmentChoice)mqRabbitMQ);
        } else if (mqActiveMQ != null) {
            mqActiveMQ.setPrimary(true);
            env.addContent((IEnvironmentChoice)mqActiveMQ);
        }
    }

    private MessageQueue createRabbitMQMessageQueue() {
        String host = this.con_.getProjectValue("project/environment/messageQueue/@host");
        String port = this.con_.getProjectValue("project/environment/messageQueue/@port");
        String username = this.con_.getProjectValue("project/environment/messageQueue/@username");
        String password = this.con_.getProjectValue("project/environment/messageQueue/@password");
        String createQueues = this.con_.getProjectValue("project/environment/messageQueue/@createQueues");
        String listenQueues = this.con_.getProjectValue("project/environment/messageQueue/@listenJobQueues");
        MessageQueue mq = this.createMessageQueue(host, port, username, password, createQueues, listenQueues);
        mq.setType("RabbitMQ");
        return mq;
    }

    private String getActivemqSendDest() {
        return this.con_.getProjectValue("project/environment/messageQueue/@activemq_send_dest");
    }

    private String getActivemqBrokerURL() {
        return this.con_.getProjectValue("project/environment/messageQueue/@activemq_brokerurl");
    }

    private String getActivemqUser() {
        return this.con_.getProjectValue("project/environment/messageQueue/@activemq_user");
    }

    private String getActivemqPassword() {
        return this.con_.getProjectValue("project/environment/messageQueue/@activemq_password");
    }

    private MessageQueue createActiveMQMessageQueue() {
        String send_dest = this.getActivemqSendDest();
        boolean isBroker = false;
        if (send_dest.equals("broker")) {
            isBroker = true;
        }
        String host = this.getActivemqBrokerURL();
        String username = this.getActivemqUser();
        String password = this.getActivemqPassword();
        if (isBroker) {
            boolean isError = false;
            if (StringUtils.isBlank((CharSequence)host)) {
                this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setMessageQueue.require_activemq_brokerurl"));
                isError = true;
            }
            if (StringUtils.isBlank((CharSequence)username)) {
                this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setMessageQueue.require_activemq_user"));
                isError = true;
            }
            if (StringUtils.isBlank((CharSequence)password)) {
                this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setMessageQueue.require_activemq_password"));
                isError = true;
            }
            if (isError) {
                return null;
            }
        }
        String listenQueues = this.con_.getProjectValue("project/environment/messageQueue/@activemq_listenJobQueues");
        MessageQueue mq = this.createMessageQueue(host, null, username, password, null, listenQueues);
        mq.setType("ActiveMQ");
        Param param = new Param();
        param.setKey("send_dest");
        if (send_dest != null && (send_dest.equals("inmemory") || send_dest.equals("broker"))) {
            param.setValue(send_dest);
        } else {
            param.setValue("inmemory");
        }
        mq.addParam(param);
        return mq;
    }

    private MessageQueue createMessageQueue(String host, String port, String username, String password, String createQueues, String listenQueues) {
        MessageQueue messageQueue = new MessageQueue();
        messageQueue.setEnableJob(true);
        if (StringUtils.isNotBlank((CharSequence)host)) {
            messageQueue.setHost(host);
        }
        if (StringUtils.isNotBlank((CharSequence)username)) {
            messageQueue.setUsername(username);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            messageQueue.setPassword(password);
        }
        if (StringUtils.isNotBlank((CharSequence)port)) {
            try {
                messageQueue.setPort(Integer.parseInt(port));
            }
            catch (NumberFormatException e) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BEnvironment.setmessageQueue.illegalport", new Object[]{port}));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)createQueues)) {
            messageQueue.setCreateQueues(createQueues);
        }
        if (StringUtils.isNotBlank((CharSequence)listenQueues)) {
            messageQueue.setListenJobQueues(listenQueues);
        }
        return messageQueue;
    }

    private void setScript(Environment env) {
        String[] scripttypes;
        for (String scripttype : scripttypes = new String[]{"myfunction", "DownloadFile_beforeDownload", "UpdateFile_afterUpload", "userDefinedFilter1", "userDefinedFilter2", "userDefinedFilter3", "userDefinedFilter4", "userDefinedFilter5", "userDefinedFilter6", "userDefinedFilter7", "userDefinedFilter8", "userDefinedFilter9", "userDefinedFilter10", "startup", "logon", "logoff", "menu"}) {
            String js = this.con_.getProjectValue("project/environment/script/@type=" + scripttype);
            if (StringUtils.isBlank((CharSequence)js)) continue;
            Script script = new Script();
            script.setType(scripttype);
            script.setContent(js);
            env.addContent((IEnvironmentChoice)script);
        }
    }

    private void setJFCAppModeManager(Environment env) {
        if (!Utils.isAutoScaling(this.con_) && !Utils.isMicroservice(this.con_)) {
            env.setAppModeManagerType("single");
        } else {
            env.setAppModeManagerType("autoscale");
        }
    }

    private void setDomain(Environment env) {
        String id = Utils.getBuildDomain(this.con_);
        if (StringUtils.isNotBlank((CharSequence)id) && NumberUtils.isCreatable((String)id)) {
            env.setDomain(NumberUtils.toInt((String)id));
        }
    }

    private void setAwsConnectionInfo(Environment env) {
        String access_key = this.con_.getProjectValue("project/environment/aws_connect_info/@access_key");
        String secret_key = this.con_.getProjectValue("project/environment/aws_connect_info/@secret_key");
        String region = this.con_.getProjectValue("project/environment/aws_connect_info/@region");
        AwsConnectInfo aci = null;
        if (StringUtils.isNotBlank((CharSequence)access_key) && StringUtils.isNotBlank((CharSequence)secret_key)) {
            aci = new AwsConnectInfo();
            aci.setAccessKey(access_key);
            aci.setSecretKey(secret_key);
            if (StringUtils.isBlank((CharSequence)region)) {
                region = "ap-northeast-1";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)region)) {
            if (aci == null) {
                aci = new AwsConnectInfo();
            }
            aci.setRegion(region);
        }
        if (aci != null) {
            env.addContent((IEnvironmentChoice)aci);
        }
    }

    private void setFilestore(Environment env) {
        String type = this.con_.getProjectValue("project/environment/filestore/@type");
        if (StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        Filestore filestore = new Filestore();
        if (type.equals("file")) {
            filestore.setType(type);
        } else if (type.equals("s3") || type.equals("jfcfilestatus")) {
            filestore.setType(type);
            String s3bucket = this.con_.getProjectValue("project/environment/filestore/@s3bucket");
            if (StringUtils.isNotBlank((CharSequence)s3bucket)) {
                filestore.setS3bucket(s3bucket);
            } else {
                this.getMessageListener().info("If filestore type is " + type + ", you need the S3 bucket name.");
            }
            String s3folder = this.con_.getProjectValue("project/environment/filestore/@s3folder");
            if (StringUtils.isNotBlank((CharSequence)s3folder)) {
                filestore.setS3folder(s3folder);
            }
        } else {
            this.getMessageListener().error("Unknown filestore type " + type);
        }
        env.addContent((IEnvironmentChoice)filestore);
    }

    protected void setOpenapi(Environment env) {
        String keyPrefix = "project/environment/openapi/param/";
        Openapi openapi = new Openapi();
        this.con_.getProjectRepositoryAsMap().entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey()))).filter(entry -> ((String)entry.getKey()).startsWith(keyPrefix)).filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> {
            String newKey = StringUtils.removeStart((String)((String)entry.getKey()), (String)keyPrefix).replace("/", ".");
            Param param = new Param();
            param.setKey(newKey);
            param.setValue((String)entry.getValue());
            openapi.addParam(param);
        });
        if (openapi.sizeParam() > 0) {
            env.addContent((IEnvironmentChoice)openapi);
        }
    }

    private void setBeforeDeleteCheckOtherModelRef(Environment env) {
        String value = this.con_.getProjectValue("project/environment/@beforeDelete_checkOtherModelRef");
        if (Utils.isSelectedValue(value)) {
            env.setBeforeDeleteCheckOtherModelRef(true);
        }
    }

    public static void main(String[] arg) {
        System.out.println(BEnvironment.getTimeRangeSeconds("1"));
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(".dropSequenceDDL", "DROP SEQUENCE $QUOTEID$SEQNAME$QUOTEID");
        map.put(".createIndexDDL", "CREATE INDEX $QUOTEID$INDEXNAME$QUOTEID ON $QUOTEID$TABLENAME$QUOTEID ($QUOTEID$COLUMNNAME$QUOTEID)");
        DEFAULT_DBSETTING_MAP = map;
        map = new HashMap();
        map.put(".jfcworkstateDropIndexDDL", "ALTER TABLE $QUOTEID$TABLENAME$QUOTEID DROP INDEX $QUOTEID$INDEXNAME$QUOTEID");
        map.put(".jfcworkstateCreateIndexDDL", "CREATE INDEX $QUOTEID$INDEXNAME$QUOTEID ON $QUOTEID$TABLENAME$QUOTEID ($QUOTEIDmodelname$QUOTEID, $QUOTEIDmodelpkey$QUOTEID, $QUOTEIDevent$QUOTEID)");
        DEFAULT_MYSQL_DBSETTING_MAP = map;
        TimeRanges = new TimeRange[]{new TimeRange(rman.getValue("r.project.environment.timerange.day"), 86400), new TimeRange(rman.getValue("r.project.environment.timerange.sec"), 1), new TimeRange(rman.getValue("r.project.environment.timerange.min"), 60), new TimeRange(rman.getValue("r.project.environment.timerange.time"), 3600), new TimeRange(rman.getValue("r.project.environment.timerange.week"), 604800)};
        NumPattern = Pattern.compile("([+-]?[0-9]+)([^0-9+-]*)");
    }

    private static class TimeRange {
        private Pattern pat;
        private int seconds;

        TimeRange(String patstr, int seconds) {
            this.pat = Pattern.compile(patstr, 2);
            this.seconds = seconds;
        }

        boolean matches(String value) {
            return this.pat.matcher(value).matches();
        }

        int getSeconds() {
            return this.seconds;
        }
    }
}

