/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Embed;
import jp.jasminesoft.jfc.gen.appschema.HibernateParameterModelitem;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BModelBase;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="BJUserModel")
public class BJUserModel
extends BModelBase {
    protected Logger log = LogManager.getLogger(BJUserModel.class);

    @Override
    protected Logger getLog() {
        return this.log;
    }

    @Override
    public void process(Project project) {
        String modelId = "juser";
        String[] names = this.con_.getModelitemNames(modelId);
        if (names == null || names.length == 0) {
            this.log.fatal(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BModelBase.processModel", new Object[]{modelId}));
            return;
        }
        this.processModel(modelId, project);
        Model smodel = AppSchemaUtil.getModel((Project)project, (String)modelId);
        this.processStoreModel(smodel, project);
        Model pmodel = AppSchemaUtil.getModel((Project)project, (String)(modelId + "_p"));
        this.processPresentationModel(pmodel, project);
        Model lmodel = AppSchemaUtil.getModel((Project)project, (String)(modelId + "_l"));
        this.processListModel(lmodel, project);
        Model lpmodel = AppSchemaUtil.getModel((Project)project, (String)(modelId + "_lp"));
        this.processListPresentationModel(lpmodel, project);
        Model ulpmodel = AppSchemaUtil.getModel((Project)project, (String)(modelId + "_ulp"));
        this.processUpdateListPresentationModel(ulpmodel, project);
        Model preferenceItemModel = new Model();
        preferenceItemModel.setId("preferenceItem");
        preferenceItemModel.setType("reserved");
        project.addContent((IProjectChoice)preferenceItemModel);
    }

    private void processUpdateListPresentationModel(Model ulpmodel, Project project) {
        this.processListModel(ulpmodel, project);
    }

    private void processListPresentationModel(Model lpmodel, Project project) {
        this.processListModel(lpmodel, project);
    }

    private void processListModel(Model lmodel, Project project) {
        if (lmodel == null) {
            return;
        }
        Modelitem passwdNowItem = null;
        Modelitem passwdItem = null;
        Modelitem passwd2Item = null;
        Modelitem compulsoryChangeItem = null;
        Modelitem jprincipalIdItem = null;
        IModelChoice[] imcs = lmodel.getContent();
        for (int i = 0; i < imcs.length; ++i) {
            IModelChoice imc = imcs[i];
            if (!(imc instanceof Modelitem)) continue;
            Modelitem mitem = (Modelitem)imc;
            if (mitem.getName().equals("passwdNow")) {
                passwdNowItem = mitem;
                continue;
            }
            if (mitem.getName().equals("passwd")) {
                passwdItem = mitem;
                continue;
            }
            if (mitem.getName().equals("passwd2")) {
                passwd2Item = mitem;
                continue;
            }
            if (mitem.getName().equals("compulsoryChange")) {
                compulsoryChangeItem = mitem;
                continue;
            }
            if (!mitem.getName().equals("jprincipalId")) continue;
            jprincipalIdItem = mitem;
        }
        lmodel.removeContent(passwdNowItem);
        lmodel.removeContent(passwdItem);
        lmodel.removeContent(passwd2Item);
        lmodel.removeContent(compulsoryChangeItem);
        lmodel.removeContent(jprincipalIdItem);
    }

    protected void processStoreModel(Model smodel, Project project) {
        smodel.setCacheMethod("ThreadLocal");
        smodel.setGroup("jfc_data");
        smodel.setImplement("jp.jasminesoft.jfc.model.juser.IJuser");
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey((Model)smodel);
        pkeys[0].setUseseq("juser_seq");
        Modelitem passwdNowItem = null;
        Modelitem passwd2Item = null;
        int insertPointOfNameItem = -1;
        int insertPointOfPasswordMiscItem = -1;
        IModelChoice[] imcs = smodel.getContent();
        for (int i = 0; i < imcs.length; ++i) {
            HibernateParameterModelitem hmitem;
            IModelChoice imc = imcs[i];
            if (!(imc instanceof Modelitem)) continue;
            Modelitem mitem = (Modelitem)imc;
            if (mitem.getName().equals("userid")) {
                mitem.setUnique(true);
                continue;
            }
            if (mitem.getName().equals("level")) {
                insertPointOfNameItem = i;
                continue;
            }
            if (mitem.getName().equals("passwd")) {
                mitem.setKeep(true);
                continue;
            }
            if (mitem.getName().equals("passwdNow")) {
                passwdNowItem = mitem;
                continue;
            }
            if (mitem.getName().equals("passwd2")) {
                passwd2Item = mitem;
                continue;
            }
            if (mitem.getName().equals("compulsoryChange")) {
                mitem.setUseRelax(false);
                Relation relation = AppSchemaUtil.getRelationTypeExceptRef((Modelitem)mitem);
                if (relation == null) continue;
                relation.setInit("JuserPHelper2.getPasswdChangeFlagAsIntArray(juser_p, p, juser)");
                continue;
            }
            if (mitem.getName().equals("oldPasswds")) {
                mitem.setRdbcolumnname("old_passwds");
                hmitem = new HibernateParameterModelitem();
                hmitem.setListTablename("juser$old_passwds");
                hmitem.setListIndexColumnname("cid");
                hmitem.setListIndexColumnameDuplicatecheck(false);
                mitem.setContent((IModelitemChoice)hmitem);
                continue;
            }
            if (!mitem.getName().equals("jprincipalId")) continue;
            mitem.setRdbcolumnname("jprincipal_id");
            hmitem = new HibernateParameterModelitem();
            hmitem.setListTablename("juser$jprincipal_id");
            hmitem.setListIndexColumnname("cid");
            hmitem.setListIndexColumnameDuplicatecheck(false);
            mitem.addContent((IModelitemChoice)hmitem);
            insertPointOfPasswordMiscItem = i;
        }
        if ((insertPointOfNameItem == -1 || insertPointOfPasswordMiscItem == -1) && StringUtils.isBlank((CharSequence)smodel.getMainmodelidref())) {
            this.log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BJUserModel.processStoreModel"));
            return;
        }
        smodel.removeContent(passwdNowItem);
        smodel.removeContent(passwd2Item);
        if (StringUtils.isBlank((CharSequence)smodel.getMainmodelidref())) {
            Modelitem preferenceItem = new Modelitem();
            preferenceItem.setName("preferenceItem");
            preferenceItem.setType("storeref");
            preferenceItem.setExistCheck(false);
            preferenceItem.setSrcgen("model");
            Relation rel_preferenceItem = new Relation();
            rel_preferenceItem.setIdref("preferenceItem");
            rel_preferenceItem.setType("check");
            preferenceItem.addContent((IModelitemChoice)rel_preferenceItem);
            smodel.addContent((IModelChoice)preferenceItem);
        }
    }

    protected void processPresentationModel(Model pmodel, Project project) {
        IModelChoice[] imcs = pmodel.getContent();
        for (int i = 0; i < imcs.length; ++i) {
            IModelChoice imc = imcs[i];
            if (!(imc instanceof Modelitem)) continue;
            Modelitem mitem = (Modelitem)imc;
            if (mitem.getName().equals("passwdNow")) {
                mitem.setStandalone(true);
                continue;
            }
            if (mitem.getName().equals("passwd2")) {
                mitem.setStandalone(true);
                continue;
            }
            if (!mitem.getName().equals("passwd")) continue;
            Embed embed = new Embed();
            StringBuilder sb = new StringBuilder();
            sb.append("// begin customize" + CR);
            sb.append("Integer _mode = (Integer)p.request.getAttribute(\"__helper_input_check_mode\");" + CR);
            sb.append("Boolean _isCSVUpload = (Boolean)p.request.getAttribute(\"__helper_jusercontrol_csvupload\");" + CR);
            sb.append("if (((_mode != null && _mode.intValue() == UPDATE) && (s != null && s.length() == 0)) || (_isCSVUpload != null && _isCSVUpload.booleanValue())) {" + CR);
            sb.append("    s = null;" + CR);
            sb.append("}" + CR);
            sb.append("// end customize");
            embed.setContent(sb.toString());
            mitem.addContent(0, (IModelitemChoice)embed);
        }
        Model smodel = AppSchemaUtil.getModel((Project)project, (String)pmodel.getIdref());
        if (StringUtils.isBlank((CharSequence)smodel.getMainmodelidref())) {
            Modelitem preferenceItem_p = new Modelitem();
            preferenceItem_p.setName("preferenceItem");
            preferenceItem_p.setSrcgen("model");
            pmodel.addContent((IModelChoice)preferenceItem_p);
        }
    }
}

