/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.model.mailmessage.Attachment;
import jp.jasminesoft.jfc.model.mailmessage.Mailmessage;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="BMailmessage")
public class BMailmessage
extends AppSchemaBuilder {
    protected Logger log = LogManager.getLogger(BMailmessage.class);
    public static final String SAVEDIR = "webpage" + File.separator + "WEB-INF" + File.separator + "mailmessage" + File.separator;

    @Override
    public void process(Project project) {
        this.process_model(project);
        this.process_remindPassword(project);
    }

    public void process_model(Project project) {
        String[] sendmailActions = new String[]{"insert", "update", "delete", "show", "showlist", "download"};
        for (String modelId : this.con_.getAllStoreModelId()) {
            for (String sendmailAction : sendmailActions) {
                String attachFilenames;
                String body;
                String bodycontenttype;
                String strmailtype;
                String bcc;
                String cc;
                String to;
                String from;
                String subject;
                String auth_password_;
                String auth_user_;
                String auth_;
                String protocol;
                if (!Utils.isSelectedValue(this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@send"))) continue;
                boolean individualSend = Utils.isSelectedValue(this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@individualSend"));
                String attachmentMaxSize = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@attachmentMaxSize");
                Mailmessage mailmessage = new Mailmessage();
                if (individualSend) {
                    mailmessage.setIndividualSend(individualSend);
                }
                if (StringUtils.isNotBlank((CharSequence)attachmentMaxSize)) {
                    try {
                        int i_attachementMaxSize = Integer.parseInt(attachmentMaxSize);
                        mailmessage.setAttachmentMaxSize(i_attachementMaxSize);
                    }
                    catch (NumberFormatException e) {
                        this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMailmessage.process_model.1", new Object[]{modelId, attachmentMaxSize}));
                    }
                }
                String mid = modelId + "_" + sendmailAction + ".xls.xml";
                mailmessage.setMid(mid);
                String mailhost = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@mailhost");
                if (StringUtils.isNotBlank((CharSequence)mailhost)) {
                    mailmessage.setMailhost(StringUtil.escapeStringForXML((String)mailhost));
                }
                if (StringUtils.isNotBlank((CharSequence)(protocol = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@protocol")))) {
                    mailmessage.setProtocol(StringUtil.escapeStringForXML((String)BJob.SendMailProtocolMap.get(protocol.toLowerCase())));
                }
                if (StringUtils.isNotBlank((CharSequence)(auth_ = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@auth")))) {
                    mailmessage.setAuth(Utils.isSelectedValue(auth_));
                }
                if (StringUtils.isNotBlank((CharSequence)(auth_user_ = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@auth_user")))) {
                    mailmessage.setAuthUser(auth_user_);
                }
                if (StringUtils.isNotBlank((CharSequence)(auth_password_ = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@auth_password")))) {
                    mailmessage.setAuthPassword(auth_password_);
                }
                if (StringUtils.isNotBlank((CharSequence)(subject = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@subject")))) {
                    mailmessage.setSubject(StringUtil.escapeStringForXML((String)subject));
                }
                if (StringUtils.isNotBlank((CharSequence)(from = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@from")))) {
                    mailmessage.setFrom(from);
                }
                if (StringUtils.isNotBlank((CharSequence)(to = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@to")))) {
                    for (String _to : to.split(",")) {
                        mailmessage.addTo(_to);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(cc = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@cc")))) {
                    for (String _cc : cc.split(",")) {
                        mailmessage.addCc(_cc);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(bcc = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@bcc")))) {
                    for (String _bcc : bcc.split(",")) {
                        mailmessage.addBcc(_bcc);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(strmailtype = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@mailtype"))) && (bodycontenttype = BMailmessage.getBodycontenttype(strmailtype)) != null) {
                    mailmessage.setBodycontenttype(bodycontenttype);
                }
                if (StringUtils.isNotBlank((CharSequence)(body = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@body")))) {
                    mailmessage.setBody(body);
                }
                if (StringUtils.isNotBlank((CharSequence)(attachFilenames = this.con_.getModelValue(modelId, "model/sendmail/" + sendmailAction + "/@attachmentFilename")))) {
                    String[] attachFilename_arr;
                    for (String attachFilename : attachFilename_arr = attachFilenames.split(",")) {
                        Attachment attachment = new Attachment();
                        attachFilename = attachFilename.trim();
                        attachment.setFilename(attachFilename);
                        attachment.setFilepath(attachFilename.substring(0, attachFilename.length() - 1) + "_jshfilename}");
                        mailmessage.addAttachment(attachment);
                    }
                }
                BMailmessage.saveMailmessage(mailmessage);
            }
        }
    }

    public static String getBodycontenttype(String strmailtype) {
        if (strmailtype != null && strmailtype.equals("HTML")) {
            return "text/html";
        }
        return null;
    }

    public void process_remindPassword(Project project) {
        String subject_;
        String s = this.con_.getProjectValue("project/environment/@remind_password");
        if (StringUtils.isEmpty((CharSequence)s)) {
            return;
        }
        Mailmessage mailmessage = new Mailmessage();
        mailmessage.setMid("remindPassword.xml");
        String from_ = this.con_.getProjectValue("project/remindPassword/mail/@from");
        if (StringUtils.isEmpty((CharSequence)from_)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMailmessage.process_remindPassword.1"));
        }
        mailmessage.setFrom(from_);
        mailmessage.setTo("${to}");
        String bcc_ = this.con_.getProjectValue("project/remindPassword/mail/@bcc");
        if (StringUtils.isNotEmpty((CharSequence)bcc_)) {
            mailmessage.setBcc(bcc_);
        }
        if (StringUtils.isEmpty((CharSequence)(subject_ = this.con_.getProjectValue("project/remindPassword/mail/@subject")))) {
            this.getMessageListener().info(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMailmessage.process_remindPassword.2"));
            subject_ = rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMailmessage.process_remindPassword.3");
        }
        mailmessage.setSubject(subject_);
        String body_ = this.con_.getProjectValue("project/remindPassword/mail/@body");
        if (StringUtils.isEmpty((CharSequence)body_)) {
            this.getMessageListener().info(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMailmessage.process_remindPassword.4"));
            StringBuilder sb = new StringBuilder();
            sb.append(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMailmessage.process_remindPassword.body.1"));
            sb.append(CR);
            sb.append(CR);
            sb.append(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMailmessage.process_remindPassword.body.2"));
            sb.append(CR);
            sb.append(CR);
            sb.append("${url}").append(CR);
            sb.append(CR);
            body_ = sb.toString();
        }
        mailmessage.setBody(body_);
        BMailmessage.saveMailmessage(mailmessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMailmessage(Mailmessage mailmessage) {
        FileOutputStream ostream = null;
        PrintWriter writer = null;
        try {
            ostream = new FileOutputStream(SAVEDIR + mailmessage.getMid());
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)ostream, "UTF-8"));
            writer.print(mailmessage.toString());
            writer.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                writer.close();
                ostream = null;
            }
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

