/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BModelBase;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="BSelectableSearchListPresentation")
public class BSelectableSearchListPresentation
extends BModelBase {
    protected Logger log = LogManager.getLogger(BSelectableSearchListPresentation.class);

    @Override
    protected Logger getLog() {
        return this.log;
    }

    @Override
    public void process(Project project) {
        ArrayList<Model> list = new ArrayList<Model>();
        for (IProjectChoice ipc : project.getContent()) {
            Model _model;
            if (!(ipc instanceof Model) || !(_model = (Model)ipc).getType().equals("store") && !_model.getType().equals("condition")) continue;
            list.add(_model);
        }
        Model[] models = list.toArray(new Model[list.size()]);
        if (models == null || models.length == 0) {
            return;
        }
        for (Model model : models) {
            Modelitem[] mitems = AppSchemaUtil.getModelitem((Model)model);
            if (mitems == null) continue;
            String modelId = model.getId();
            if ("condition".equals(model.getType())) {
                modelId = model.getIdref();
            }
            for (Modelitem mitem : mitems) {
                Relation rel;
                if (!"storeref".equals(mitem.getType()) || (rel = AppSchemaUtil.getRelationTypeExceptRef((Modelitem)mitem)) == null || !"check".equals(rel.getType()) || !Utils.isUiSearch(modelId, mitem.getName(), this.con_)) continue;
                Model rlpmodel = AppSchemaUtil.getModel((Project)project, (String)(rel.getIdref() + "_lp"));
                if (rlpmodel == null) {
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BSelectableSearchListPresentation.process.notfound.lpmodel", new Object[]{modelId, mitem.getName(), rel.getIdref()}));
                    continue;
                }
                rlpmodel.setSelectable(true);
                rel.setUi("search");
                Action searchListAction = AppSchemaUtil.getAction((Project)project, (String)("searchList" + StringUtil.capFirst((String)rel.getIdref())));
                if (searchListAction == null) continue;
                searchListAction.setSelecttype("all");
            }
        }
    }
}

