/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.error;

import java.util.HashSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppschemaChecker;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="CheckModelitemName")
public class CheckModelitemName
extends AppschemaChecker {
    @Override
    public void check(Project project) {
        HashSet processedModelitemNameSet = new HashSet();
        for (IProjectChoice ipc : project.getContent()) {
            Model model;
            if (!(ipc instanceof Model) || !"store".equals((model = (Model)ipc).getType())) continue;
            String modelId = model.getId();
            for (IModelChoice imc : model.getContent()) {
                if (!(imc instanceof Modelitem)) continue;
                Modelitem mitem = (Modelitem)imc;
                String name = mitem.getName();
                if (StringUtils.isBlank((CharSequence)name)) {
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckModelitemName.check.1", new Object[]{modelId}));
                    continue;
                }
                char c = name.charAt(0);
                if ((c < 'A' || c > 'z') && c != '_') {
                    this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckModelitemName.check.2", new Object[]{modelId, name}));
                    continue;
                }
                int length = name.length();
                for (int i = 1; i < length; ++i) {
                    c = name.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'z' || c == '_' || c == '/') continue;
                    this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckModelitemName.check.2", new Object[]{modelId, name}));
                }
                String uname = Utils.getUniqueName(AppSchemaUtil.getChildPart((String)name));
                if (!processedModelitemNameSet.contains(uname)) continue;
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckModelitemName.check.3", new Object[]{modelId, name}));
            }
        }
    }
}

