/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.error;

import jp.jasminesoft.jfc.tools.xls2appschema.ErrorChecker;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.util.StringUtil;
import org.springframework.stereotype.Component;

@Component(value="InvalidModelName")
public class InvalidModelName
extends ErrorChecker {
    public static String[] invalidPostfixStringPatterns = new String[]{"_p", "_c", "_l", "_cp", "_lp", "_ulp"};

    @Override
    public void check() {
        this.checkModelId(this.getElementContainer().getAllStoreModelId());
        this.checkModelId(this.getElementContainer().getAllMasterModelId());
    }

    private void checkModelId(String[] modelIds) {
        for (String modelId : modelIds) {
            String errorCh = Utils.isValidName(modelId);
            if (errorCh.length() > 0) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.InvalidModelName.check.1", new Object[]{modelId, errorCh}));
            }
            if (!StringUtil.isValidXmlName((String)modelId)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.InvalidModelName.check.2", new Object[]{modelId}));
            }
            for (String invalidPostfixString : invalidPostfixStringPatterns) {
                if (!modelId.endsWith(invalidPostfixString)) continue;
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.InvalidModelName.check.3", new Object[]{modelId, invalidPostfixString}));
            }
        }
    }
}

