/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.model.csslist.Cssitem;
import jp.jasminesoft.jfc.model.csslist.Csslist;
import jp.jasminesoft.util.JaxbUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CssFileManager {
    private Csslist csslist;
    private Logger logger = LogManager.getLogger((String)CssFileManager.class.getName());
    public static final String DEFAULT_CSSFILENAME = "css/soria.css";
    @Autowired
    private ServletContext servletContext;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @PostConstruct
    public void init() {
        this.initCssFileManager(this.servletContext);
    }

    public void initCssFileManager(ServletContext servletContext) {
        URL url;
        block6: {
            String path = servletContext.getInitParameter("csslist");
            if (path == null) {
                path = "/WEB-INF/csslist.xml";
            }
            url = null;
            try {
                url = servletContext.getResource(path);
                if (url == null) {
                    this.logger.log(LogCodeManager.getPriority(LogCode.JFC00200), LogCodeManager.getMessage(LogCode.JFC00200, path));
                    this.logger.debug("cssfilelist resource '" + path + "' is not found.");
                } else {
                    this.logger.info("(admin@localhost) * cssfilelist is set to " + path + ".");
                }
            }
            catch (MalformedURLException e) {
                this.logger.log(LogCodeManager.getPriority(LogCode.JFC00200), LogCodeManager.getMessage(LogCode.JFC00200, path));
                this.logger.debug("Failed to get cssfilelist resource from " + path + ".", (Throwable)e);
                if (!this.logger.isDebugEnabled()) break block6;
                e.printStackTrace();
            }
        }
        if (url != null) {
            this.init(url);
        }
    }

    public void init(URL url) {
        try {
            this.csslist = (Csslist)JaxbUtil.unmarshal((URL)url, Csslist.class);
        }
        catch (Exception e) {
            this.logger.warn("csslist file " + url.toString() + " is illegal file. Skip.");
        }
    }

    public Csslist getCsslist() {
        return this.csslist;
    }

    public String getStandardCssFilename() {
        String ret = null;
        if (this.csslist == null) {
            return null;
        }
        Cssitem[] items = this.csslist.getCssitem();
        if (items != null) {
            for (Cssitem item : items) {
                if (!item.getStandard()) continue;
                ret = item.getContent();
                break;
            }
        }
        if (ret == null) {
            ret = DEFAULT_CSSFILENAME;
        }
        return ret;
    }

    public boolean exists(String cssfilename) {
        Cssitem[] items = this.csslist.getCssitem();
        if (items == null || cssfilename == null) {
            return false;
        }
        boolean ret = false;
        for (Cssitem item : items) {
            if (!cssfilename.equals(item.getContent())) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

