/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.util.List;
import jp.jasminesoft.jfc.DbDownloadProcessor;
import jp.jasminesoft.jfc.JFCClientAbortException;
import jp.jasminesoft.jfc.repgen.excel.poi.ReportWorkbookImpl;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class DbDownloadProcessorImpl_Xls
implements DbDownloadProcessor {
    private static final Logger logger = LogManager.getLogger(DbDownloadProcessorImpl_Xls.class);
    private static final String TempFilenameHeader = "DbDownloadProcessorImpl_Xls";
    private static final int PROCESSING_LOG_INTERVAL = 60000;
    private OutputStream ostream;
    private File tempfile;
    private ObjectOutputStream oostream;
    private boolean isOverMaxColumnSize = false;
    private boolean isOverMaxRowSize = false;
    private int rowCount = 0;
    private String sheetName;

    public DbDownloadProcessorImpl_Xls(OutputStream ostream) throws IOException {
        this.ostream = ostream;
        this.tempfile = File.createTempFile(TempFilenameHeader, ".ser");
        try {
            this.oostream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.tempfile)));
        }
        catch (IOException e) {
            if (!this.tempfile.delete()) {
                logger.debug("Failed to delete ser temp file " + this.tempfile);
            }
            throw e;
        }
    }

    @Override
    public boolean isEnableObjectWrite() {
        return true;
    }

    public void write(Serializable[] sera) throws IOException {
        int maxColumnSize = this.getMaxColumnSize();
        if (sera.length > maxColumnSize) {
            Serializable[] newoa = new Serializable[maxColumnSize];
            System.arraycopy(sera, 0, newoa, 0, maxColumnSize);
            sera = newoa;
            this.isOverMaxColumnSize = true;
        }
        if (this.rowCount >= this.getMaxRowSize()) {
            this.isOverMaxRowSize = true;
            throw new IllegalStateException("over max row size " + this.getMaxRowSize());
        }
        SerializeArray array = new SerializeArray(sera);
        this.oostream.writeObject(array);
        this.oostream.reset();
        ++this.rowCount;
    }

    @Override
    public void write(String[] data) throws IOException {
        this.write((Serializable[])data);
    }

    @Override
    public void write(List<Serializable> data) throws IOException {
        Serializable[] sera = new Serializable[data.size()];
        sera = data.toArray(sera);
        this.write(sera);
    }

    @Override
    public void close() throws IOException {
        try {
            this._close();
        }
        finally {
            if (this.tempfile != null && !this.tempfile.delete()) {
                logger.debug("Failed to delete ser temp file " + this.tempfile);
            }
            if (this.ostream != null) {
                try {
                    this.ostream.close();
                }
                catch (IOException e) {
                    JFCClientAbortException cae = JFCClientAbortException.create(e);
                    if (cae != null) {
                        throw cae;
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _close() throws IOException {
        this.oostream.close();
        logger.debug("reading ser temp file " + this.tempfile);
        Workbook workbook = this.createWorkbook();
        Sheet sheet = workbook.createSheet();
        if (this.sheetName != null) {
            workbook.setSheetName(0, this.sheetName);
        }
        DataFormat dataformat = workbook.createDataFormat();
        CellStyle stringcellstyle = workbook.createCellStyle();
        stringcellstyle.setDataFormat(dataformat.getFormat("@"));
        CellStyle intcellstyle = workbook.createCellStyle();
        intcellstyle.setDataFormat(dataformat.getFormat("0"));
        CellStyle datecellstyle = workbook.createCellStyle();
        datecellstyle.setDataFormat(dataformat.getFormat("yyyy/mm/dd"));
        CellStyle timecellstyle = workbook.createCellStyle();
        timecellstyle.setDataFormat(dataformat.getFormat("h:mm:ss"));
        CellStyle datetimecellstyle = workbook.createCellStyle();
        datetimecellstyle.setDataFormat(dataformat.getFormat("yyyy/mm/dd h:mm:ss"));
        long printCountTime = System.currentTimeMillis() + 60000L;
        ObjectInputStream oistream = null;
        int maxRowSize = this.getMaxRowSize();
        int maxColumnSize = this.getMaxColumnSize();
        try {
            oistream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.tempfile)));
            int rowcnt = 0;
            while (true) {
                if (rowcnt >= maxRowSize) {
                    this.isOverMaxRowSize = true;
                    break;
                }
                SerializeArray array = (SerializeArray)oistream.readObject();
                Serializable[] data = array.oa;
                Row row = sheet.createRow(rowcnt++);
                int colsize = data.length;
                if (colsize >= maxColumnSize) {
                    this.isOverMaxColumnSize = true;
                    colsize = maxColumnSize;
                }
                for (int colcnt = 0; colcnt < colsize; ++colcnt) {
                    Cell cell;
                    Serializable d = data[colcnt];
                    if (d == null) {
                        row.createCell(colcnt, CellType.BLANK);
                        continue;
                    }
                    if (d instanceof String) {
                        cell = row.createCell(colcnt, CellType.STRING);
                        cell.setCellValue((String)((Object)d));
                        cell.setCellStyle(stringcellstyle);
                        continue;
                    }
                    if (d instanceof java.util.Date) {
                        cell = row.createCell(colcnt, CellType.NUMERIC);
                        cell.setCellValue((java.util.Date)d);
                        if (d instanceof Date) {
                            cell.setCellStyle(datecellstyle);
                            continue;
                        }
                        if (d instanceof Time) {
                            cell.setCellStyle(timecellstyle);
                            continue;
                        }
                        cell.setCellStyle(datetimecellstyle);
                        continue;
                    }
                    if (d instanceof Number) {
                        cell = row.createCell(colcnt, CellType.NUMERIC);
                        cell.setCellValue(((Number)d).doubleValue());
                        if (!(d instanceof Integer) && !(d instanceof Byte) && !(d instanceof Short) && !(d instanceof Long)) continue;
                        cell.setCellStyle(intcellstyle);
                        continue;
                    }
                    logger.error("Unknown object type " + d.getClass() + ". value:" + d);
                    row.createCell(colcnt, CellType.BLANK);
                }
                long nowTime = System.currentTimeMillis();
                if (printCountTime > nowTime) continue;
                logger.info("processing create excel file. processed rows:" + rowcnt);
                printCountTime = nowTime + 60000L;
            }
        }
        catch (EOFException e) {
            logger.debug("eof", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error("class not found", (Throwable)e);
        }
        finally {
            if (oistream != null) {
                oistream.close();
            }
        }
        if (this.isOverMaxColumnSize) {
            logger.warn("Column size is over " + maxColumnSize + ". Excel file is outputed only " + maxColumnSize + " columns.");
        }
        if (this.isOverMaxRowSize) {
            logger.warn("Row size is over " + maxRowSize + ". Excel file is outputed only " + maxRowSize + " rows.");
        }
        File xlstempfile = null;
        FilterOutputStream bostream = null;
        try {
            xlstempfile = File.createTempFile(TempFilenameHeader, this.getFileExtension());
            logger.debug("write temp file " + xlstempfile);
            bostream = new BufferedOutputStream(new FileOutputStream(xlstempfile));
            workbook.write((OutputStream)bostream);
        }
        catch (IOException e) {
            if (xlstempfile == null || xlstempfile.delete()) throw e;
            logger.debug("Failed to delete temp file " + xlstempfile);
            throw e;
        }
        finally {
            if (bostream != null) {
                bostream.close();
            }
            workbook = null;
        }
        logger.debug("download temp file " + xlstempfile);
        BufferedInputStream bistream = null;
        bostream = null;
        try {
            int cnt;
            bistream = new BufferedInputStream(new FileInputStream(xlstempfile));
            bostream = new BufferedOutputStream(this.ostream);
            byte[] ba = new byte[1024];
            while ((cnt = bistream.read(ba)) >= 0) {
                if (cnt == 0) continue;
                try {
                    ((BufferedOutputStream)bostream).write(ba, 0, cnt);
                }
                catch (IOException e) {
                    JFCClientAbortException cae = JFCClientAbortException.create(e);
                    if (cae == null) throw e;
                    throw cae;
                    return;
                }
            }
        }
        finally {
            if (bistream != null) {
                try {
                    bistream.close();
                }
                catch (IOException e) {
                    logger.debug("Failed to close bistream", (Throwable)e);
                }
            }
            xlstempfile.delete();
            if (bostream != null) {
                try {
                    bostream.close();
                    this.ostream = null;
                }
                catch (IOException e) {
                    JFCClientAbortException cae = JFCClientAbortException.create(e);
                    if (cae == null) throw e;
                    throw cae;
                }
            }
        }
    }

    protected int getMaxColumnSize() {
        int maxColumnSize = 256;
        return 256;
    }

    protected int getMaxRowSize() {
        int maxRowSize = 65536;
        return 65536;
    }

    protected Workbook createWorkbook() {
        return new HSSFWorkbook();
    }

    protected String getFileExtension() {
        return ".xls";
    }

    public void setSheetName(String sheetName) {
        if (StringUtils.isBlank((CharSequence)sheetName)) {
            return;
        }
        int ptr = sheetName.indexOf(".");
        if (ptr > 0) {
            sheetName = sheetName.substring(0, ptr);
        }
        this.sheetName = StringUtil.replaceAll((String)sheetName, ReportWorkbookImpl.invalidCharacterAtSheetNameMap);
    }

    private static class SerializeArray
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Serializable[] oa;

        SerializeArray(Serializable[] oa) {
            this.oa = oa;
        }
    }
}

