/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipException;
import jp.jasminesoft.jfc.AbstractDbUploadUpdateRunnableMonitor;
import jp.jasminesoft.jfc.AbstractDbUploadUpdateRunnableMonitorFileProcessorImpl;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcerrors;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DbUploadUpdateRunnableMonitorFileProcessorImpl_Zip
extends AbstractDbUploadUpdateRunnableMonitorFileProcessorImpl {
    private static final Logger logger = LogManager.getLogger(DbUploadUpdateRunnableMonitorFileProcessorImpl_Zip.class);
    private static final String ZipFileFilenameEncoding = "MS932";
    protected List<String> entrynames;
    protected Set<String> attachmentnames;
    protected ZipFile zipfile;

    public static boolean isProcessFile(String filename) {
        return filename.toLowerCase().endsWith(".zip");
    }

    @Override
    public void setBaseFile(File file, String filename) {
        this.file = file;
    }

    @Override
    public void setDbUploadUpdateRunnableMonitor(AbstractDbUploadUpdateRunnableMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void setActionParameter(ActionParameter p) {
        this.p = p;
    }

    @Override
    public void setSeparateCharacter(char c) {
    }

    @Override
    public boolean isProcessMultiFiles() {
        return true;
    }

    @Override
    public String getOpenFilename() {
        if (this.filecnt >= this.entrynames.size()) {
            return null;
        }
        String entryname = this.entrynames.get(this.filecnt);
        return entryname;
    }

    @Override
    public List<String> getOpenFilenames() {
        if (this.entrynames == null) {
            return Collections.emptyList();
        }
        return this.entrynames;
    }

    @Override
    public boolean hasNextFile() {
        return this.filecnt < this.entrynames.size();
    }

    @Override
    public void openFile() throws IOException {
        if (this.isOpenFile()) {
            return;
        }
        this._openFile();
        this.p.request.setAttribute("__jfc_uploadupdate_fileentry", (Object)this.getOpenFilename());
        if (this.header != null && !this.isUseHeaderRow) {
            this.monitor.readHeader(this.header, true);
        } else {
            String[] header = this.readRowData();
            this.monitor.readHeader(header, true);
        }
    }

    @Override
    protected void _openFile() throws IOException {
        String entryname = this.entrynames.get(this.filecnt);
        ZipArchiveEntry entry = this.zipfile.getEntry(entryname);
        if (entry == null) {
            logger.debug("No csv file in zip file, entryname=" + entryname);
            throw new IOException();
        }
        char sep = DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv.getSeparator(entryname);
        assert (sep != '\u0000');
        this.SepChar = sep;
        InputStream istream = this.zipfile.getInputStream(entry);
        try {
            this.setReader(istream, this.encoding);
        }
        catch (IOException e) {
            try {
                istream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void processEnd() {
        if (this.zipfile != null) {
            try {
                this.zipfile.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close zip file", (Throwable)e);
            }
        }
    }

    @Override
    public void readHeader() throws IOException {
        super.readHeader();
        this.readHeader(null);
    }

    @Override
    public String[] readHeaderBeforeScript() throws IOException {
        try (ZipFile zipfile = new ZipFile(this.file, ZipFileFilenameEncoding);){
            String[] stringArray = this.readHeaderBeforeScript(zipfile);
            return stringArray;
        }
    }

    private String[] readHeaderBeforeScript(ZipFile zipfile) throws IOException {
        Enumeration enu = zipfile.getEntries();
        while (enu.hasMoreElements()) {
            char sep;
            ZipArchiveEntry entry = (ZipArchiveEntry)enu.nextElement();
            String entryname = entry.getName();
            logger.debug("entryname=" + entryname);
            if (this.isAttachmentFile(entryname) || !DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv.isProcessFile(entryname) || (sep = DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv.getSeparator(entryname)) == '\u0000') continue;
            this.SepChar = sep;
            return this.readRowData(zipfile, entry);
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readRowData(ZipFile zipfile, ZipArchiveEntry entry) throws IOException {
        try (BufferedReader reader = null;){
            InputStream istream = zipfile.getInputStream(entry);
            InputStreamReader reader1 = new InputStreamReader(istream, this.encoding);
            reader = new BufferedReader(reader1);
            String[] stringArray = this.readRowData(reader, istream);
            return stringArray;
        }
    }

    @Override
    public void setHeader(String[] header, boolean isUseHeaderRow) throws IOException {
        super.setHeader(header, isUseHeaderRow);
        this.readHeader(header);
    }

    private void readHeader(String[] header) throws IOException {
        if (this.zipfile != null) {
            this.zipfile.close();
        }
        this.zipfile = new ZipFile(this.file, ZipFileFilenameEncoding);
        Jfcerrors errors = new Jfcerrors();
        ArrayList<String> entrynames = new ArrayList<String>();
        HashSet<String> attachmentnames = new HashSet<String>();
        Enumeration<ZipArchiveEntry> enu = this.getZipFileEntries();
        while (enu.hasMoreElements()) {
            ZipArchiveEntry entry = enu.nextElement();
            String entryname = entry.getName();
            logger.debug("entryname=" + entryname);
            if (this.isAttachmentFile(entryname)) {
                logger.debug("add attachmentnames entryname=" + entryname);
                attachmentnames.add(entryname);
                continue;
            }
            if (DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv.isProcessFile(entryname)) {
                char sep = DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv.getSeparator(entryname);
                if (sep == '\u0000') continue;
                this.SepChar = sep;
                this.readHeader_csv(errors, entrynames, entry, entryname, header);
                continue;
            }
            if (entry.isDirectory()) continue;
            logger.debug("add attachmentnames entryname=" + entryname);
            attachmentnames.add(entryname);
        }
        this.p.errors = errors;
        if (this.p.errors.sizeJfcerror() > 0) {
            return;
        }
        if (entrynames.size() == 0) {
            JFCErrorManager errorManager = (JFCErrorManager)this.p.appctx.getBean(JFCErrorManager.class);
            errors.addJfcerror(errorManager.getJfcerror("error.uploadUpdateProcessBean.empty_multifile", this.p.locale));
            return;
        }
        Collections.sort(entrynames);
        this.entrynames = Collections.unmodifiableList(entrynames);
        this.attachmentnames = Collections.unmodifiableSet(attachmentnames);
    }

    private boolean isAttachmentFile(String entryname) {
        StringTokenizer stk = new StringTokenizer(entryname, "\\/");
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (!token.equals("files")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader_csv(Jfcerrors errors, ArrayList<String> entrynames, ZipArchiveEntry entry, String entryname, String[] header) throws IOException, ZipException, UnsupportedEncodingException {
        JFCErrorManager errorManager = (JFCErrorManager)this.p.appctx.getBean(JFCErrorManager.class);
        try (BufferedReader reader = null;){
            if (header == null) {
                InputStream istream = this.zipfile.getInputStream(entry);
                InputStreamReader reader1 = new InputStreamReader(istream, this.encoding);
                reader = new BufferedReader(reader1);
                header = this.readRowData(reader, istream);
            }
            this.monitor.readHeader(header, false);
        }
        if (this.p.errors.sizeJfcerror() > 0) {
            Jfcerror[] errormsgs = this.p.errors.getJfcerror();
            for (int i = 0; i < errormsgs.length; ++i) {
                Object[] ep = new Object[]{errormsgs[i].getContent(), entryname};
                errors.addJfcerror(errorManager.getJfcerror("error.uploadUpdateProcessBean.failed_readheader_multifile", ep, this.p.locale));
            }
            this.p.errors.clearJfcerror();
        } else if (this.p.errors.sizeJfcerror() == 0) {
            logger.debug("add entrynames entryname=" + entryname);
            entrynames.add(entryname);
        }
    }

    private Enumeration<ZipArchiveEntry> getZipFileEntries() {
        return this.zipfile.getEntries();
    }

    @Override
    public Set<String> getAttachmentFilenameSet() {
        if (logger.isDebugEnabled()) {
            for (String s : this.attachmentnames) {
                logger.debug("attachmentnames=" + s);
            }
        }
        return this.attachmentnames;
    }

    @Override
    public InputStream getAttachmentInputStream(String filename) throws IOException {
        ZipArchiveEntry entry = this.zipfile.getEntry(filename);
        if (entry == null) {
            logger.debug("No csv file in zip file, " + filename);
            return null;
        }
        InputStream istream = this.zipfile.getInputStream(entry);
        return istream;
    }
}

