/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitor;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorStoppedImpl;
import jp.jasminesoft.jfc.JFCUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbUploadUpdateRunnableMonitorManager {
    private static final Logger logger = LogManager.getLogger(DbUploadUpdateRunnableMonitorManager.class);
    private static final DbUploadUpdateRunnableMonitorManager _instance = new DbUploadUpdateRunnableMonitorManager();
    private ConcurrentHashMap<UsernameItem, DbUploadUpdateRunnableMonitor> modelLockMonitorMap = new ConcurrentHashMap();
    private Set<UsernameItem> createFlagSet = Collections.synchronizedSet(new HashSet());

    public static DbUploadUpdateRunnableMonitorManager getInstance() {
        return _instance;
    }

    private DbUploadUpdateRunnableMonitorManager() {
    }

    public void addMonitor(ActionParameter p, String actionstatus, String lockmodel, boolean isLockModel, DbUploadUpdateRunnableMonitor monitor) {
        if (monitor == null) {
            return;
        }
        monitor.setActionStatus(actionstatus);
        UsernameItem item = new UsernameItem(p.user.getUsername(), actionstatus);
        DbUploadUpdateRunnableMonitor _monitor = this.modelLockMonitorMap.get(item);
        if (_monitor != null && !_monitor.isStopped()) {
            logger.error(JFCUtils.logmsg(p, "Already processing monitor at put lockmodel " + lockmodel + ". actionstatus:" + actionstatus));
            throw new IllegalStateException("Already processing monitor at put lockmodel " + lockmodel + ". actionstatus:" + actionstatus);
        }
        this.modelLockMonitorMap.put(item, monitor);
    }

    public boolean checkMonitor(ActionParameter p, String actionstatus) {
        UsernameItem item = new UsernameItem(p.user.getUsername(), actionstatus);
        DbUploadUpdateRunnableMonitor nowmonitor = this.modelLockMonitorMap.get(item);
        if (nowmonitor != null && !nowmonitor.isStopped()) {
            return false;
        }
        return this.createFlagSet.add(item);
    }

    public void uncheckMonitor(ActionParameter p, String actionstatus) {
        UsernameItem item = new UsernameItem(p.user.getUsername(), actionstatus);
        this.createFlagSet.remove(item);
    }

    public DbUploadUpdateRunnableMonitor getMonitor(ActionParameter p, String actionstatus) {
        UsernameItem item = new UsernameItem(p.user.getUsername(), actionstatus);
        DbUploadUpdateRunnableMonitor _monitor = this.modelLockMonitorMap.get(item);
        return _monitor;
    }

    public void endMonitor(String username, DbUploadUpdateRunnableMonitor monitor) {
        DbUploadUpdateRunnableMonitorStoppedImpl newmonitor = new DbUploadUpdateRunnableMonitorStoppedImpl(monitor);
        UsernameItem item = new UsernameItem(username, monitor.getActionStatus());
        this.modelLockMonitorMap.put(item, newmonitor);
    }

    public DbUploadUpdateRunnableMonitor removeMonitor(ActionParameter p, String actionstatus) {
        UsernameItem item = new UsernameItem(p.user.getUsername(), actionstatus);
        DbUploadUpdateRunnableMonitor nowmonitor = this.modelLockMonitorMap.get(item);
        if (nowmonitor != null && nowmonitor.isStopped() && !this.createFlagSet.contains(item)) {
            this.modelLockMonitorMap.remove(item);
            return nowmonitor;
        }
        throw new IllegalStateException("Monitor is not stop");
    }

    private static class UsernameItem {
        String username;
        String actionstatus;

        public UsernameItem(String username, String actionstatus) {
            this.username = username;
            this.actionstatus = actionstatus;
        }

        public int hashCode() {
            int code = this.username.hashCode() + this.actionstatus.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof UsernameItem)) {
                return false;
            }
            UsernameItem d = (UsernameItem)o;
            if (!(this.actionstatus == d.actionstatus || this.actionstatus != null && this.actionstatus.equals(d.actionstatus))) {
                return false;
            }
            return this.username == d.username || this.username != null && this.username.equals(d.username);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.actionstatus);
            sb.append(" ");
            sb.append(this.username);
            return sb.toString();
        }
    }
}

