/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import jp.jasminesoft.jfc.JFCBasePrincipal;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.model.subjectpolicy.Grant;
import jp.jasminesoft.jfc.model.subjectpolicy.Permissioninfo;
import jp.jasminesoft.jfc.model.subjectpolicy.Principalinfo;
import jp.jasminesoft.jfc.model.subjectpolicy.Subjectpolicy;
import jp.jasminesoft.util.JaxbUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFCAppPolicyFile {
    private static final Logger logger = LogManager.getLogger((String)JFCAppPolicyFile.class.getName());
    private static String PolicyFilenamePropertyName = "jp.jasminesoft.security.auth.policy";
    private static JFCAppPolicyFile _instance;
    private Subjectpolicy policy;

    public static synchronized JFCAppPolicyFile getInstance() {
        if (_instance != null) {
            return _instance;
        }
        JFCAppPolicyFile policyfile = new JFCAppPolicyFile();
        if (!policyfile.init()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00068), LogCodeManager.getMessage(LogCode.JFC00068, "subjectpolicy"));
            return null;
        }
        _instance = policyfile;
        return _instance;
    }

    private JFCAppPolicyFile() {
    }

    private boolean init() {
        String filename = null;
        try {
            filename = PropertyManager.getProperty(PolicyFilenamePropertyName);
            if (filename == null) {
                logger.error("policy filename property " + PolicyFilenamePropertyName + " is empty.");
                return false;
            }
            if (filename.startsWith("resource:")) {
                String name = filename.substring("resource:".length());
                ClassLoader loader = this.getClass().getClassLoader();
                logger.debug("loader = " + loader.getClass() + " " + loader);
                InputStream istream = loader.getResourceAsStream(name);
                if (istream == null) {
                    logger.error("No resource \"" + name + "\" is found.");
                    return false;
                }
                this.policy = (Subjectpolicy)JaxbUtil.unmarshal((InputStream)istream, Subjectpolicy.class);
            } else {
                this.policy = (Subjectpolicy)JaxbUtil.unmarshal((File)new File(filename), Subjectpolicy.class);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Reading policy file " + filename + " is done successfully.");
            }
        }
        catch (Exception e) {
            logger.error("Failed to read policy file " + (filename != null ? filename : ""), (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return false;
        }
        logger.debug("policy is " + this.policy);
        return true;
    }

    public PermissionCollection getPermissions(Subject subject) {
        return this.getPermissions(subject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionCollection getPermissions(Subject subject, Permission basep) {
        if (logger.isDebugEnabled()) {
            logger.debug("begin getPermissions : subject=" + subject.toString());
        }
        Permissions perms = new Permissions();
        if (this.policy != null) {
            Grant[] grants = this.policy.getGrant();
            logger.debug("policy file grants is " + grants.length);
            this.addPermission(perms, grants, subject, basep);
        } else {
            logger.debug("policy is null.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("perms = " + perms.toString());
        }
        if (UserInfoFactory.isUseGetPermissionsInUserInfo()) {
            UserInfo userinfo = UserInfoFactory.getUserInfo();
            if (userinfo == null) {
                logger.debug("Failed to get userinfo object. database configuration may be wrong.");
                return perms;
            }
            try {
                this.addUserDefinedPermission(perms, userinfo, subject, basep);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            finally {
                userinfo.close();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("perms = " + perms.toString());
            }
        }
        logger.debug("end getPermissions");
        return perms;
    }

    private void addPermission(Permissions perms, Grant[] grants, Subject subject, Permission basep) {
        block0: for (int i = 0; i < grants.length; ++i) {
            Grant grant = grants[i];
            if (logger.isDebugEnabled()) {
                logger.debug("grant " + grant.toString());
            }
            Principalinfo[] prininfos = grant.getPrincipalinfo();
            for (int j = 0; j < prininfos.length; ++j) {
                Principalinfo prininfo = prininfos[j];
                if (logger.isDebugEnabled()) {
                    logger.debug("Principalinfo " + prininfo.toString());
                }
                if (!this.isAccept(subject, prininfo)) continue;
                Permissioninfo[] perminfos = grant.getPermissioninfo();
                String bname = basep != null ? basep.getName() : null;
                for (int k = 0; k < perminfos.length; ++k) {
                    Permission perm;
                    Permissioninfo perminfo = perminfos[k];
                    if (logger.isDebugEnabled()) {
                        logger.debug("Permissioninfo " + perminfo.toString());
                    }
                    if (bname != null && !perminfo.getName().equals(bname) || (perm = this.createPermission(perminfo)) == null) continue;
                    perms.add(perm);
                }
                continue block0;
            }
        }
    }

    private boolean isAccept(Subject subject, Principalinfo prininfo) {
        return this.isAccept(subject, prininfo.getClassname(), prininfo.getName());
    }

    private boolean isAccept(Subject subject, String classname, String prinname) {
        if (logger.isDebugEnabled()) {
            logger.debug("subject is " + subject.toString());
            logger.debug("classname is " + classname);
            logger.debug("prinname is " + prinname);
        }
        Set<?> principalSet = null;
        try {
            Class<?> pClass = Class.forName(classname);
            principalSet = subject.getPrincipals(pClass);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00066), LogCodeManager.getMessage(LogCode.JFC00066, new String[0]));
            logger.debug("Failed to find principal object.", (Throwable)e);
        }
        if (principalSet == null) {
            logger.debug("principal set is null.");
            return false;
        }
        for (Principal principal : principalSet) {
            if (logger.isDebugEnabled()) {
                logger.debug("Principal " + principal.toString());
            }
            if (!prinname.equals(principal.getName())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("find principal " + prinname);
            }
            return true;
        }
        logger.debug("Failed to find principal " + prinname);
        return false;
    }

    private Permission createPermission(Permissioninfo perminfo) {
        Class[] PARAMS = new Class[]{String.class, String.class};
        try {
            Class<?> pClass = Class.forName(perminfo.getClassname());
            Constructor<?> constructor = pClass.getConstructor(PARAMS);
            Object[] params = new Object[]{perminfo.getName(), perminfo.getActions()};
            return (Permission)constructor.newInstance(params);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00067), LogCodeManager.getMessage(LogCode.JFC00067, new String[0]));
            logger.debug("Failed to create permission object.", (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private void addUserDefinedPermission(Permissions perms, UserInfo userinfo, Subject subject, Permission basep) {
        Set<JFCBasePrincipal> principalSet;
        block6: {
            principalSet = null;
            try {
                principalSet = subject.getPrincipals(JFCBasePrincipal.class);
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00066), LogCodeManager.getMessage(LogCode.JFC00066, new String[0]));
                logger.debug("Failed to find principal objects.", (Throwable)e);
                if (!logger.isDebugEnabled()) break block6;
                e.printStackTrace();
            }
        }
        if (principalSet == null) {
            return;
        }
        for (Principal principal : principalSet) {
            Permission[] permissions;
            if (logger.isDebugEnabled()) {
                logger.debug("Principal " + principal.toString());
            }
            if ((permissions = userinfo.getPermissions(principal)) == null) continue;
            String bname = basep != null ? basep.getName() : null;
            for (int i = 0; i < permissions.length; ++i) {
                if (bname != null && !permissions[i].getName().equals(bname)) continue;
                perms.add(permissions[i]);
            }
        }
    }
}

