/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.PresentationHelper;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class JFCControlUtil {
    private static final Logger logger = LogManager.getLogger(JFCControlUtil.class);
    private Set<String> skippableHelperClassNameSet = new HashSet<String>();

    public static Map<String, ControlType> getControlTypeMap(HttpServletRequest request, String modelname) {
        User user = JFCUtils.getUserInSession(request);
        if (user == null) {
            logger.debug("No user is found in the session.");
        }
        WebApplicationContext appctx = RequestContextUtils.findWebApplicationContext((HttpServletRequest)request);
        JFCControlUtil util = (JFCControlUtil)appctx.getBean("JFCControlUtil");
        return util.getControlTypeMap((ApplicationContext)appctx, request, user, modelname);
    }

    public static ControlType getControlType(HttpServletRequest request, String pmodelname, String modelitemname) {
        return JFCControlUtil.getControlType(request, null, pmodelname, modelitemname);
    }

    public static ControlType getControlType(HttpServletRequest request, String smodelname, String pmodelname, String modelitemname) {
        Object o;
        User user = JFCUtils.getUserInSession(request);
        if (user == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00133), LogCodeManager.getMessage(LogCode.JFC00133, new String[0]));
        }
        Object smodel = null;
        if (smodelname != null && (o = request.getAttribute(smodelname)) != null) {
            smodel = o;
        }
        WebApplicationContext appctx = RequestContextUtils.findWebApplicationContext((HttpServletRequest)request);
        JFCControlUtil util = (JFCControlUtil)appctx.getBean("JFCControlUtil");
        return util.getControlType((ApplicationContext)appctx, request, user, smodel, pmodelname, modelitemname);
    }

    protected ControlType getControlType(ActionParameter p, User user, Object obj, String pmodelname, String modelitemname) {
        if (pmodelname != null) {
            if (pmodelname.endsWith("_p")) {
                return this.getControlType0(p, user, obj, pmodelname.substring(0, pmodelname.length() - "_p".length()), modelitemname, "P");
            }
            if (pmodelname.endsWith("_lp")) {
                return this.getControlType0(p, user, obj, pmodelname.substring(0, pmodelname.length() - "_lp".length()), modelitemname, "Lp");
            }
            if (pmodelname.endsWith("_cp")) {
                return this.getControlType0(p, user, obj, pmodelname.substring(0, pmodelname.length() - "_cp".length()), modelitemname, "Cp");
            }
            if (pmodelname.endsWith("_ulp")) {
                return this.getControlType0(p, user, obj, pmodelname.substring(0, pmodelname.length() - "_ulp".length()), modelitemname, "Ulp");
            }
        }
        logger.warn("pmodelname is " + pmodelname + ", obj=" + (obj != null ? obj.getClass().getName() : null) + ",modelitemname=" + modelitemname);
        return ControlType.All;
    }

    protected ControlType getControlType0(ActionParameter p, User user, Object obj, String modelname, String modelitemname, String suffixType) {
        Object o;
        Method method;
        Object cp;
        modelitemname = modelitemname.replace('/', '$');
        String helperClassId = StringUtil.capFirst((String)modelname) + suffixType;
        String helperClassSkipKey = helperClassId + "#" + modelitemname;
        if (this.skippableHelperClassNameSet.contains(helperClassSkipKey)) {
            return ControlType.All;
        }
        String helperClassName = helperClassId + "Helper";
        Object phelper0 = p.appctx.getBean(helperClassName);
        if (phelper0 == null) {
            logger.warn(helperClassName + " is not found, modelname=" + modelname + ",modelitemname=" + modelitemname);
            return ControlType.All;
        }
        if (!(phelper0 instanceof PresentationHelper)) {
            logger.warn(helperClassName + " is not match PresentationHelper, modelname=" + modelname + ",modelitemname=" + modelitemname);
            return ControlType.All;
        }
        PresentationHelper phelper = (PresentationHelper)phelper0;
        if (p.user == null && user != null) {
            p.user = user;
        }
        String methodName = "getControlType_" + modelitemname;
        if (obj == null && "Cp".equals(suffixType) && (cp = p.request.getAttribute(modelname + "_cp")) != null) {
            try {
                Object object;
                Object object2;
                Method[] methods = phelper.getClass().getMethods();
                Method method2 = null;
                for (Method m : methods) {
                    if (!m.getName().equals("p2p")) continue;
                    method2 = m;
                    break;
                }
                if (method2 != null && (object2 = method2.invoke((Object)phelper, cp, p)) != null) {
                    cp = object2;
                }
                for (Method m : methods) {
                    Class<?>[] clazz;
                    if (!m.getName().equals("p2s") || (clazz = m.getParameterTypes()).length != 4) continue;
                    method2 = m;
                    break;
                }
                if (method2 != null && (object = method2.invoke((Object)phelper, cp, p, null, null)) != null) {
                    obj = object;
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (obj == null) {
            method = null;
            try {
                method = phelper.getClass().getMethod(methodName, User.class, ActionParameter.class);
            }
            catch (SecurityException e) {
                logger.warn("Failed to get '" + methodName + "' method, " + e);
                method = null;
            }
            catch (NoSuchMethodException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No method '" + methodName + "' in " + phelper.getClass().getName());
                }
                this.skippableHelperClassNameSet.add(helperClassSkipKey);
                method = null;
            }
            if (method == null) {
                return ControlType.All;
            }
            o = null;
            try {
                o = method.invoke((Object)phelper, user, p);
            }
            catch (IllegalArgumentException e) {
                logger.warn(helperClassName + "#" + methodName + " invoke error, " + obj.getClass().getName() + " " + modelitemname + " " + e);
            }
            catch (IllegalAccessException e) {
                logger.warn(helperClassName + "#" + methodName + " invoke error, " + obj.getClass().getName() + " " + modelitemname + " " + e);
            }
            catch (InvocationTargetException e) {
                logger.warn(helperClassName + "#" + methodName + " invoke error, " + obj.getClass().getName() + " " + modelitemname + " " + e);
            }
            if (o != null) {
                if (o instanceof ControlType) {
                    return (ControlType)((Object)o);
                }
                logger.warn(helperClassName + "#" + methodName + " returns illegal object, " + o.getClass().getName());
                return ControlType.All;
            }
            logger.warn(helperClassName + "#" + methodName + " returns null.");
            return ControlType.All;
        }
        method = null;
        try {
            method = phelper.getClass().getMethod(methodName, User.class, obj.getClass(), ActionParameter.class);
        }
        catch (SecurityException e) {
            logger.warn("Failed to get '" + methodName + "' method, " + obj.getClass() + " " + e);
            method = null;
        }
        catch (NoSuchMethodException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("No method '" + methodName + "' in " + phelper.getClass().getName() + " " + obj.getClass().getName());
            }
            this.skippableHelperClassNameSet.add(helperClassSkipKey);
            method = null;
        }
        if (method == null) {
            return ControlType.All;
        }
        o = null;
        try {
            o = method.invoke((Object)phelper, user, obj, p);
        }
        catch (IllegalArgumentException e) {
            logger.warn(helperClassName + "#" + methodName + " invoke error, " + obj.getClass().getName() + " " + e);
        }
        catch (IllegalAccessException e) {
            logger.warn(helperClassName + "#" + methodName + " invoke error, " + obj.getClass().getName() + " " + e);
        }
        catch (InvocationTargetException e) {
            logger.warn(helperClassName + "#" + methodName + " invoke error, " + obj.getClass().getName() + " " + e);
        }
        if (o != null) {
            if (o instanceof ControlType) {
                return (ControlType)((Object)o);
            }
            logger.warn(helperClassName + "#" + methodName + " returns illegal object, " + o.getClass().getName());
            return ControlType.All;
        }
        logger.warn(helperClassName + "#" + methodName + " returns null.");
        return ControlType.All;
    }

    protected Map<String, ControlType> getControlTypeMap(ApplicationContext appctx, HttpServletRequest request, User user, String pmodelname) {
        ActionParameter p = ActionParameter.createActionParameter(logger, user != null ? user.getUsername() : "", appctx);
        p.request = request;
        p.user = user;
        String beanname = this.getPHelperBeanNameMap().get(pmodelname);
        if (beanname != null) {
            return ((PresentationHelper)appctx.getBean(beanname)).getControlTypeMap(user, p);
        }
        throw new IllegalArgumentException("Unknown model " + pmodelname);
    }

    protected abstract Map<String, String> getPHelperBeanNameMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControlType getControlType(ApplicationContext appctx, HttpServletRequest request, User user, Object obj, String pmodelname, String modelitemname) {
        ActionParameter p = ActionParameter.createActionParameter(logger, user != null ? user.getUsername() : "", appctx);
        p.request = request;
        p.user = user;
        try {
            ControlType controlType = this.getControlType(p, user, obj, pmodelname, modelitemname);
            return controlType;
        }
        catch (ClassCastException e) {
            logger.warn("ClassCastException has detected, " + pmodelname, (Throwable)e);
            ControlType controlType = ControlType.All;
            return controlType;
        }
    }

    public static enum ControlType {
        Hidden,
        Readonly,
        All;

    }
}

