/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.ModelDataAccessManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public abstract class JFCDataAccessManager {
    private static final Logger logger = LogManager.getLogger(JFCDataAccessManager.class);
    protected Map<String, String> appctxidsMap = new HashMap<String, String>();

    public abstract String[] getAppctxids();

    public String findIdByModelname(String modelname) {
        return this.appctxidsMap.get(modelname);
    }

    public int getCountAll(ActionParameter p) {
        String[] appctxids;
        int sum = 0;
        for (String id : appctxids = this.getAppctxids()) {
            try {
                ModelDataAccessManager dam = (ModelDataAccessManager)p.appctx.getBean(id, ModelDataAccessManager.class);
                int count = dam.getCount(p);
                if (count < 0) continue;
                sum += count;
            }
            catch (NoSuchBeanDefinitionException e) {
                logger.error("Failed to get " + id);
            }
        }
        return sum;
    }

    public Map<String, String> getReplaceMap(String modelname, String[] pkey, ActionParameter p) {
        String id = this.findIdByModelname(modelname);
        if (id == null) {
            logger.error("Illegal modelname " + modelname);
            return null;
        }
        ModelDataAccessManager dam = (ModelDataAccessManager)p.appctx.getBean(id, ModelDataAccessManager.class);
        if (dam == null) {
            logger.error("Failed to get " + id);
            return null;
        }
        return dam.getReplaceMap(modelname, pkey, p);
    }

    public int getCount(String modelname, ActionParameter p) {
        String id = this.findIdByModelname(modelname);
        if (id == null) {
            return -1;
        }
        try {
            ModelDataAccessManager dam = (ModelDataAccessManager)p.appctx.getBean(id, ModelDataAccessManager.class);
            return dam.getCount(p);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.error("Failed to get " + id);
            return -1;
        }
    }
}

